/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerAuthentication;
import com.paterva.maltego.util.FastURL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransformServerInfo
implements StatusItem {
    private boolean _enabled = true;
    private boolean _dirty = true;
    private String _name;
    private FastURL _url;
    private Date _lastSync;
    private ProtocolVersion _protocolVersion;
    private Set<String> _transforms;
    private String _description;
    private TransformServerAuthentication _authentication = TransformServerAuthentication.None;
    private List<String> _seedUrls;

    public TransformServerInfo(String seedUrl, FastURL url, String name) {
        this(Collections.singletonList(seedUrl), url, name, "");
    }

    public TransformServerInfo(List<String> seedUrls, FastURL url, String name, String description) {
        this._seedUrls = new ArrayList<String>(seedUrls);
        this._url = url;
        this._name = name;
        this._description = description;
    }

    public List<String> getSeedUrls() {
        return Collections.unmodifiableList(this._seedUrls);
    }

    public void addSeedUrl(String seedUrl) {
        if (!this.containsIgnoreCase(seedUrl)) {
            this._seedUrls.add(seedUrl);
            this._dirty = true;
        }
    }

    private boolean containsIgnoreCase(String seedUrl) {
        for (String url : this._seedUrls) {
            if (!url.equalsIgnoreCase(seedUrl)) continue;
            return true;
        }
        return false;
    }

    public boolean removeSeedUrl(String seedUrl) {
        boolean removed = this.removeIgnoreCase(seedUrl);
        if (removed) {
            this._dirty = true;
        }
        return removed;
    }

    private boolean removeIgnoreCase(String url) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String seedUrl : this._seedUrls) {
            if (!seedUrl.equalsIgnoreCase(url)) continue;
            toRemove.add(seedUrl);
        }
        for (String seedUrl : toRemove) {
            this._seedUrls.remove(seedUrl);
        }
        return !toRemove.isEmpty();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markClean() {
        this._dirty = false;
    }

    public String getDefaultRepository() {
        return "Remote";
    }

    public String getHelpUrl(TransformDefinition transform) {
        return transform.getHelpUrl();
    }

    @Override
    public String getDisplayName() {
        return this._name;
    }

    @Override
    public void setDisplayName(String name) {
        if (this._name == null || !this._name.equals(name)) {
            this._name = name;
            this._dirty = true;
        }
    }

    public FastURL getUrl() {
        return this._url;
    }

    public void setUrl(FastURL url) {
        if (this._url == null || !this._url.equals((Object)url)) {
            this._url = url;
            this._dirty = true;
        }
    }

    public Date getLastSync() {
        return this._lastSync;
    }

    public void setLastSync(Date lastSync) {
        if (this._lastSync == null || !this._lastSync.equals(lastSync)) {
            this._lastSync = lastSync;
            this._dirty = true;
        }
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        if (this._protocolVersion != protocolVersion) {
            this._protocolVersion = protocolVersion;
            this._dirty = true;
        }
    }

    public Set<String> getTransforms() {
        if (this._transforms == null) {
            this._transforms = new HashSet<String>();
        }
        return this._transforms;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransformServerInfo) {
            return this.equals((TransformServerInfo)obj);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this._url != null ? this._url.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getDisplayName() + ": " + this.getUrl();
    }

    public boolean equals(TransformServerInfo info) {
        if (info == null) {
            return false;
        }
        return info.getUrl().equalsIgnoreCase(this.getUrl());
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._enabled != enabled) {
            this._enabled = enabled;
            this._dirty = true;
        }
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        if (this._description == null || !this._description.equals(description)) {
            this._description = description;
            this._dirty = true;
        }
    }

    public TransformServerAuthentication getAuthentication() {
        return this._authentication;
    }

    public void setAuthentication(TransformServerAuthentication authentication) {
        if (this._authentication != authentication) {
            this._authentication = authentication;
            this._dirty = true;
        }
    }

    @Override
    public Status getStatus() {
        if (this._enabled) {
            return Status.Ok;
        }
        return Status.Disabled;
    }

    public void setDirty() {
        this._dirty = true;
    }

    @Override
    public String getHtmlDisplayName() {
        return this.getDisplayName();
    }
}

