/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.FastURL;

public class TransformSeed {
    private String _name;
    private String _description;
    private FastURL _url;
    private boolean _enabled = true;
    private DisplayDescriptorCollection _globalTxProperties;
    private DataSources.Map _globalTxSettings;

    public TransformSeed(FastURL url, String name) {
        this(url, name, "", null, null);
    }

    public TransformSeed(FastURL url, String name, String description, DisplayDescriptorCollection globalTxProperties, DataSource globalTxSettings) {
        this._url = url;
        this._name = name;
        this._description = description;
        this._globalTxProperties = globalTxProperties;
        this._globalTxSettings = new DataSources.Map();
        if (globalTxProperties != null && globalTxSettings != null) {
            for (DisplayDescriptor property : globalTxProperties) {
                this._globalTxSettings.setValue((PropertyDescriptor)property, globalTxSettings.getValue((PropertyDescriptor)property));
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public FastURL getUrl() {
        return this._url;
    }

    public void setUrl(FastURL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        this._url = url;
    }

    public DisplayDescriptorCollection getGlobalTxProperties() {
        return this._globalTxProperties;
    }

    public void setGlobalTxProperties(DisplayDescriptorCollection globalTxProperties) {
        this._globalTxProperties = globalTxProperties;
    }

    public DataSources.Map getGlobalTxSettings() {
        return this._globalTxSettings;
    }

    public String toString() {
        return this.getName() + ": " + this.getUrl();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }
}

