/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import java.io.IOException;
import java.util.Set;
import org.openide.util.Lookup;

public abstract class TransformRepositoryRegistry {
    public static final String REMOTE = "Remote";
    public static final String LOCAL = "Local";
    public static final String GENERATED = "Generated";
    public static final String[] PERSISTED = new String[]{"Remote", "Local"};
    public static final String[] ALL = new String[]{"Remote", "Local", "Generated"};

    public static TransformRepositoryRegistry getDefault() {
        TransformRepositoryRegistry factory = (TransformRepositoryRegistry)Lookup.getDefault().lookup(TransformRepositoryRegistry.class);
        if (factory == null) {
            factory = new DefaultTransformRepositoryRegistry();
        }
        return factory;
    }

    public abstract TransformDefinition findTransform(String var1);

    public abstract TransformRepository getRepository(String var1);

    public abstract TransformRepository getOrCreateRepository(String var1) throws IOException;

    public abstract Set<TransformDefinition> find(TransformFilter var1);

    public abstract boolean removeTransform(String var1);

    private static class DefaultTransformRepositoryRegistry
    extends TransformRepositoryRegistry {
        private DefaultTransformRepositoryRegistry() {
        }

        @Override
        public TransformDefinition findTransform(String uniqueName) {
            throw new UnsupportedOperationException("No Transform Repository Registry found.");
        }

        @Override
        public TransformRepository getRepository(String name) {
            throw new UnsupportedOperationException("No Transform Repository Registry found.");
        }

        @Override
        public Set<TransformDefinition> find(TransformFilter filter) {
            throw new UnsupportedOperationException("No Transform Repository Registry found.");
        }

        @Override
        public TransformRepository getOrCreateRepository(String name) throws IOException {
            throw new UnsupportedOperationException("No Transform Repository Registry found.");
        }

        @Override
        public boolean removeTransform(String name) {
            throw new UnsupportedOperationException("No Transform Repository Registry found.");
        }
    }
}

