/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.typing.PropertyDescriptor;

public class PropertyConstraint {
    private Class _type;
    private boolean _nullable;
    private String _name;

    public PropertyConstraint(Class clazz) {
        this(clazz, null);
    }

    public PropertyConstraint(String name) {
        this(null, name);
    }

    public PropertyConstraint(Class clazz, String name) {
        this(clazz, name, true);
    }

    public PropertyConstraint(Class clazz, String name, boolean nullable) {
        this._type = clazz;
        this._name = name;
        this._nullable = nullable;
    }

    public Class getType() {
        return this._type;
    }

    public void setType(Class type) {
        this._type = type;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isSatisfiedBy(TypedPropertyBag entity) {
        for (PropertyDescriptor pd : entity.getProperties()) {
            if (this._type != null && pd.getType() != this._type || this._name != null && !this._name.equals(pd.getName())) continue;
            if (this._nullable) {
                return true;
            }
            Object value = entity.getValue(pd);
            boolean satisfied = value != null;
            return satisfied;
        }
        return false;
    }

    public String getDisplay() {
        StringBuilder builder = new StringBuilder();
        if (this._name != null) {
            builder.append(this._name);
        }
        if (this._name != null && this._type != null) {
            builder.append(" ");
        }
        if (this._type != null) {
            builder.append("(" + this._type + ")");
        }
        if (this._nullable) {
            builder.append("?");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplay();
    }
}

