/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.undo.BatchCommand;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.DefaultUndoRedoExecutor;
import com.paterva.maltego.graph.undo.GraphCommand;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import y.base.Graph;
import y.view.Graph2D;

public class GraphViewUndoRedoExecutor
extends DefaultUndoRedoExecutor {
    public void undo(Command cmd) {
        try {
            super.undo(cmd);
            if (cmd.isSignificant()) {
                StatusDisplayer.getDefault().setStatusText("Undo (" + cmd.getDescription() + ")");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.updateViews(cmd);
    }

    public void redo(Command cmd) {
        try {
            super.redo(cmd);
            if (cmd.isSignificant()) {
                StatusDisplayer.getDefault().setStatusText("Redo (" + cmd.getDescription() + ")");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.updateViews(cmd);
    }

    private void updateViews(Command cmd) {
        this.updateViews(this.getViewGraphs(this.getGraphIDs(cmd)));
    }

    private void updateViews(Set<Graph> graphs) {
        for (Graph graph : graphs) {
            if (!(graph instanceof Graph2D)) continue;
            ((Graph2D)graph).updateViews();
        }
    }

    private Set<GraphID> getGraphIDs(Command cmd) {
        HashSet<GraphID> graphs = new HashSet<GraphID>();
        if (cmd instanceof BatchCommand) {
            BatchCommand batchCmd = (BatchCommand)cmd;
            List commands = batchCmd.getCommands();
            for (Command command : commands) {
                graphs.addAll(this.getGraphIDs(command));
            }
        } else if (cmd instanceof GraphCommand) {
            GraphCommand graphCmd = (GraphCommand)cmd;
            graphs.add(graphCmd.getGraphID());
        }
        return graphs;
    }

    private Set<Graph> getViewGraphs(Set<GraphID> graphIDs) {
        HashSet<Graph> viewGraphs = new HashSet<Graph>();
        for (GraphID graphID : graphIDs) {
            Graph viewGraph = MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
            viewGraphs.add(viewGraph);
        }
        return viewGraphs;
    }
}

