/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.serialize;

import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicenseErrorDisplayer;
import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MachineIDProvider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class F {
    private static final Logger B = Logger.getLogger(F.class.getName());
    private static final String A = "Maltego.lic";
    private static final String C = "maltego.license.machine";

    public static void A(C licenseFile) throws IOException, GeneralSecurityException {
        File file = F.I(false);
        if (file != null) {
            byte[] blob = F.B(licenseFile.getBlob());
            byte[] signature = licenseFile.getSignature();
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                dos.writeInt(blob.length);
                dos.write(blob);
                dos.writeInt(signature.length);
                dos.write(signature);
            }
            if (Utilities.isWindows()) {
                file.setWritable(true, false);
            }
        }
    }

    public static Optional<D> F() {
        D license = null;
        try {
            Optional<C> licenseBlob;
            File file = F.I(true);
            if (file != null && file.exists() && (licenseBlob = F.A(file)).isPresent()) {
                List<String> rhs;
                license = licenseBlob.get().E();
                String[] ids = MachineIDProvider.getDefault().getIDCandidates(false);
                List<String> lhs = license.A();
                if (Collections.disjoint(lhs, rhs = Arrays.asList(ids))) {
                    String msg = String.format("Machine ID mismatch, removing license file. %s vs %s", lhs, rhs);
                    B.log(Level.WARNING, msg);
                    F.J(msg);
                    license = null;
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Optional.ofNullable(license);
    }

    public static void J(String msg) {
        File file = F.I(false);
        if (file != null && file.exists()) {
            file.delete();
            if (msg != null) {
                SwingUtilities.invokeLater(() -> LicenseErrorDisplayer.getDefault().show(msg));
            }
        }
    }

    public static boolean G() {
        boolean machineLicense = false;
        if (Utilities.isWindows()) {
            machineLicense = F.H().getBoolean(C, false);
        }
        return machineLicense;
    }

    public static void G(boolean machineLicense) {
        if (Utilities.isWindows()) {
            F.H().putBoolean(C, machineLicense);
        }
    }

    private static Optional<C> A(File file) throws IOException, GeneralSecurityException {
        C licenseBlob = null;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            byte[] blob = new byte[dis.readInt()];
            dis.readFully(blob);
            byte[] signature = new byte[dis.readInt()];
            dis.readFully(signature);
            licenseBlob = new C(F.A(blob), signature);
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Failed to read license.", ex);
        }
        if (!licenseBlob.isValidSignature()) {
            String msg = "License signature invalid, removing license file.";
            B.warning(msg);
            F.J(msg);
            licenseBlob = null;
        }
        return Optional.ofNullable(licenseBlob);
    }

    private static File I(boolean fallBackIfNotFound) {
        File fallbackFile;
        boolean machineLicense = F.G();
        File licFile = F.D(machineLicense);
        if (fallBackIfNotFound && (licFile == null || !licFile.exists()) && (fallbackFile = F.D(!machineLicense)) != null && fallbackFile.exists()) {
            licFile = fallbackFile;
            F.G(!machineLicense);
        }
        return licFile;
    }

    private static File D(boolean machineLicense) {
        File userDir = FileUtilities.getUserDir((boolean)machineLicense);
        File lf = null;
        if (userDir == null) {
            B.severe("Unable to determine license directory location");
        } else {
            File parentDir;
            File licenseFile;
            lf = licenseFile = new File(userDir, A);
            if (!machineLicense && (parentDir = userDir.getParentFile()) != null && parentDir.isDirectory()) {
                File parentDirLicenseFile = new File(parentDir, A);
                if (parentDirLicenseFile.exists()) {
                    if (licenseFile.exists()) {
                        licenseFile.delete();
                    }
                    lf = parentDirLicenseFile;
                } else {
                    try {
                        if (licenseFile.exists()) {
                            FileUtilities.copyFile((File)licenseFile, (File)parentDirLicenseFile);
                            licenseFile.delete();
                            lf = parentDirLicenseFile;
                        }
                    }
                    catch (IOException ex) {
                        B.log(Level.WARNING, "Failed to copy the license file: ", ex.toString());
                    }
                }
            }
        }
        return lf;
    }

    private static byte[] B(byte[] bytes) throws UnsupportedEncodingException, GeneralSecurityException {
        Cipher cipher = F.A();
        cipher.init(1, (Key)F.B(), F.E());
        return cipher.doFinal(bytes);
    }

    private static byte[] A(byte[] bytes) throws IOException, GeneralSecurityException {
        Cipher cipher = F.A();
        cipher.init(2, (Key)F.B(), F.E());
        return cipher.doFinal(bytes);
    }

    private static Cipher A() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("DESede/CBC/PKCS5Padding");
    }

    private static SecretKey B() throws UnsupportedEncodingException, GeneralSecurityException {
        DESedeKeySpec keySpec = new DESedeKeySpec("!BlUeM0nk3YsE@tTh0ughT5!".getBytes("UTF8"));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
        return keyFactory.generateSecret(keySpec);
    }

    private static IvParameterSpec E() throws UnsupportedEncodingException {
        return new IvParameterSpec("Q!UaMtun".getBytes("UTF-8"));
    }

    private static Preferences H() {
        return NbPreferences.forModule(F.class);
    }
}

