/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.rest;

import com.paterva.maltego.crypto.SignedData;
import com.paterva.maltego.licensing.ApiKeyProvider;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.PatervaUrl;
import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.licensing.serialize.H;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.rest.MaltegoRestExchange;
import com.paterva.maltego.rest.MaltegoRestRequest;
import com.paterva.maltego.rest.MaltegoRestResponse;
import com.paterva.maltego.rest.RestException;
import com.paterva.maltego.rest.StandardRestEntries;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class A {
    private static final Logger A = Logger.getLogger(A.class.getName());

    private A() {
    }

    public static J F(String version) throws LicensingException, IOException, GeneralSecurityException {
        String apiKey = ApiKeyProvider.get().orElse(null);
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(null, apiKey, null, null, true);
        entries.put("EulaVersion", version);
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.D(PatervaUrl.EULA, "MaltegoEulaRequest", entries, false);
        return com.paterva.maltego.licensing.rest.A.E(response);
    }

    public static String G(String licenseKey) throws GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(licenseKey);
        MaltegoRestRequest request = new MaltegoRestRequest("MaltegoLicenseRequest", entries);
        return request.getRequestBase64();
    }

    public static I H(String offlineResponse) throws GeneralSecurityException, IOException, RestException {
        MaltegoRestResponse response = new MaltegoRestResponse(offlineResponse, null, false);
        _A signedDataAndEula = com.paterva.maltego.licensing.rest.A.F(response);
        String nonce = null;
        return com.paterva.maltego.licensing.rest.A.E(nonce, signedDataAndEula);
    }

    public static I I(String licenseKey) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(licenseKey);
        _A signedDataAndEula = com.paterva.maltego.licensing.rest.A.E(entries);
        String nonce = entries.get("Nonce");
        return com.paterva.maltego.licensing.rest.A.E(nonce, signedDataAndEula);
    }

    private static I E(String nonce, _A signedDataAndEula) throws GeneralSecurityException, IOException {
        SignedData signedData = signedDataAndEula.B();
        J eula = signedDataAndEula.A().orElse(null);
        C blob = com.paterva.maltego.licensing.rest.A.D(nonce, signedData);
        return new I(blob, eula);
    }

    private static C D(String requestNonce, SignedData response) throws IOException, GeneralSecurityException {
        C licenseBlob = new C(response.getBlob(), response.getSignature());
        D license = licenseBlob.E();
        com.paterva.maltego.licensing.rest.A.A(requestNonce, license.G());
        return licenseBlob;
    }

    public static boolean B(String licenseKey, String hash) throws IOException, GeneralSecurityException {
        try {
            Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(licenseKey, null, hash, null, false);
            MaltegoRestExchange exchange = new MaltegoRestExchange(PatervaUrl.SAME.getUrl(), "MaltegoLicenseSameRequest", entries);
            exchange.setCheckNonce(false);
            exchange.setCheckStatus(false);
            exchange.sendRequest();
            String message = exchange.getResponse().getMessage();
            return Boolean.parseBoolean(message);
        }
        catch (RestException ex) {
            A.log(Level.WARNING, "Error while checking if license changed: {0}", ex.getMessage());
            return false;
        }
    }

    public static String E(String apiKey, J eula) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(null, apiKey, null, null, true);
        entries.put("DocumentVersion", eula.B());
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.D(PatervaUrl.LICENSE_AGREEMENT_PERSIST, "MaltegoLicenseAgreementPersistRequest", entries, false);
        return response.getText();
    }

    public static String C(String apiKey) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(null, apiKey, null, null, true);
        return com.paterva.maltego.licensing.rest.A.A(PatervaUrl.HUB, "MaltegoHubRequest", entries);
    }

    private static Map<String, String> E(String licenseKey) {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.E(licenseKey, null, null, null, false);
        return entries;
    }

    private static _A E(Map<String, String> entries) throws LicensingException {
        try {
            MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.D(PatervaUrl.ACTIVATE, "MaltegoLicenseRequest", entries, false);
            return com.paterva.maltego.licensing.rest.A.F(response);
        }
        catch (Exception ex) {
            if (ex instanceof LicensingException) {
                throw (LicensingException)ex;
            }
            throw new LicensingException(ex, true);
        }
    }

    private static _A F(MaltegoRestResponse response) throws GeneralSecurityException, IOException {
        SignedData data = response.getSignedData(true);
        J eula = com.paterva.maltego.licensing.rest.A.E(response);
        return new _A(data, eula);
    }

    private static J E(MaltegoRestResponse response) throws XmlSerializationException, IOException {
        XmlSerializer serializer = new XmlSerializer();
        H licenseResponse = (H)serializer.read(H.class, response.getText());
        com.paterva.maltego.licensing.serialize.D eulaStub = licenseResponse.A();
        return J.A(eulaStub.A(), eulaStub.B(), eulaStub.C());
    }

    private static String A(PatervaUrl url, String root, Map<String, String> entries) throws LicensingException, IOException, GeneralSecurityException {
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.D(url, root, entries, false);
        return response.getBlobPlain();
    }

    private static MaltegoRestResponse D(PatervaUrl url, String root, Map<String, String> entries, boolean skipStatusCheck) throws LicensingException, IOException, GeneralSecurityException {
        try {
            MaltegoRestExchange exchange = new MaltegoRestExchange(url.getUrl(), root, entries);
            exchange.setCheckNonce(false);
            exchange.setCheckStatus(!skipStatusCheck);
            exchange.sendRequest();
            return exchange.getResponse();
        }
        catch (RestException ex) {
            throw new LicensingException((Exception)((Object)ex), false);
        }
    }

    private static Map<String, String> E(String licenseKey, String apiKey, String hash, Map<String, String> addEntries, boolean machineIDsAppendRnd) {
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        Map entries = StandardRestEntries.get((String)apiKey, (boolean)(machineIDsAppendRnd ? licenseMode.E() : false));
        entries.put("LicenseKey", licenseKey);
        entries.put("Hash", hash);
        if (addEntries != null && !addEntries.isEmpty()) {
            entries.putAll(addEntries);
        }
        return entries;
    }

    private static void A(String requestNonce, String responseNonce) throws IOException {
        if (requestNonce != null && !Objects.equals(responseNonce, requestNonce)) {
            throw new IOException("Response does not match request.");
        }
    }

    private static class _A {
        private final SignedData B;
        private final J A;

        public _A(SignedData data, J eula) {
            Args.notNull((Object)data, (String)"data");
            this.B = data;
            this.A = eula;
        }

        public SignedData B() {
            return this.B;
        }

        public Optional<J> A() {
            return Optional.ofNullable(this.A);
        }
    }
}

