/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing;

import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class UserInfo {
    private String firstNames = "";
    private String lastName = "";
    private String email = "";
    private String country = "";
    private String alias = "";
    private String namespace = "";
    private String licenseType = "Unspecified";
    private Long validFrom;
    private Long validTo;

    public UserInfo() {
        this(LicenseManager.A().A(false));
    }

    public UserInfo(A licenseMode) {
        if (licenseMode.N()) {
            this.firstNames = com.paterva.maltego.licensing.free.A.U().orElse("");
            this.lastName = com.paterva.maltego.licensing.free.A.R().orElse("");
            this.email = com.paterva.maltego.licensing.free.A.O().orElse("");
            this.country = com.paterva.maltego.licensing.free.A.T().orElse("");
            this.alias = com.paterva.maltego.licensing.free.A.V().orElse("");
            this.namespace = com.paterva.maltego.licensing.free.A.S().orElse("");
            this.validFrom = com.paterva.maltego.licensing.free.A.J();
            this.validTo = com.paterva.maltego.licensing.free.A.Q();
            this.licenseType = "Maltego " + (licenseMode.H() ? "Community Edition" : "CaseFile");
        } else if (licenseMode.B()) {
            D license = licenseMode.A();
            this.firstNames = license.C();
            this.lastName = license.E();
            this.email = license.J();
            E capability = licenseMode.I().J();
            this.validFrom = capability.E();
            this.validTo = capability.D();
            this.licenseType = capability.C();
        }
    }

    public String getFirstNames() {
        return this.firstNames;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return Stream.of(this.firstNames, this.lastName).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.joining(" "));
    }

    public String getEmail() {
        return this.email;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Long getValidFrom() {
        return this.validFrom;
    }

    public Long getValidTo() {
        return this.validTo;
    }

    public String getLicenseType() {
        return this.licenseType;
    }
}

