/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.ProgressHandleAdapter;
import com.paterva.maltego.transform.finder.wizard.SeedUtils;
import com.paterva.maltego.transform.finder.wizard.UpdateResultPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateResultText;
import com.paterva.maltego.transform.finder.wizard.UpdateTransformsController;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class InitialUpdateController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateResultPanel, FailurePanel> {
    public InitialUpdateController() {
        this.setName("Install Transforms");
        this.setDescription("A summary of the progress to install items from the chosen transform server is shown below.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws DiscoveryException {
        TransformSeed[] selectedSeeds;
        TransformFinder finder = TransformFinder.getDefault();
        ProgressHandleAdapter progress = new ProgressHandleAdapter(handle);
        boolean freeOnline = Boolean.TRUE.equals(descriptor.getProperty("licensing.online"));
        HubSeedDescriptor hubSeed = (HubSeedDescriptor)descriptor.getProperty("hubItem");
        if (freeOnline) {
            HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
            HubSeedDescriptor mainSeed = SeedUtils.getMainPatervaSeed(seeds);
            ArrayList<TransformSeed> selectedSeedsList = new ArrayList<TransformSeed>();
            if (mainSeed != null) {
                selectedSeedsList.add(HubSeedRegistry.getDefault().getTransformSeed(mainSeed));
            }
            selectedSeeds = selectedSeedsList.toArray(new TransformSeed[selectedSeedsList.size()]);
        } else {
            selectedSeeds = (TransformSeed[])descriptor.getProperty("transformSeeds");
        }
        if (selectedSeeds == null || selectedSeeds.length == 0) {
            return null;
        }
        DiscoveryResult references = finder.findServers(selectedSeeds, (ProgressCallback)progress);
        if (references.getData() == null || ((TransformServerReference[])references.getData()).length == 0) {
            throw new DiscoveryException("No transforms were found");
        }
        DiscoveryResult details = finder.getDetails((TransformServerReference[])references.getData(), (ProgressCallback)progress);
        if (details.getData() == null || ((TransformServerDetail[])details.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        DiscoveryResult listings = finder.listTransforms((TransformServerDetail[])details.getData(), (ProgressCallback)progress);
        if (listings.getData() == null || ((TransformServerListing[])listings.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        handle.progress("Updating transforms and entities...");
        HubSeedSettings seedSettings = HubSeedSettings.getDefault();
        HubSeedRegistry seedRegistry = HubSeedRegistry.getDefault();
        try {
            TransformUpdater updater = TransformUpdater.getDefault();
            updater.updateServers((TransformServerListing[])listings.getData());
            Exception[] errors = references.getErrors();
            if (errors == null || errors.length == 0) {
                updater.removeMissingServers((TransformServerReference[])references.getData());
            }
            updater.update(hubSeed, (TransformServerListing[])listings.getData(), DiscoveryMergingRules.getDefault());
            for (TransformSeed selectedSeed : selectedSeeds) {
                String url = selectedSeed.getUrl().toString();
                HubSeedDescriptor seed = seedRegistry.getSeeds(false).getSeed(null, url);
                seedSettings.setInstalled(seed, true);
            }
        }
        catch (IOException ex) {
            throw new DiscoveryException((Throwable)ex);
        }
        return listings;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected UpdateResultPanel createPassComponent() {
        return new UpdateResultPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateResultPanel component, DiscoveryResult<TransformServerListing> result) {
        if (result == null) {
            component.setNoSeeds();
        } else {
            UpdateResultText urt = new UpdateResultText();
            component.setText(urt.get((TransformServerListing[])result.getData()));
            component.setDuplicateTransforms(UpdateTransformsController.getDuplicateTransforms((TransformServerListing[])result.getData()));
        }
        DiscoverySettings.setDiscoveryComplete(true);
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else {
            component.setError(e.getMessage());
        }
    }
}

