/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.finder.wizard.ChooseSeedsControl;
import com.paterva.maltego.transform.finder.wizard.SeedUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.net.URL;
import java.util.ArrayList;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class ChooseSeedsController
extends ValidatingController<ChooseSeedsControl> {
    private static final String ERROR_LOCAL_SERVER_URL = "Please enter a valid URL for the local Maltego server";

    public ChooseSeedsController() {
        this.setName("Select Transform Server");
        this.setDescription("Install transforms from the Maltego public servers and/or local servers. Transforms can be managed later from the Transform Hub.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected ChooseSeedsControl createComponent() {
        ChooseSeedsControl control = new ChooseSeedsControl();
        control.addChangeListener(this.changeListener());
        return control;
    }

    protected String getFirstError(ChooseSeedsControl component) {
        if (component.isLocalSeedEnabled()) {
            String url = component.getLocalSeedUrl();
            if (StringUtilities.isNullOrEmpty((String)url)) {
                return ERROR_LOCAL_SERVER_URL;
            }
            try {
                new URL(url).toString();
            }
            catch (Exception ex) {
                return ERROR_LOCAL_SERVER_URL;
            }
        }
        return null;
    }

    protected void readSettings(WizardDescriptor settings) {
        boolean isBuiltInSeedsEnabled;
        HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
        HubSeedDescriptor mainSeed = SeedUtils.getMainPatervaSeed(seeds);
        settings.putProperty("mainSeed", (Object)mainSeed);
        String localSeedUrl = (String)settings.getProperty("localSeedUrl");
        Boolean isLocalSeedEnabled = (Boolean)settings.getProperty("localSeedEnabled");
        boolean bl = isBuiltInSeedsEnabled = mainSeed != null;
        if (isLocalSeedEnabled == null) {
            isLocalSeedEnabled = Boolean.FALSE;
        }
        ((ChooseSeedsControl)this.component()).setMainSeedEnabled(isBuiltInSeedsEnabled);
        ((ChooseSeedsControl)this.component()).setMainSeedSelected(isBuiltInSeedsEnabled);
        ((ChooseSeedsControl)this.component()).setLocalSeedEnabled(isLocalSeedEnabled);
        ((ChooseSeedsControl)this.component()).setLocalSeedUrl(localSeedUrl);
    }

    protected void storeSettings(WizardDescriptor settings) {
        boolean isBuiltInSeedsSelected = ((ChooseSeedsControl)this.component()).isMainSeedSelected();
        boolean isLocalSeedEnabled = ((ChooseSeedsControl)this.component()).isLocalSeedEnabled();
        String localSeedUrl = ((ChooseSeedsControl)this.component()).getLocalSeedUrl();
        HubSeedDescriptor mainSeed = (HubSeedDescriptor)settings.getProperty("mainSeed");
        HubSeedDescriptor localHubSeed = (HubSeedDescriptor)settings.getProperty("localHubSeed");
        ArrayList<TransformSeed> selectedSeedsList = new ArrayList<TransformSeed>();
        if (isBuiltInSeedsSelected) {
            selectedSeedsList.add(HubSeedRegistry.getDefault().getTransformSeed(mainSeed));
        }
        if (localHubSeed != null) {
            HubSeedRegistry.getDefault().removeSeed(localHubSeed, true);
        }
        TransformSeed localSeed = null;
        if (isLocalSeedEnabled && !StringUtilities.isNullOrEmpty((String)localSeedUrl)) {
            localHubSeed = new HubSeedDescriptor();
            localHubSeed.setName("localservertransforms");
            localHubSeed.setDisplayName("Local Server Transforms");
            localHubSeed.setUrl(new HubSeedUrl(localSeedUrl));
            HubSeedRegistry.getDefault().addSeed(localHubSeed);
            localSeed = HubSeedRegistry.getDefault().getTransformSeed(localHubSeed);
            selectedSeedsList.add(localSeed);
        }
        TransformSeed[] seeds = (TransformSeed[])selectedSeedsList.stream().toArray(TransformSeed[]::new);
        settings.putProperty("allTransformSeeds", (Object)seeds);
        settings.putProperty("transformSeeds", (Object)seeds);
        settings.putProperty("localSeedEnabled", (Object)isLocalSeedEnabled);
        settings.putProperty("localSeedUrl", (Object)localSeedUrl);
        settings.putProperty("localSeed", (Object)localSeed);
        settings.putProperty("localHubSeed", (Object)localHubSeed);
    }
}

