/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.finder.SeedDiscoveryManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class UpdateInstalledSeedsAction
extends CallableSystemAction {
    public UpdateInstalledSeedsAction() {
        this.updateTooltip(null);
        SeedDiscoveryManager.getDefault().addPropertyChangeListener(evt -> SwingUtilities.invokeLater(() -> {
            if ("installingHubSeed".equals(evt.getPropertyName())) {
                boolean installing = evt.getNewValue() != null;
                this.setEnabled(!installing);
            } else if ("uninstallingHubSeed".equals(evt.getPropertyName())) {
                boolean uninstalling = evt.getNewValue() != null;
                this.setEnabled(!uninstalling);
            } else if ("updating".equals(evt.getPropertyName())) {
                boolean updating = (Boolean)evt.getNewValue();
                this.setEnabled(!updating);
                this.updateTooltip(updating ? "Updating..." : null);
            }
        }));
    }

    public void performAction() {
        new Thread(() -> {
            SeedDiscoveryManager sdm = SeedDiscoveryManager.getDefault();
            TransformSeed[] certAllowedTransformSeeds = sdm.getCertAllowedTransformSeeds(true);
            sdm.updateInstalled(certAllowedTransformSeeds);
        }, "Update Transforms").start();
    }

    protected String iconResource() {
        return null;
    }

    public String getName() {
        return "[UPDATE]";
    }

    private String getTooltip() {
        String tooltip = "Update Transforms";
        Date date = SeedDiscoveryManager.getDefault().getLastUpdateDate();
        if (date != null) {
            tooltip = tooltip + " (last updated " + new SimpleDateFormat().format(date) + ")";
        }
        return tooltip;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void updateTooltip(String text) {
        String tooltip = text != null ? text : this.getTooltip();
        AbstractButton button = (AbstractButton)this.getToolbarPresenter();
        button.setToolTipText(tooltip);
        this.putValue("ShortDescription", tooltip);
    }

    protected boolean asynchronous() {
        return false;
    }
}

