/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.problemreport.settings;

import com.paterva.maltego.util.MachineIDProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class ProblemReportOptions {
    private static final ProblemReportOptions INSTANCE = new ProblemReportOptions();
    private static final String PREF_PROMPT_COMPLETED = "AutoSendPromptCompleted";
    private static final String PREF_AUTO_SEND = "AutoSendExceptions";
    private static final String PREF_MACHINE_ID_HASH = "ProblemReportMachineIdHash";

    public static ProblemReportOptions getDefault() {
        return INSTANCE;
    }

    public boolean isAutoSendPromptCompleted() {
        return this.getPreferences().getBoolean(PREF_PROMPT_COMPLETED, false);
    }

    public boolean isAutoSendExceptions() {
        return this.getPreferences().getBoolean(PREF_AUTO_SEND, false);
    }

    public void setAutoSendExceptions(boolean autoSendExceptions) {
        this.getPreferences().putBoolean(PREF_PROMPT_COMPLETED, true);
        this.getPreferences().putBoolean(PREF_AUTO_SEND, autoSendExceptions);
    }

    public String getMachineIdHash() {
        Preferences prefs = this.getPreferences();
        String hash = prefs.get(PREF_MACHINE_ID_HASH, null);
        if (hash == null) {
            hash = this.generateMachineIdHash();
            prefs.put(PREF_MACHINE_ID_HASH, hash);
        }
        return hash;
    }

    private String generateMachineIdHash() {
        String hash = null;
        try {
            String id = MachineIDProvider.getDefault().getUniqueID();
            if (id == null) {
                id = UUID.randomUUID().toString();
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hashBytes = digest.digest(id.getBytes());
            hash = Base64.getEncoder().encodeToString(hashBytes);
            hash = hash.substring(0, 6);
        }
        catch (NoSuchAlgorithmException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return hash;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass());
    }
}

