/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.outline;

import com.paterva.maltego.util.ui.outline.NodeQuickFilter;
import com.paterva.maltego.util.ui.outline.TableSearchPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.swing.etable.ETable;
import org.openide.explorer.view.OutlineView;
import org.openide.util.actions.Presenter;

public class OutlineViewPanel
extends JPanel {
    private final TableSearchPanel _searchPanel = new TableSearchPanel();
    private OutlineView _view;
    private JToolBar _toolbar;

    public OutlineViewPanel() {
        this((String)null);
    }

    public OutlineViewPanel(String title) {
        this.initComponents();
        this._view = title != null ? new OutlineView(title) : new OutlineView();
        Color gridColor = UIManager.getLookAndFeelDefaults().getColor("Table.gridColor");
        this._view.getOutline().setFullyNonEditable(true);
        this._view.getOutline().setBorder(null);
        this._view.getOutline().setShowHorizontalLines(true);
        this._view.getOutline().setGridColor(gridColor);
        this.add((Component)this._view, "Center");
        this._searchPanel.setTable((ETable)this._view.getOutline());
        this._searchPanel.setMaximumSize(new Dimension(150, 30));
        this._searchPanel.setFilter(new NodeQuickFilter());
        this._toolbar.add(Box.createHorizontalGlue());
        this._toolbar.add(this._searchPanel);
        this._view.getOutline().setRootVisible(false);
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(800, 500));
        this.setLayout(new BorderLayout());
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this.add((Component)this._toolbar, "First");
    }

    public OutlineView getView() {
        return this._view;
    }

    public TextQuickFilter getFilter() {
        return this._searchPanel.getFilter();
    }

    public void setFilter(TextQuickFilter filter) {
        this.setFilter(filter, 0);
    }

    public void setFilter(TextQuickFilter filter, int column) {
        this._searchPanel.setFilter(filter, column);
    }

    public void removeFromToolbarLeft() {
        this._toolbar.remove(0);
    }

    public void addToToolbarLeft(Component component) {
        this._toolbar.add(component, 0);
    }

    public void addToToolbarRight(Component component) {
        this._toolbar.add(component);
    }

    public void addToToolbarLeft(Action action) {
        if (action instanceof Presenter.Toolbar) {
            Component c = ((Presenter.Toolbar)action).getToolbarPresenter();
            this._toolbar.add(c, 0);
        } else {
            JButton c = this._toolbar.add(action);
            this._toolbar.remove(c);
            this._toolbar.add((Component)c, 0);
        }
    }

    public void addToToolbarRight(Action action) {
        if (action instanceof Presenter.Toolbar) {
            Component c = ((Presenter.Toolbar)action).getToolbarPresenter();
            this._toolbar.add(c);
        } else {
            this._toolbar.add(action);
        }
    }
}

