/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.filechooser;

import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import org.openide.windows.WindowManager;

public class SaveValidationFileChooser
extends JFileChooser {
    private final AtomicBoolean _updatingMustSave = new AtomicBoolean(false);

    public SaveValidationFileChooser() {
        this.setUpdatingMustSave(true);
        this.addPropertyChangeListener("ApproveSelection_Custom", evt -> {
            if (this._updatingMustSave.compareAndSet(false, true)) {
                FileChooserUtil.mustSave(this);
                this.setUpdatingMustSave(false);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        WindowManager.getDefault().invokeWhenUIReady(() -> this.setUpdatingMustSave(false));
    }

    @Override
    public void approveSelection() {
        if (this._updatingMustSave.compareAndSet(false, true)) {
            if (FileChooserUtil.mustSave(this)) {
                super.approveSelection();
            }
            this.setUpdatingMustSave(false);
        }
    }

    private void setUpdatingMustSave(boolean state) {
        this._updatingMustSave.set(state);
    }
}

