/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.EventListenerList;

public class ImageBoundsRadioButtons
extends JPanel {
    private final GridBagLayout _gridBagLayout = new GridBagLayout();
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private final JRadioButton _wholeGraphRadio = new JRadioButton("Whole graph");
    private final JRadioButton _viewOnlyRadio = new JRadioButton("Current view only");
    private GridBagConstraints _gbc;
    private boolean _wholeGraph;
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private EventListenerList _listeners;

    private ImageBoundsRadioButtons() {
    }

    public ImageBoundsRadioButtons(boolean wholeGraph) {
        this.init(wholeGraph);
    }

    private void init(boolean wholeGraph) {
        this._updating.set(true);
        this._wholeGraph = wholeGraph;
        this.setLayout(this._gridBagLayout);
        this._buttonGroup.add(this._wholeGraphRadio);
        this._wholeGraphRadio.addActionListener(evt -> {
            if (this._updating.compareAndSet(false, true)) {
                this.setWholeGraph(true);
                this.fireActionEvent(evt);
                this._updating.set(false);
            }
        });
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 10, 0);
        this.add((Component)this._wholeGraphRadio, this._gbc);
        this._buttonGroup.add(this._viewOnlyRadio);
        this._viewOnlyRadio.addActionListener(evt -> {
            if (this._updating.compareAndSet(false, true)) {
                this.setWholeGraph(false);
                this.fireActionEvent(evt);
                this._updating.set(false);
            }
        });
        this._gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 10, 0);
        this.add((Component)this._viewOnlyRadio, this._gbc);
        this._updating.set(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._updating.set(true);
        this._buttonGroup.setSelected(this._wholeGraph ? this._wholeGraphRadio.getModel() : this._viewOnlyRadio.getModel(), true);
        this._updating.set(false);
    }

    private void setWholeGraph(boolean wholeGraph) {
        this._wholeGraph = wholeGraph;
    }

    public boolean isWholeGraph() {
        return this._wholeGraph;
    }

    public void addActionListener(ActionListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(ActionListener.class, listener);
        }
    }

    protected void fireActionEvent(ActionEvent evt) {
        if (this._listeners != null) {
            for (ActionListener listener : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                listener.actionPerformed(evt);
            }
        }
    }
}

