/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

public class WindowUtil {
    public static int _showCount = 0;
    private static Frame win;

    public static void showWaitCursor() {
        Component glassPane;
        if (++_showCount == 1 && (glassPane = WindowUtil.getMainWindowGlassPane()) != null) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        }
    }

    public static void hideWaitCursor() {
        Component glassPane;
        if (--_showCount == 0 && (glassPane = WindowUtil.getMainWindowGlassPane()) != null) {
            glassPane.setVisible(false);
        }
    }

    public static void showWaitCursor(JComponent component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void hideWaitCursor(JComponent component) {
        component.setCursor(null);
    }

    private static Component getMainWindowGlassPane() {
        Component glassPane = null;
        Frame mainWindow = WindowUtil.getMainWindow();
        if (mainWindow instanceof JFrame) {
            JFrame frame = (JFrame)mainWindow;
            glassPane = frame.getGlassPane();
        }
        return glassPane;
    }

    public static Frame getMainWindow() {
        if (win == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                win = WindowManager.getDefault().getMainWindow();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            win = WindowManager.getDefault().getMainWindow();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return win;
    }
}

