/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.ui.components.HeadingTextAndIcon;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class HtmlUIUtils {
    public static JPanel getHtmlLinkDialog(String plainHeading, Image image, String html) {
        HeadingTextAndIcon headingPane = new HeadingTextAndIcon();
        headingPane.setText(plainHeading);
        headingPane.addIcon(image);
        headingPane.setInsets(new Insets(0, 0, 6, 0));
        JEditorPane linkPane = new JEditorPane("text/html", "<html><body style='color: white; font-size:" + FontUtils.defaultScaled(-2.0f).getSize() + "px'>" + html + "</body></html>");
        linkPane.addHyperlinkListener(event -> {
            if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(event.getURL());
            }
        });
        linkPane.setPreferredSize(new Dimension(500, 200));
        linkPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        linkPane.setBackground(headingPane.getTextBackground());
        linkPane.setEditable(false);
        linkPane.setCaretPosition(0);
        PanelWithMatteBorderAllSides borderPanel = new PanelWithMatteBorderAllSides(new BorderLayout(0, 0));
        borderPanel.add((Component)headingPane, "North");
        borderPanel.add((Component)linkPane, "Center");
        return borderPanel;
    }

    public static void showModelExcludeHtmlFrame(String plainFrameTitle, String html) {
        final JEditorPane editPane = new JEditorPane("text/html", html);
        editPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String desc = evt.getDescription();
                    if (desc == null || !desc.startsWith("#")) {
                        return;
                    }
                    desc = desc.substring(1);
                    editPane.scrollToReference(desc);
                }
            }
        });
        editPane.setEditable(false);
        editPane.setCaretPosition(0);
        JFrame frame = new JFrame(plainFrameTitle);
        frame.setIconImages(WindowManager.getDefault().getMainWindow().getIconImages());
        frame.setLayout(new BorderLayout());
        frame.add(new JScrollPane(editPane));
        frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        if (GraphicsUtil.useCustomLafFrameDecorations((boolean)false)) {
            frame.getRootPane().setWindowDecorationStyle(2);
        }
        frame.setSize(760, 600);
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        Rectangle screenBounds = mainWindow.getGraphicsConfiguration().getBounds();
        int x = (screenBounds.width - frame.getWidth()) / 2 + screenBounds.x;
        int y = (screenBounds.height - frame.getHeight()) / 2 + screenBounds.y;
        frame.setLocation(x, y);
        frame.setVisible(true);
    }

    public static String appendStyleSheet(String html, String stylePath, String[] styleColors) {
        AbstractStringBuilder sb;
        UIDefaults LAF = UIManager.getLookAndFeelDefaults();
        String style = "";
        try {
            style = HtmlUIUtils.loadFromFile(stylePath);
            for (String color : styleColors) {
                Color lafColor = LAF.getColor(color);
                style = style.replace(color, String.format("#%02x%02x%02x", lafColor.getRed(), lafColor.getGreen(), lafColor.getBlue()));
            }
            sb = new StringBuffer(style.length());
            Matcher match = Pattern.compile("font-size:([^p]*)px").matcher(style);
            while (match.find()) {
                String number = match.group(1).trim();
                Font font = new JLabel().getFont().deriveFont(Float.parseFloat(number));
                font = FontUtils.scale(font);
                String s = "font-size: " + font.getSize() + "px";
                match.appendReplacement((StringBuffer)sb, Matcher.quoteReplacement(s));
            }
            match.appendTail((StringBuffer)sb);
            style = ((StringBuffer)sb).toString();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        sb = new StringBuilder(html);
        int headerEndIndex = ((StringBuilder)sb).indexOf("</head>");
        if (headerEndIndex < 0) {
            headerEndIndex = 0;
        }
        ((StringBuilder)sb).insert(headerEndIndex, String.format("<style type=\"text/css\">%n%s%n\t</style>%n", style));
        return ((StringBuilder)sb).toString();
    }

    public static String loadFromFile(String path) throws IOException {
        FileObject file = FileUtil.getConfigRoot().getFileObject(path);
        if (file != null) {
            return file.asText();
        }
        return null;
    }

    public static String substituteImageURLs(String html, Class clazz, String imageBasePath, String[] imagesToReplace) {
        for (String image : imagesToReplace) {
            html = html.replace(image, clazz.getResource(imageBasePath + image).toString());
        }
        return html;
    }
}

