/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jdesktop.swingx.color.ColorUtil;

public class GraphicsUtils {
    private static final Color HOVER_COLOR = UIManager.getLookAndFeelDefaults().getColor("7-focus-color");
    private static final Color RIBBON_ICON_BLACK = UIManager.getLookAndFeelDefaults().getColor("bookmark-none-color");
    private static final Color BLACK_ALPHA_20 = new Color(0, 0, 0, 20);
    private static final BufferedImage BUFFERED_IMAGE = new BufferedImage(1, 1, 1);
    private static final boolean JAVA9_UP = !SystemInfo.isJava8();
    private static GraphicsConfiguration DEFAULT_SCREEN_GRAPHICS_ENVIRONMENT = null;

    public static Graphics2D createGraphics2D() {
        Graphics2D g2D = BUFFERED_IMAGE.createGraphics();
        GraphicsUtil.setupTextAntialiasing((Graphics)g2D, null);
        return g2D;
    }

    public static double getZoom(Graphics2D g2D) {
        if (g2D != null) {
            double scaleFactor = GraphicsUtils.getScaleFactor(g2D.getDeviceConfiguration());
            return g2D.getTransform().getScaleX() / scaleFactor;
        }
        return 1.0 / GraphicsUtils.getScaleFactor(null);
    }

    private static double getScaleFactor(GraphicsConfiguration gc) {
        if (JAVA9_UP) {
            if (DEFAULT_SCREEN_GRAPHICS_ENVIRONMENT == null) {
                DEFAULT_SCREEN_GRAPHICS_ENVIRONMENT = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            AffineTransform transform = (gc == null ? DEFAULT_SCREEN_GRAPHICS_ENVIRONMENT : gc).getDefaultTransform();
            return transform.getScaleX();
        }
        return 1.0;
    }

    public static void drawShadedFatPentagram(Graphics2D g2D, int x, int y, int w, int h, Color color1, Color color2) {
        GraphicsUtils.drawShadedFatPentagram(g2D, x, y, w, h, color1, color1, color2, true, false);
    }

    public static void drawShadedFatPentagram(Graphics2D g2D, int x, int y, int w, int h, Color color, boolean shade, boolean darkOutline) {
        Color brightColor = ColorUtilities.brighterTranslucent((Color)color, (int)50, (int)color.getAlpha());
        GraphicsUtils.drawShadedFatPentagram(g2D, x, y, w, h, color, brightColor, color, shade, darkOutline);
    }

    public static void drawShadedFatPentagram(Graphics2D g2D, int x, int y, int w, int h, Color color, Color shadeColor1, Color shadeColor2, boolean shade, boolean darkOutline) {
        Color darkColor = new Color(50, 50, 50, color.getAlpha());
        double[] xPointsPenta = new double[]{0.5, 0.64, 0.95, 0.74, 0.77, 0.5, 0.23, 0.26, 0.05, 0.36};
        double[] yPointsPenta = new double[]{0.0, 0.27, 0.33, 0.57, 0.88, 0.73, 0.88, 0.57, 0.33, 0.27};
        int[] xPoints = new int[xPointsPenta.length];
        int[] yPoints = new int[xPointsPenta.length];
        int margin = 3;
        double roundingAdjustment = 0.5;
        for (int i = 0; i < xPoints.length; ++i) {
            xPoints[i] = x + (int)((double)(w - 6) * xPointsPenta[i] + 0.5) + 3;
            yPoints[i] = y + (int)((double)(h - 6) * yPointsPenta[i] + 0.5) + 3;
        }
        if (shade) {
            GradientPaint paint = new GradientPaint(x, y, shadeColor1, x + w, y + h, shadeColor2);
            g2D.setPaint(paint);
        } else {
            g2D.setColor(color);
        }
        g2D.fillPolygon(xPoints, yPoints, xPoints.length);
        if (darkOutline) {
            g2D.setStroke(new BasicStroke(5.0f, 1, 1));
            g2D.setColor(Color.BLACK);
        } else {
            g2D.setStroke(new BasicStroke(2.0f, 1, 1));
            g2D.setColor(darkColor);
        }
        g2D.drawPolygon(xPoints, yPoints, xPoints.length);
    }

    public static void drawPaperClip(Graphics2D g2D, double xPos, double yPos) {
        AffineTransform oldTransform = g2D.getTransform();
        double scale = 0.5;
        g2D.scale(scale, scale);
        double x = xPos / scale;
        double y = yPos / scale;
        g2D.translate(x, y);
        double height = 12.0 / scale;
        double width = 6.0 / scale;
        double margin = 2.0 / scale;
        double[] xPoints = new double[]{width, width, width / 2.0, 0.0, 0.0, width - margin, width - margin, width / 2.0, margin, margin};
        double[] yPoints = new double[]{margin, height - width / 2.0, height, height - width / 2.0, 0.0, 0.0, height - width / 2.0 - margin, height - margin * 2.0, height - width / 2.0 - margin, margin};
        g2D.setColor(RIBBON_ICON_BLACK);
        g2D.setStroke(new BasicStroke(2.2f));
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < xPoints.length; ++i) {
            ((Path2D)path).lineTo(xPoints[i], yPoints[i]);
        }
        g2D.draw(path);
        g2D.setTransform(oldTransform);
    }

    public static void drawBookMark(Graphics2D g2D, int x, int y, int w, int h, Color fillColor, boolean hovered) {
        Color lineColor = hovered ? Color.BLACK : fillColor.darker();
        float lineWidth = GraphicsUtils.getLineWidth(hovered);
        int newH = (int)((float)h * 0.8f);
        int newW = (int)((float)w * 0.8f);
        int boxHeight = (int)((float)newH / 5.0f * 3.0f);
        int boxWidth = (int)((float)newW * 0.8f);
        int newX = x + (w - newW) / 2 + (newW - boxWidth) / 2;
        int newY = y + (h - newH) / 2;
        g2D.translate(newX, newY);
        int[] xPoints = new int[]{0, boxWidth, boxWidth, (int)((float)boxWidth / 2.0f), 0, 0};
        int[] yPoints = new int[]{0, 0, newH, boxHeight, newH, 0};
        g2D.setColor(fillColor);
        g2D.fillPolygon(xPoints, yPoints, xPoints.length);
        g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2D.setColor(lineColor);
        g2D.drawPolygon(xPoints, yPoints, xPoints.length);
        g2D.translate(-newX, -newY);
    }

    public static void drawPin(Graphics2D g2D, double x, double y, double size, boolean pinned, boolean hovered, boolean black) {
        float lineWidth;
        Color lineColor;
        Color fillColor;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (black) {
            fillColor = RIBBON_ICON_BLACK;
            lineColor = Color.BLACK;
            lineWidth = 0.0f;
        } else {
            fillColor = pinned ? laf.getColor("pin-color") : GraphicsUtils.getTransparentGrey();
            lineColor = hovered ? Color.BLACK : fillColor.darker();
            lineWidth = GraphicsUtils.getLineWidth(hovered);
        }
        double[] xPointsPenta = new double[]{0.0, 0.25, 0.1, 0.2, 0.4, 0.6, 0.6, 1.0, 0.8, 0.6, 0.6, 0.5, 0.35};
        double[] yPointsPenta = new double[]{1.0, 0.65, 0.5, 0.4, 0.4, 0.2, 0.0, 0.4, 0.4, 0.6, 0.8, 0.9, 0.75};
        double[] xPoints = new double[xPointsPenta.length];
        double[] yPoints = new double[xPointsPenta.length];
        double margin = lineWidth / 2.0f;
        double roundingAdjustment = 0.0;
        for (int i = 0; i < xPoints.length; ++i) {
            xPoints[i] = x + ((size - 2.0 * margin) * xPointsPenta[i] + 0.0) + margin;
            yPoints[i] = y + ((size - 2.0 * margin) * yPointsPenta[i] + 0.0) + margin;
        }
        g2D.setColor(fillColor);
        Path2D path = GraphicsUtils.toPath2D(xPoints, yPoints);
        g2D.fill(path);
        g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2D.setColor(lineColor);
        g2D.draw(path);
    }

    public static Area getRectEllipseScaledUnion(Rectangle2D rect, double scaleFactor) {
        double newWidth = scaleFactor * rect.getWidth();
        double newHeight = scaleFactor * rect.getHeight();
        AffineTransform transform = new AffineTransform();
        transform.translate(rect.getX() - (newWidth - rect.getWidth()) / 2.0, rect.getY() - (newHeight - rect.getHeight()) / 2.0);
        transform.scale(scaleFactor, scaleFactor);
        transform.translate(-rect.getX(), -rect.getY());
        Shape transformedRect = transform.createTransformedShape(rect);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.setFrame(transformedRect.getBounds2D());
        Area circleArea = new Area(ellipse);
        Area rectArea = new Area(rect);
        circleArea.add(rectArea);
        return circleArea;
    }

    public static Shape getSquarcle(double factor, Rectangle2D rect) {
        return GraphicsUtils.getSquarcle(factor, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), false);
    }

    public static Shape getSquarcle(double factor, double x, double y, double width, double height, boolean collapse) {
        double perfectCircleRatio = 0.5522847498;
        double centreX = x + width / 2.0;
        double centreY = y + height / 2.0;
        double r = height / 2.0;
        double xNew = centreX - r;
        double yNew = centreY - r;
        Path2D.Double path = new Path2D.Double();
        double l = (1.0 - perfectCircleRatio * factor) * r;
        double d = 2.0 * r;
        double startX = xNew;
        double startY = yNew + r;
        ((Path2D)path).moveTo(startX, startY);
        Point2D p = path.getCurrentPoint();
        if (!collapse) {
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew, yNew + l, xNew + l, yNew, xNew + r, yNew), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + d - l, yNew, xNew + d, yNew + l, xNew + d, yNew + r), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + d, yNew + d - l, xNew + d - l, yNew + d, xNew + r, yNew + d), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + l, yNew + d, xNew, yNew + d - l, startX, startY), true);
            path.closePath();
        } else {
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew, yNew + r, xNew + r, yNew, xNew + r, yNew), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + r, yNew + r - l, xNew + r + l, yNew + r, xNew + d, yNew + r), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + r + l, yNew + r, xNew + r, yNew + r + l, xNew + r, yNew + d), true);
            p = path.getCurrentPoint();
            path.append(new CubicCurve2D.Double(p.getX(), p.getY(), xNew + r, yNew + r + l, xNew + r - l, yNew + r, startX, startY), true);
        }
        double theta = 0.7853981633974483;
        double scaleFactor = d / (Math.sqrt(2.0) * r);
        double newWidth = scaleFactor * d;
        double newHeight = scaleFactor * d;
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta, centreX, centreY);
        transform.translate(xNew - (newWidth - d) / 2.0, yNew - (newHeight - d) / 2.0);
        transform.scale(scaleFactor, scaleFactor);
        transform.translate(-xNew, -yNew);
        Shape transformedpath = transform.createTransformedShape(path);
        return transformedpath;
    }

    public static Shape getSquarcleCollapse(double factor, Rectangle2D rect) {
        return GraphicsUtils.getSquarcle(factor, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), true);
    }

    public static Path2D getSquarcleCollapseSloppy(float factor, Rectangle2D rect) {
        return GraphicsUtils.getSquarcleCollapseSloppy(factor, (float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight());
    }

    public static Path2D getSquarcleCollapseSloppy(float factor, float x, float y, float width, float height) {
        float cx = x + width / 2.0f;
        float cy = y + height / 2.0f;
        float circleRadius = height / 2.0f;
        float incAngle = (float)Math.toRadians(1.0);
        double twoPi = Math.PI * 2;
        Path2D.Float path = new Path2D.Float();
        boolean isMoveTo = true;
        float angleRadians = 0.0f;
        while ((double)angleRadians < twoPi) {
            float squareY;
            float squareX;
            float squareRadius;
            float circleX = cx + circleRadius * (float)Math.cos(angleRadians);
            float circleY = cy + circleRadius * (float)Math.sin(angleRadians);
            if ((double)angleRadians > Math.toRadians(225.0) && (double)angleRadians <= Math.toRadians(315.0)) {
                squareRadius = circleRadius / (float)Math.sin(angleRadians);
                squareX = cx - squareRadius * (float)Math.cos(angleRadians);
                squareY = cy - circleRadius;
            } else if ((double)angleRadians > Math.toRadians(45.0) && (double)angleRadians <= Math.toRadians(135.0)) {
                squareRadius = circleRadius / (float)Math.sin(angleRadians);
                squareX = cx + squareRadius * (float)Math.cos(angleRadians);
                squareY = cy + circleRadius;
            } else if ((double)angleRadians > Math.toRadians(135.0) && (double)angleRadians <= Math.toRadians(225.0)) {
                squareRadius = circleRadius / (float)Math.cos(angleRadians);
                squareX = cx - circleRadius;
                squareY = cy - squareRadius * (float)Math.sin(angleRadians);
            } else {
                squareRadius = circleRadius / (float)Math.cos(angleRadians);
                squareX = cx + circleRadius;
                squareY = cy + squareRadius * (float)Math.sin(angleRadians);
            }
            if (isMoveTo) {
                isMoveTo = false;
                ((Path2D)path).moveTo(GraphicsUtils.lerp(squareX, circleX, factor), GraphicsUtils.lerp(squareY, circleY, factor));
            } else {
                ((Path2D)path).lineTo(GraphicsUtils.lerp(squareX, circleX, factor), GraphicsUtils.lerp(squareY, circleY, factor));
            }
            angleRadians += incAngle;
        }
        path.closePath();
        return path;
    }

    private static float lerp(float a, float b, float factor) {
        return a * (1.0f - factor) + b * factor;
    }

    public static void drawStringSloppyAroundCirle(Graphics2D g2D, String text, Rectangle2D cirleBoundingRect, double radiusPadding, boolean centreTextNorth) {
        GraphicsUtils.drawStringAroundCirle(g2D, text, cirleBoundingRect, radiusPadding, centreTextNorth, true);
    }

    public static void drawStringAroundCirle(Graphics2D g2D, String text, Rectangle2D cirleBoundingRect, double radiusPadding, boolean centreTextNorth) {
        GraphicsUtils.drawStringAroundCirle(g2D, text, cirleBoundingRect, radiusPadding, centreTextNorth, false);
    }

    public static void drawStringAroundCirle(Graphics2D g2D, String text, Rectangle2D cirleBoundingRect, double radiusPadding, boolean centreTextNorth, boolean sloppy) {
        int length;
        double r = cirleBoundingRect.getWidth() / 2.0;
        AffineTransform orig = g2D.getTransform();
        g2D.translate(cirleBoundingRect.getX() + r, cirleBoundingRect.getY() + r);
        r += radiusPadding;
        double arclength = 0.0;
        FontMetrics fm = g2D.getFontMetrics();
        Rectangle2D wholeStringBounds = fm.getStringBounds(text, g2D);
        double arcOffset = 0.0;
        if (centreTextNorth) {
            arcOffset = (Math.PI * r - wholeStringBounds.getWidth()) / 2.0;
        }
        GlyphVector gv = null;
        if (sloppy) {
            length = text.length();
        } else {
            FontRenderContext frc = g2D.getFontRenderContext();
            gv = g2D.getFont().createGlyphVector(frc, text);
            length = gv.getNumGlyphs();
        }
        for (int i = 0; i < length; ++i) {
            String currentChar = text.substring(i, i + 1);
            Rectangle2D stringBounds = fm.getStringBounds(currentChar, g2D);
            double w = stringBounds.getWidth();
            Shape glyph = null;
            if (!sloppy && gv != null) {
                glyph = gv.getGlyphOutline(i);
                Rectangle2D rect2d = glyph.getBounds2D();
                double w2 = glyph.getBounds2D().getWidth();
                if (w2 > 0.0) {
                    glyph = gv.getGlyphOutline(i, -((float)rect2d.getX()), 0.0f);
                }
            }
            arclength = "w".equalsIgnoreCase(currentChar) || "m".equalsIgnoreCase(currentChar) ? (arclength += w / 3.0) : ("i".equalsIgnoreCase(currentChar) || "l".equals(currentChar) ? (arclength += w) : ("r".equals(currentChar) ? (arclength += w / 5.0 * 4.0) : (arclength += w / 2.0)));
            double theta = arcOffset / r + Math.PI + arclength / r;
            Graphics2D g2DTemp = (Graphics2D)g2D.create();
            g2DTemp.translate(r * Math.cos(theta), r * Math.sin(theta));
            if (!sloppy) {
                AffineTransform rt = new AffineTransform();
                rt.rotate(theta + 1.5707963267948966);
                Shape transformedGlyph = rt.createTransformedShape(glyph);
                g2DTemp.fill(transformedGlyph);
            } else {
                g2DTemp.rotate(theta + 1.5707963267948966);
                g2DTemp.drawString(currentChar, 0.0f, 0.0f);
            }
            g2DTemp.dispose();
            if ("w".equalsIgnoreCase(currentChar) || "m".equalsIgnoreCase(currentChar)) {
                arclength += w / 3.0 * 2.0;
                continue;
            }
            if ("i".equalsIgnoreCase(currentChar) || "l".equals(currentChar)) continue;
            if ("r".equals(currentChar)) {
                arclength += w / 5.0;
                continue;
            }
            arclength += w / 2.0;
        }
        g2D.setTransform(orig);
    }

    public static void drawRadioButtonMenuItemIcon(Graphics g, boolean isSelected, boolean isEnabled, int xPos, int yPos, int width, int height) {
        Graphics2D g2D = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig((Graphics)g2D);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        int rad = 5;
        int x = xPos + (rad - 1) / 2;
        int y = yPos + (rad - 1) / 2;
        int w = width - (rad + 5) / 2;
        int h = height - (rad + 5) / 2;
        g2D.translate(x, y);
        g2D.setPaint(UIManager.getColor("RadioButton.darculaMod.iconBackgroundColor1"));
        g2D.fillOval(1, 2, w - 1, h - 1);
        if (isSelected) {
            g2D.setPaint(UIManager.getColor(isEnabled ? "RadioButton.darculaMod.SelectedBorderColor" : "RadioButton.darculaMod.BorderDisabledColor"));
            g2D.drawOval(0, 1, w - 1, h - 1);
            boolean enabled = isEnabled;
            g2D.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g2D.fillOval(w / 2 - rad / 2, h / 2 - 1, rad, rad);
        } else {
            g2D.setPaint(UIManager.getColor(isEnabled ? "RadioButton.darculaMod.BorderColor" : "RadioButton.darculaMod.BorderDisabledColor"));
            g2D.drawOval(0, 1, w - 1, h - 1);
        }
        g2D.translate(-x, -y);
        config.restore();
    }

    public static void drawCheckLicense(Graphics2D g2D, double x, double y, double width, double height, String text, Color background, Color fontColor, Font font) {
        Color fillColor = background;
        double margin = height * 0.05;
        g2D.translate(x + margin, y + margin);
        double widthScale = (width -= 2.0 * margin) / 100.0;
        double heightScale = (height -= 2.0 * margin) / 100.0;
        AffineTransform transform = g2D.getTransform();
        g2D.scale(widthScale, heightScale);
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(0.0, 0.0, 100.0, 90.0, 50.0, 50.0);
        g2D.setColor(fillColor);
        g2D.fill(roundRect);
        g2D.setColor(fontColor);
        g2D.setTransform(transform);
        g2D.scale(heightScale, heightScale);
        float fontSize = 59.5837f;
        g2D.setFont(font.deriveFont(fontSize));
        String countText = text;
        double textWidth = StringUtilities.getStringWidth((Graphics)g2D, (String)countText);
        double xOffset = width / height * 50.0;
        int length = countText.length();
        if (length > 2) {
            fontSize = fontSize / (float)length * 2.5f;
            g2D.setFont(font.deriveFont(fontSize));
            textWidth = StringUtilities.getStringWidth((Graphics)g2D, (String)countText);
            xOffset = width / height * 50.0;
        }
        g2D.drawString(countText, (int)(xOffset - textWidth / 2.0), (int)(35.0f + fontSize / 2.0f));
    }

    public static void drawCollected(Graphics2D g2D, double x, double y, double width, double height, int count, boolean hovered, boolean black) {
        float lineWidth;
        Color lineColor;
        Color fillColor;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (black) {
            fillColor = RIBBON_ICON_BLACK;
            lineColor = Color.BLACK;
            lineWidth = 0.0f;
        } else {
            fillColor = laf.getColor("pin-color");
            lineColor = hovered ? Color.BLACK : fillColor.darker();
            lineWidth = 5.0f;
        }
        double margin = height * 0.05;
        g2D.translate(x + margin, y + margin);
        double widthScale = (width -= 2.0 * margin) / 100.0;
        double heightScale = (height -= 2.0 * margin) / 100.0;
        AffineTransform transform = g2D.getTransform();
        g2D.scale(widthScale, heightScale);
        g2D.setStroke(new BasicStroke(5.0f, 1, 1));
        if (count > 1 || black) {
            double[] xPoints = new double[]{0.0, 35.0, 35.0, 65.0, 65.0, 100.0, 100.0, 0.0};
            double[] yPoints = new double[]{20.0, 20.0, 0.0, 0.0, 20.0, 20.0, 100.0, 100.0};
            Path2D path = GraphicsUtils.toPath2D(xPoints, yPoints);
            g2D.setColor(fillColor);
            g2D.fill(path);
            g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
            g2D.setColor(lineColor);
            g2D.draw(path);
            if (!black) {
                g2D.setColor(fillColor.darker());
                g2D.draw(path);
                g2D.setColor(Color.BLACK);
                g2D.setTransform(transform);
                g2D.scale(heightScale, heightScale);
                float fontSize = 65.0f;
                g2D.setFont(g2D.getFont().deriveFont(fontSize));
                String countText = Integer.toString(count);
                double textWidth = StringUtilities.getStringWidth((Graphics)g2D, (String)countText);
                double xOffset = width / height * 50.0;
                g2D.drawString(countText, (int)(xOffset - textWidth / 2.0), (int)(50.0f + fontSize / 2.0f));
            }
        } else {
            g2D.setColor(fillColor);
            int diameter = 40;
            int location = (100 - diameter) / 2;
            g2D.fillOval(location, location, diameter, diameter);
            g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
            g2D.setColor(lineColor);
            g2D.drawOval(location, location, diameter, diameter);
        }
    }

    public static void drawSelected(Graphics2D g2D, double x, double y, double size, boolean selected, boolean hovered) {
        double margin = size * 0.2;
        g2D.translate(x + margin, y + margin);
        Color color = selected ? RIBBON_ICON_BLACK : BLACK_ALPHA_20;
        g2D.setColor(color);
        g2D.fillOval(0, 0, (int)(size -= 2.0 * margin), (int)size);
        g2D.setStroke(new BasicStroke(5.0f, 1, 1));
        g2D.setColor(hovered ? Color.BLACK : color.darker());
        g2D.drawOval(0, 0, (int)size, (int)size);
    }

    public static void drawInspect(Graphics2D g2D, double x, double y, double size, boolean hovered) {
        double margin = size * 0.2;
        g2D.translate(x + margin, y + margin);
        g2D.scale((size -= 2.0 * margin) / 100.0, size / 100.0);
        g2D.setColor(hovered ? HOVER_COLOR : RIBBON_ICON_BLACK);
        g2D.fillRect(40, 0, 20, 100);
        g2D.fillRect(0, 40, 100, 20);
    }

    public static void drawWeight(Graphics2D g2D, double x, double y, double size) {
        double margin = size * 0.05;
        g2D.translate(x + margin, y + margin);
        g2D.scale((size -= 2.0 * margin) / 100.0, size / 100.0);
        g2D.setColor(Color.decode("#AAAAAA"));
        g2D.fillRect(10, 10, 90, 90);
        Color color = RIBBON_ICON_BLACK;
        g2D.setColor(color);
        Path2D.Double rectPath = new Path2D.Double();
        ((Path2D)rectPath).moveTo(0.0, 0.0);
        ((Path2D)rectPath).lineTo(0.0, 100.0);
        ((Path2D)rectPath).lineTo(100.0, 100.0);
        ((Path2D)rectPath).lineTo(100.0, 0.0);
        rectPath.closePath();
        double[] xPoints = new double[]{15.0, 85.0, 85.0, 55.0, 70.0, 40.0, 15.0};
        double[] yPoints = new double[]{15.0, 15.0, 70.0, 70.0, 40.0, 70.0, 70.0};
        Path2D path = GraphicsUtils.toPath2D(xPoints, yPoints);
        path.append(rectPath, false);
        g2D.fill(path);
        g2D.setStroke(new BasicStroke((float)(100.0 / size), 1, 1));
        Color darkColor = new Color(50, 50, 50, color.getAlpha());
        g2D.setColor(darkColor);
        g2D.draw(path);
    }

    public static void drawColumnSelect(Graphics2D g2D, double x, double y, double size) {
        double[] yPoints;
        double margin = size * 0.01;
        g2D.translate(x + margin, y + margin);
        g2D.scale((size -= 2.0 * margin) / 2.0 / 100.0, size / 100.0);
        g2D.setColor(RIBBON_ICON_BLACK);
        Path2D path = new Path2D.Double();
        double[] xPoints = new double[]{0.0, 60.0};
        for (int xLines = 0; xLines < 5; ++xLines) {
            double xLineY = xLines * 25;
            yPoints = new double[]{xLineY, xLineY};
            path.append(GraphicsUtils.toPath2D(xPoints, yPoints), false);
        }
        yPoints = new double[]{0.0, 100.0};
        for (int yLines = 0; yLines < 3; ++yLines) {
            double yLineX = yLines * 30;
            xPoints = new double[]{yLineX, yLineX};
            path.append(GraphicsUtils.toPath2D(xPoints, yPoints), false);
        }
        g2D.setStroke(new BasicStroke((float)(150.0 / size), 1, 1));
        g2D.draw(path);
        xPoints = new double[]{30.0, 60.0, 60.0, 30.0, 30.0};
        yPoints = new double[]{0.0, 0.0, 100.0, 100.0, 0.0};
        path = GraphicsUtils.toPath2D(xPoints, yPoints);
        g2D.setColor(RIBBON_ICON_BLACK.darker());
        g2D.setStroke(new BasicStroke((float)(300.0 / size), 1, 1));
        g2D.draw(path);
        g2D.setColor(RIBBON_ICON_BLACK.darker().darker());
        xPoints = new double[]{45.0, 80.0, 70.0, 78.0, 73.0, 63.0, 55.0, 45.0};
        yPoints = new double[]{0.0, 30.0, 31.0, 45.0, 46.0, 32.0, 35.0, 0.0};
        path = GraphicsUtils.toPath2D(xPoints, yPoints);
        g2D.fill(path);
    }

    public static void drawLink(Graphics2D g2D, double x, double y, double size, boolean incoming) {
        double margin = 0.0;
        g2D.translate(x + margin, y + margin);
        g2D.scale((size -= 2.0 * margin) / 100.0, size / 100.0);
        Color color = RIBBON_ICON_BLACK;
        Color darkColor = new Color(50, 50, 50, color.getAlpha());
        g2D.setStroke(new BasicStroke((float)(100.0 / size), 1, 1));
        int ballDiameter = 40;
        if (incoming) {
            g2D.translate(0, 100 - ballDiameter);
        }
        g2D.setColor(color);
        g2D.fillOval(50 - ballDiameter / 2, 0, ballDiameter, ballDiameter);
        g2D.setColor(darkColor);
        g2D.drawOval(50 - ballDiameter / 2, 0, ballDiameter, ballDiameter);
        g2D.translate(0, incoming ? ballDiameter - 100 : ballDiameter);
        int arrowHeadHeight = 20;
        int arrowHeadYMargin = 30;
        int arrowWidth = 10;
        int x1 = arrowHeadYMargin;
        int y1 = 100 - ballDiameter - arrowHeadHeight;
        int x2 = 50 - arrowWidth / 2;
        int y2 = y1;
        int x3 = x2;
        boolean y3 = false;
        int x4 = 50 + arrowWidth / 2;
        boolean y4 = y3;
        int x5 = x4;
        int y5 = y1;
        int x6 = 100 - arrowHeadYMargin;
        int y6 = y5;
        int x7 = 50;
        int y7 = 100 - ballDiameter;
        double[] xPoints = new double[]{x1, x2, x3, x4, x5, x6, x7};
        double[] yPoints = new double[]{y1, y2, (double)y3, (double)y4, y5, y6, y7};
        Path2D path = GraphicsUtils.toPath2D(xPoints, yPoints);
        g2D.setColor(color);
        g2D.fill(path);
        g2D.setColor(darkColor);
        g2D.draw(path);
    }

    private static Path2D toPath2D(double[] xPoints, double[] yPoints) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < xPoints.length; ++i) {
            ((Path2D)path).lineTo(xPoints[i], yPoints[i]);
        }
        path.closePath();
        return path;
    }

    public static Icon getPinIcon(int size, boolean pinned, boolean hovered, boolean black) {
        return new PinIcon(size, pinned, hovered, black);
    }

    public static Icon getCheckLicenseIcon(int width, int height, String text, Color background, Color fontColor, Font font) {
        return new CheckLicenseIcon(width, height, text, background, fontColor, font);
    }

    public static Icon getCollectedIcon(int width, int height, int count, boolean hovered, boolean black) {
        return new CollectedIcon(width, height, count, hovered, black);
    }

    public static Icon getSelectedIcon(int size, boolean selected, boolean hovered) {
        return new SelectedIcon(size, selected, hovered);
    }

    public static Icon getInspectIcon(int size, boolean hovered) {
        return new InspectIcon(size, hovered);
    }

    public static Icon getWeightIcon(int size) {
        return new WeightIcon(size);
    }

    public static Icon getLinkIcon(int size, boolean incoming) {
        return new LinkIcon(size, incoming);
    }

    public static Icon getColumnIcon(int size) {
        return new ColumnIcon(size);
    }

    public static Color getTransparentGrey() {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        return ColorUtil.setAlpha((Color)RIBBON_ICON_BLACK, (int)Integer.decode((String)laf.get("bookmark-none-alpha")));
    }

    private static float getLineWidth(boolean hovered) {
        return hovered ? 5.0f : 2.0f;
    }

    private static abstract class ScaledIcon
    implements Icon {
        private final int _size;
        private double _scale = 0.1f;

        public ScaledIcon(int size) {
            this._size = size;
        }

        public void setScale(double newScale) {
            this._scale = newScale;
        }

        public double getScale() {
            return this._scale;
        }

        public abstract void draw(Graphics2D var1, double var2);

        @Override
        public void paintIcon(Component c, Graphics g, int xPos, int yPos) {
            Graphics2D g2D = (Graphics2D)g.create();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.scale(this._scale, this._scale);
            double x = (double)xPos / this._scale;
            double y = (double)yPos / this._scale;
            double size = (double)this._size / this._scale;
            g2D.translate(x, y);
            this.draw(g2D, size);
            g2D.dispose();
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }
    }

    private static class ColumnIcon
    extends ScaledIcon {
        public ColumnIcon(int size) {
            super(size);
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawColumnSelect(g2D, 0.0, 0.0, size);
        }

        @Override
        public int getIconWidth() {
            return (int)((float)super.getIconWidth() / 2.0f);
        }
    }

    private static class LinkIcon
    extends ScaledIcon {
        private final boolean _incoming;

        public LinkIcon(int size, boolean incoming) {
            super(size);
            this._incoming = incoming;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawLink(g2D, 0.0, 0.0, size, this._incoming);
        }
    }

    private static class WeightIcon
    extends ScaledIcon {
        public WeightIcon(int size) {
            super(size);
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawWeight(g2D, 0.0, 0.0, size);
        }
    }

    private static class InspectIcon
    extends ScaledIcon {
        private final boolean _hovered;

        public InspectIcon(int size, boolean hovered) {
            super(size);
            this._hovered = hovered;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawInspect(g2D, 0.0, 0.0, size, this._hovered);
        }
    }

    private static class SelectedIcon
    extends ScaledIcon {
        private final boolean _selected;
        private final boolean _hovered;

        public SelectedIcon(int size, boolean selected, boolean hovered) {
            super(size);
            this._selected = selected;
            this._hovered = hovered;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawSelected(g2D, 0.0, 0.0, size, this._selected, this._hovered);
        }
    }

    private static class CollectedIcon
    extends ScaledIcon {
        private final int _count;
        private final boolean _hovered;
        private final boolean _black;
        private final int _width;
        private final int _height;

        public CollectedIcon(int width, int height, int count, boolean hovered, boolean black) {
            super(height);
            this._count = count;
            this._hovered = hovered;
            this._black = black;
            this._width = width;
            this._height = height;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawCollected(g2D, 0.0, 0.0, (double)this._width / this.getScale(), (double)this._height / this.getScale(), this._count, this._hovered, this._black);
        }

        @Override
        public int getIconHeight() {
            return this._height;
        }

        @Override
        public int getIconWidth() {
            return this._width;
        }
    }

    private static class CheckLicenseIcon
    extends ScaledIcon {
        private final Color _bg;
        private final int _width;
        private final int _height;
        private final String _text;
        private final Color _fontColor;
        private final Font _font;

        public CheckLicenseIcon(int width, int height, String text, Color background, Color fontColor, Font font) {
            super(height);
            this._width = width;
            this._height = height;
            this._text = text;
            this._bg = background;
            this._fontColor = fontColor;
            this._font = font;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawCheckLicense(g2D, 0.0, 0.0, (double)this._width / this.getScale(), (double)this._height / this.getScale(), this._text, this._bg, this._fontColor, this._font);
        }

        @Override
        public int getIconHeight() {
            return this._height;
        }

        @Override
        public int getIconWidth() {
            return this._width;
        }
    }

    private static class PinIcon
    extends ScaledIcon {
        private final boolean _pinned;
        private final boolean _hovered;
        private final boolean _black;

        public PinIcon(int size, boolean pinned, boolean hovered, boolean black) {
            super(size);
            this._pinned = pinned;
            this._hovered = hovered;
            this._black = black;
        }

        @Override
        public void draw(Graphics2D g2D, double size) {
            GraphicsUtils.drawPin(g2D, 0.0, 0.0, size, this._pinned, this._hovered, this._black);
        }
    }
}

