/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.imex.HubSeedConfig;
import com.paterva.maltego.seeds.ui.imex.HubSeedDescriptorEntry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.manager.imex.seeds.TransformSeedEntry;
import com.paterva.maltego.transform.manager.imex.transforms.TransformDescriptorEntry;
import com.paterva.maltego.transform.manager.imex.transforms.TransformServerEntry;
import com.paterva.maltego.transform.manager.imex.transforms.TransformSettingsEntry;
import com.paterva.maltego.util.FileUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HubSeedExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
        ArrayList<HubSeedDescriptor> seedList = new ArrayList<HubSeedDescriptor>();
        HubSeedSettings settings = HubSeedSettings.getDefault();
        for (HubSeedDescriptor seed : seeds.getSeeds()) {
            if (!seed.isCustom() && !settings.isInstalled(seed)) continue;
            seedList.add(seed);
        }
        if (!seedList.isEmpty()) {
            return new HubSeedConfig(seedList);
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        HubSeedConfig seedConfig = (HubSeedConfig)config;
        HubSeedDescriptor[] seeds = (HubSeedDescriptor[])seedConfig.getSelected();
        ArrayList<String> names = new ArrayList<String>(seeds.length);
        HashSet<TransformServerInfo> serversToExport = new HashSet<TransformServerInfo>();
        for (HubSeedDescriptor seed : seeds) {
            if (seed.getHubSeedUrl() == null) continue;
            String name = this.writeTransformSeed(seed, names, writer);
            writer.write((Entry)new HubSeedDescriptorEntry(seed, name));
            serversToExport.addAll(this.getServers(seed));
        }
        this.writeRemoteTransforms(serversToExport, writer);
        return seeds.length;
    }

    private String writeTransformSeed(HubSeedDescriptor seed, ArrayList<String> names, MaltegoArchiveWriter writer) throws IOException {
        TransformSeed transformSeed = HubSeedRegistry.getDefault().getTransformSeed(seed);
        String name = FileUtilities.createUniqueLegalFilename(names, (String)transformSeed.getName());
        names.add(name);
        writer.write((Entry)new TransformSeedEntry(transformSeed, name));
        return name;
    }

    private Set<String> writeServers(Set<TransformServerInfo> serversToExport, MaltegoArchiveWriter writer) throws IOException {
        ArrayList<String> serverNames = new ArrayList<String>();
        HashSet<String> transformNames = new HashSet<String>();
        for (TransformServerInfo server : serversToExport) {
            Set<String> transforms = this.writeServer(serverNames, server, writer);
            transformNames.addAll(transforms);
        }
        return transformNames;
    }

    private Set<String> writeServer(ArrayList<String> serverNames, TransformServerInfo server, MaltegoArchiveWriter writer) throws IOException {
        String name = FileUtilities.createUniqueLegalFilename(serverNames, (String)server.getDisplayName());
        serverNames.add(name);
        writer.write((Entry)new TransformServerEntry(server, name));
        Set transforms = server.getTransforms();
        return transforms;
    }

    private void writeRemoteTransforms(Set<TransformServerInfo> serversToExport, MaltegoArchiveWriter writer) throws IOException {
        Set<String> transformNames = this.writeServers(serversToExport, writer);
        TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
        TransformRepository remoteRepository = registry.getRepository("Remote");
        for (String transformName : transformNames) {
            for (TransformDefinition definition : remoteRepository.getAll()) {
                if (!definition.getName().equals(transformName)) continue;
                writer.write((Entry)new TransformDescriptorEntry(definition));
                writer.write((Entry)new TransformSettingsEntry(definition));
            }
        }
    }

    private List<TransformServerInfo> getServers(HubSeedDescriptor seed) {
        ArrayList<TransformServerInfo> seedServers = new ArrayList<TransformServerInfo>();
        Collection servers = TransformServerRegistry.getDefault().getAll();
        for (TransformServerInfo server : servers) {
            for (String seedUrl : server.getSeedUrls()) {
                HubSeedUrl url = seed.getHubSeedUrl();
                if (url == null || !url.getUrl().equals(seedUrl)) continue;
                seedServers.add(server);
            }
        }
        return seedServers;
    }
}

