/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.paterva.maltego.seeds.ui.HubFilterManager;
import com.paterva.maltego.seeds.ui.HubSeedsHomePanel;
import com.paterva.maltego.util.ui.components.TriStateCheckBox;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HubTagTypePanel
extends JPanel {
    private static final int ROW_MAX = 8;
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final CheckBoxActionListener listener = new CheckBoxActionListener();
    private final TriStateCheckBox tagTypeCheckBox = new TriStateCheckBox("ALL");
    private final List<TagCheckBox> checkBoxes = new ArrayList<TagCheckBox>();
    private String tagTypeId;
    private JLabel tagTypeTitleLabel;
    private JPanel tagsPanel;

    public HubTagTypePanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.tagTypeTitleLabel.setFont(LAF.getFont("hub-tag-type-checkbox-font"));
        this.tagTypeCheckBox.putClientProperty((Object)"inHubPanel", (Object)Boolean.TRUE);
        this.tagTypeCheckBox.setRolloverEnabled(true);
        this.tagTypeCheckBox.addActionListener(__ -> {
            int selectionState = this.tagTypeCheckBox.getSelectionState();
            this.selectAll(selectionState != TriStateCheckBox.ALL_SELECTED);
        });
        this.setBorder(new EmptyBorder(0, HubSeedsHomePanel.HUB_PADDING_SIDES, 5, 5));
        this.tagsPanel.removeAll();
    }

    public void setTags(String tagTypeId, String tagTypeName, Set<String> tags) {
        this.tagTypeId = tagTypeId;
        this.clearCheckBoxes();
        this.tagTypeTitleLabel.setText(tagTypeName);
        this.tagsPanel.removeAll();
        int num = 0;
        this.tagsPanel.add((Component)this.tagTypeCheckBox, this.createCheckBoxContraints(num++));
        for (String tag : tags) {
            TagCheckBox checkBox = new TagCheckBox(tag);
            checkBox.putClientProperty("inHubPanel", Boolean.TRUE);
            checkBox.setRolloverEnabled(true);
            checkBox.addActionListener(this.listener);
            checkBox.setSelected(HubFilterManager.getInstance().isSelected(tagTypeId, tag));
            this.tagsPanel.add((Component)checkBox, this.createCheckBoxContraints(num++));
            this.checkBoxes.add(checkBox);
        }
        this.updateTagTypeCheckbox();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.clearCheckBoxes();
    }

    private void clearCheckBoxes() {
        this.checkBoxes.stream().forEach(checkBox -> checkBox.removeActionListener(this.listener));
        this.checkBoxes.clear();
    }

    private void selectAll(boolean select) {
        HubFilterManager filterManager = HubFilterManager.getInstance();
        List<String> tags = this.checkBoxes.stream().map(TagCheckBox::getTag).collect(Collectors.toList());
        filterManager.setSelected(this.tagTypeId, tags, select);
    }

    private void updateTagTypeCheckbox() {
        long selected = this.checkBoxes.stream().filter(AbstractButton::isSelected).count();
        boolean noneSelected = selected == 0L;
        boolean allSelected = selected == (long)this.checkBoxes.size();
        int selectionState = TriStateCheckBox.NONE_SELECTED;
        if (!noneSelected) {
            selectionState = allSelected ? TriStateCheckBox.ALL_SELECTED : TriStateCheckBox.SOME_SELECTED;
        }
        this.tagTypeCheckBox.setSelectionState(selectionState);
    }

    private GridBagConstraints createCheckBoxContraints(int num) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = num / 8;
        constraints.gridy = num % 8;
        return constraints;
    }

    private void initComponents() {
        JPanel northPanel = new JPanel();
        this.tagTypeTitleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        this.tagsPanel = new JPanel();
        JCheckBox jCheckBox1 = new JCheckBox();
        JCheckBox jCheckBox2 = new JCheckBox();
        JCheckBox jCheckBox3 = new JCheckBox();
        JCheckBox jCheckBox4 = new JCheckBox();
        JCheckBox jCheckBox5 = new JCheckBox();
        JCheckBox jCheckBox6 = new JCheckBox();
        JCheckBox jCheckBox7 = new JCheckBox();
        JCheckBox jCheckBox8 = new JCheckBox();
        JCheckBox jCheckBox9 = new JCheckBox();
        JCheckBox jCheckBox10 = new JCheckBox();
        JCheckBox jCheckBox11 = new JCheckBox();
        JCheckBox jCheckBox12 = new JCheckBox();
        JCheckBox jCheckBox13 = new JCheckBox();
        JCheckBox jCheckBox14 = new JCheckBox();
        JCheckBox jCheckBox15 = new JCheckBox();
        JCheckBox jCheckBox16 = new JCheckBox();
        this.setLayout(new BorderLayout());
        northPanel.setOpaque(false);
        northPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.tagTypeTitleLabel, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.tagTypeTitleLabel.text"));
        northPanel.add((Component)this.tagTypeTitleLabel, "First");
        this.add((Component)northPanel, "North");
        centerPanel.setOpaque(false);
        centerPanel.setLayout(new FlowLayout(0, 0, 5));
        this.tagsPanel.setOpaque(false);
        this.tagsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox1, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox1.text"));
        jCheckBox1.setMargin(new Insets(2, 0, 2, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox2, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox2.text"));
        jCheckBox2.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox3, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox3.text"));
        jCheckBox3.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox4, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox4.text"));
        jCheckBox4.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox5, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox5.text"));
        jCheckBox5.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox6, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox6.text"));
        jCheckBox6.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox6, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox7, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox7.text"));
        jCheckBox7.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox7, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox8, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox8.text"));
        jCheckBox8.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.tagsPanel.add((Component)jCheckBox8, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox9, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox9, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox10, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox10, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox11, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox11, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox12, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox12, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox13, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox13, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox14, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox14, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox15, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox15, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox16, (String)NbBundle.getMessage(HubTagTypePanel.class, (String)"HubTagTypePanel.jCheckBox16.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tagsPanel.add((Component)jCheckBox16, gridBagConstraints);
        centerPanel.add(this.tagsPanel);
        this.add((Component)centerPanel, "Center");
    }

    private class TagCheckBox
    extends JCheckBox {
        private final String tag;

        public TagCheckBox(String tag) {
            super(tag);
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }

    private class CheckBoxActionListener
    implements ActionListener {
        private CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagCheckBox checkBox = (TagCheckBox)e.getSource();
            HubFilterManager.getInstance().setSelected(HubTagTypePanel.this.tagTypeId, checkBox.getTag(), checkBox.isSelected());
            HubTagTypePanel.this.updateTagTypeCheckbox();
        }
    }
}

