/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedTagType;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.ui.DisplayFilterToolbar;
import com.paterva.maltego.seeds.ui.HubFilterManager;
import com.paterva.maltego.seeds.ui.HubSeedsHomePanel;
import com.paterva.maltego.seeds.ui.SortToolbar;
import com.paterva.maltego.seeds.ui.hub.HubSeedManager;
import com.paterva.maltego.seeds.ui.hub.HubTagTypePanel;
import com.paterva.maltego.util.ui.button.CollapseExpandButton;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.util.ui.search.SearchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HubFilterPanel
extends JPanel {
    private static final String PREF_EXPANDED = "maltego.hub.filter.expanded";
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final Color FILTERS_BG = LAF.getColor("hub-partners-bg");
    private static final Color DIVIDER_VERTICAL_BG = LAF.getColor("hub-divider-vertical-bg");
    private static final Color DIVIDER_HORIZONTAL_BG = LAF.getColor("hub-divider-horizontal-bg");
    private final SearchPanel searchPanel;
    private final TextQuickFilter hubFilter;
    private final DisplayFilterToolbar displayFilterToolbar;
    private final SortToolbar sortToolbar;
    private PropertyChangeListener filterListener;
    private JPanel centerPanel;
    private JButton clearFiltersButton;
    private JButton collapseButton;
    private JPanel displaySortPlaceholder;
    private JPanel filterTypesPanel;
    private JPanel northCenterPanel;
    private JPanel northPanel;
    private JScrollPane scrollPane;
    private JPanel searchPlaceholder;
    private JPanel southPanel;
    private JLabel titleLabel;

    public HubFilterPanel(HubSeedsHomePanel hubSeedsHomePanel, HubSeedManager manager, JScrollBar verticalScrollBar) {
        this.initComponents();
        this.setBackground(FILTERS_BG);
        this.northPanel.setBackground(FILTERS_BG);
        this.northCenterPanel.setBackground(FILTERS_BG);
        this.northPanel.setBorder(new EmptyBorder(0, HubSeedsHomePanel.HUB_PADDING_SIDES, 0, HubSeedsHomePanel.HUB_PADDING_SIDES));
        this.northCenterPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.titleLabel.setFont(this.getFontScaled("hub-sections-title-font"));
        this.scrollPane.getViewport().setOpaque(false);
        this.collapseButton.putClientProperty("inHubPanel", Boolean.TRUE);
        this.clearFiltersButton.putClientProperty("inHubPanel", Boolean.TRUE);
        this.clearFiltersButton.setForeground(DarculaButtonUI.getButtonColorHub());
        this.hubFilter = new HubQuickFilter(manager);
        this.searchPanel = new SearchPanel((JComponent)((Object)hubSeedsHomePanel), this.hubFilter);
        this.searchPanel.setMinimumSize(new Dimension(125, 10));
        this.searchPanel.setPreferredSize(new Dimension(200, this.searchPanel.getPreferredSize().height));
        this.northCenterPanel.add((Component)this.searchPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(6, 6, 6, 6), 0, 0));
        this.northCenterPanel.remove(this.searchPlaceholder);
        JToolBar rightToolbar = new JToolBar();
        rightToolbar.setFloatable(false);
        rightToolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
        rightToolbar.setOpaque(false);
        rightToolbar.setBackground(FILTERS_BG);
        this.displayFilterToolbar = new DisplayFilterToolbar(manager);
        this.displayFilterToolbar.setBackground(FILTERS_BG);
        this.displayFilterToolbar.putClientProperty("inHubPanel", Boolean.TRUE);
        rightToolbar.add(this.displayFilterToolbar);
        Component strut = Box.createHorizontalStrut(15);
        strut.setBackground(FILTERS_BG);
        rightToolbar.add(strut);
        this.sortToolbar = new SortToolbar(manager);
        this.sortToolbar.setBackground(FILTERS_BG);
        this.sortToolbar.putClientProperty("inHubPanel", Boolean.TRUE);
        rightToolbar.add(this.sortToolbar);
        JPanel rightToolbarWrapper = new JPanel(new BorderLayout(0, 0));
        rightToolbarWrapper.setOpaque(false);
        rightToolbarWrapper.setBackground(FILTERS_BG);
        rightToolbarWrapper.add((Component)rightToolbar, "East");
        this.northCenterPanel.add((Component)rightToolbarWrapper, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(6, 6, 6, 6), 0, 0));
        this.northCenterPanel.remove(this.displaySortPlaceholder);
        JPanel divider = new JPanel();
        divider.setBackground(DIVIDER_HORIZONTAL_BG);
        Dimension dividerDimension = new Dimension(Integer.MAX_VALUE, 2);
        divider.setMaximumSize(dividerDimension);
        divider.setPreferredSize(dividerDimension);
        divider.setBorder(BorderFactory.createMatteBorder(0, HubSeedsHomePanel.HUB_PADDING_SIDES, 0, 0, FILTERS_BG));
        this.southPanel.add((Component)divider, "South");
        this.southPanel.setBorder(new EmptyBorder(0, 0, 0, HubSeedsHomePanel.HUB_PADDING_SIDES));
        this.scrollPane.setWheelScrollingEnabled(false);
        JScrollBar horizontalScrollBar = this.scrollPane.getHorizontalScrollBar();
        this.scrollPane.addMouseWheelListener(new ScrollMouseWheelListener(horizontalScrollBar, verticalScrollBar));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.filterListener = new FilterChangeListener();
        HubFilterManager.getInstance().addChangeListener(this.filterListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        HubFilterManager.getInstance().removeChangeListener(this.filterListener);
        this.filterListener = null;
    }

    public void setHubSeeds(HubSeeds seeds) {
        this.filterTypesPanel.removeAll();
        Map<String, Set<String>> tags = this.getGroupedTags(seeds);
        int totalGroups = tags.entrySet().size();
        int groupsCount = 0;
        int dividerWidth = 2;
        int maxGroupHeight = 0;
        for (Map.Entry<String, Set<String>> entry : tags.entrySet()) {
            int groupHeight;
            String tagTypeId = entry.getKey();
            Set<String> tagSet = entry.getValue();
            if (tagSet.isEmpty()) continue;
            HubSeedTagType tagType = this.getTagType(seeds, tagTypeId);
            HubTagTypePanel tagTypePanel = new HubTagTypePanel();
            tagTypePanel.setOpaque(false);
            tagTypePanel.setTags(tagType.getId(), tagType.getValue(), tagSet);
            this.filterTypesPanel.add(tagTypePanel);
            int n = groupHeight = tagTypePanel.getPreferredSize() != null ? tagTypePanel.getPreferredSize().height : 0;
            if (groupHeight > maxGroupHeight) {
                maxGroupHeight = groupHeight;
            }
            if (++groupsCount >= totalGroups) continue;
            this.filterTypesPanel.add(new VerticalDivider(dividerWidth));
        }
        for (Component child : this.filterTypesPanel.getComponents()) {
            if (child instanceof VerticalDivider) {
                ((VerticalDivider)child).setPreferredSize(new Dimension(dividerWidth, maxGroupHeight));
                continue;
            }
            if (!(child instanceof HubTagTypePanel)) continue;
            HubTagTypePanel temp = (HubTagTypePanel)child;
            Dimension size = temp.getPreferredSize();
            temp.setPreferredSize(new Dimension(Math.max(size.width, 236), size.height));
        }
        this.revalidate();
        this.repaint();
    }

    private Map<String, Set<String>> getGroupedTags(HubSeeds seeds) {
        LinkedHashMap<String, Set<String>> tags = new LinkedHashMap<String, Set<String>>();
        seeds.getTagTypes().stream().forEach(tagType -> tags.put(tagType.getId(), new TreeSet()));
        seeds.getSeeds().stream().map(HubSeedDescriptor::getTags).flatMap(Collection::stream).forEach(tag -> {
            Set tagList = (Set)tags.get(tag.getType());
            if (tagList != null) {
                tagList.add(tag.getValue());
            }
        });
        return tags;
    }

    private HubSeedTagType getTagType(HubSeeds seeds, String id) {
        for (HubSeedTagType tagType : seeds.getTagTypes()) {
            if (!Objects.equals(tagType.getId(), id)) continue;
            return tagType;
        }
        return null;
    }

    private Font getFontScaled(String key) {
        return LAF.getFont(key);
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        JPanel scrollViewPanel = new JPanel();
        this.filterTypesPanel = new JPanel();
        this.northPanel = new JPanel();
        this.northCenterPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.clearFiltersButton = new JButton();
        this.searchPlaceholder = new JPanel();
        this.displaySortPlaceholder = new JPanel();
        this.collapseButton = new CollapseExpandButton((JComponent)this.centerPanel, PREF_EXPANDED);
        this.southPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.centerPanel.setOpaque(false);
        this.centerPanel.setLayout(new BorderLayout());
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setOpaque(false);
        scrollViewPanel.setOpaque(false);
        scrollViewPanel.setLayout(new FlowLayout(0, 0, 5));
        this.filterTypesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.filterTypesPanel.setOpaque(false);
        this.filterTypesPanel.setLayout(new BoxLayout(this.filterTypesPanel, 2));
        scrollViewPanel.add(this.filterTypesPanel);
        this.scrollPane.setViewportView(scrollViewPanel);
        this.centerPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)this.centerPanel, "Center");
        this.northPanel.setOpaque(false);
        this.northPanel.setLayout(new BorderLayout(6, 0));
        this.northCenterPanel.setOpaque(false);
        this.northCenterPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(HubFilterPanel.class, (String)"HubFilterPanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.northCenterPanel.add((Component)this.titleLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.clearFiltersButton, (String)NbBundle.getMessage(HubFilterPanel.class, (String)"HubFilterPanel.clearFiltersButton.text"));
        this.clearFiltersButton.setToolTipText(NbBundle.getMessage(HubFilterPanel.class, (String)"HubFilterPanel.clearFiltersButton.toolTipText"));
        this.clearFiltersButton.setBorderPainted(false);
        this.clearFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubFilterPanel.this.clearFiltersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 6, 6);
        this.northCenterPanel.add((Component)this.clearFiltersButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.northCenterPanel.add((Component)this.searchPlaceholder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.northCenterPanel.add((Component)this.displaySortPlaceholder, gridBagConstraints);
        this.northPanel.add((Component)this.northCenterPanel, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this.collapseButton, (String)NbBundle.getMessage(HubFilterPanel.class, (String)"HubFilterPanel.collapseButton.text"));
        this.northPanel.add((Component)this.collapseButton, "East");
        this.add((Component)this.northPanel, "North");
        this.southPanel.setOpaque(false);
        this.southPanel.setLayout(new BorderLayout());
        this.add((Component)this.southPanel, "South");
    }

    private void clearFiltersButtonActionPerformed(ActionEvent evt) {
        HubFilterManager.getInstance().clear();
    }

    private static class ScrollMouseWheelListener
    extends MouseAdapter {
        private final JScrollBar horizontalScrollBar;
        private final JScrollBar verticalScrollBar;

        public ScrollMouseWheelListener(JScrollBar horizontalScrollBar, JScrollBar verticalScrollBar) {
            this.horizontalScrollBar = horizontalScrollBar;
            this.verticalScrollBar = verticalScrollBar;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
            boolean hVisible;
            int scrollAmount = 16 * evt.getScrollAmount() * Math.abs(evt.getWheelRotation());
            int hValue = this.horizontalScrollBar.getValue();
            int vValue = this.verticalScrollBar.getValue();
            int hMax = this.horizontalScrollBar.getMaximum() - this.horizontalScrollBar.getVisibleAmount();
            int vMax = this.verticalScrollBar.getMaximum() - this.verticalScrollBar.getVisibleAmount();
            boolean bl = hVisible = hMax > 0;
            if (evt.getWheelRotation() >= 1) {
                if (hVisible) {
                    if (hValue < hMax) {
                        hValue = Math.min(hValue + scrollAmount, hMax);
                        this.horizontalScrollBar.setValue(hValue);
                    }
                } else if (vValue < vMax) {
                    vValue = Math.min(vValue + scrollAmount, vMax);
                    this.verticalScrollBar.setValue(vValue);
                }
            } else if (evt.getWheelRotation() <= -1) {
                if (hVisible) {
                    if (hValue > 0) {
                        hValue = Math.max(hValue - scrollAmount, 0);
                        this.horizontalScrollBar.setValue(hValue);
                    }
                } else if (vValue > 0) {
                    vValue = Math.max(vValue - scrollAmount, 0);
                    this.verticalScrollBar.setValue(vValue);
                }
            }
        }
    }

    private static class HubQuickFilter
    implements TextQuickFilter {
        private final HubSeedManager _manager;
        private String _filterText = "";

        public HubQuickFilter(HubSeedManager manager) {
            this._manager = manager;
        }

        public String getText() {
            return this._filterText;
        }

        public void setText(String text) {
            this._filterText = text != null ? text.toLowerCase() : "";
            this._manager.setFilterText(this._filterText);
            SwingUtilities.invokeLater(() -> this._manager.refresh(false));
        }

        public boolean accept(Object o) {
            return true;
        }
    }

    private class FilterChangeListener
    implements PropertyChangeListener {
        private FilterChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("filtersCleared".equals(evt.getPropertyName())) {
                if (HubFilterPanel.this.searchPanel != null) {
                    HubFilterPanel.this.searchPanel.clear();
                }
                if (HubFilterPanel.this.displayFilterToolbar != null) {
                    HubFilterPanel.this.displayFilterToolbar.resetState();
                }
            }
        }
    }

    private class VerticalDivider
    extends JPanel {
        public VerticalDivider(int width) {
            this.setBackground(DIVIDER_VERTICAL_BG);
            this.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
            this.setPreferredSize(new Dimension(width, 1));
        }
    }
}

