/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;

public class EntityPreview
extends JPanel {
    private final ImageIcon entityIcon;
    private final ImageIcon overlayIcon;
    private Image entityImage;
    private String displayValue;
    private boolean typeOverlay = false;
    private boolean focusEntity;
    private boolean focusText;
    private OverlayDescriptor.Position highlight;
    private OverlayDescriptorSet overlays = new OverlayDescriptorSet();

    public EntityPreview() {
        this.entityIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/entity/manager/resources/Entity48.png", (boolean)true);
        this.overlayIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/entity/manager/resources/ImageField48.png", (boolean)true);
        this.setLightsOff();
        this.setEntityImage(null);
        this.setDisplayValue(null);
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        HashMap<RenderingHints.Key, Object> aa = new HashMap<RenderingHints.Key, Object>();
        aa.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aa.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        RenderingHints hints = new RenderingHints(aa);
        g2D.setRenderingHints(hints);
        double scale = 0.01;
        double width = this.getWidth();
        double height = this.getHeight();
        double minWH = Math.min(width, height);
        double diameter = minWH * 0.975;
        double x = (width - diameter) / 2.0;
        double y = (height - diameter) / 2.0;
        double onehth = diameter * scale;
        Rectangle2D entityRect = this.drawEntityImage(g2D, x, y, diameter, onehth);
        this.drawDisplayText(g2D, x, y, diameter, onehth);
        this.drawOverlays(g2D, entityRect, onehth);
    }

    private void drawOuterCircle(Graphics2D g2D, double x, double y, double diameter, double onehth) {
        Ellipse2D.Double circle = new Ellipse2D.Double(x, y, diameter, diameter);
        g2D.setStroke(new BasicStroke((float)onehth * 2.0f));
        g2D.setColor(Color.ORANGE);
        g2D.draw(circle);
    }

    private Rectangle2D drawEntityImage(Graphics2D g2D, double x, double y, double diameter, double onehth) {
        double radius = diameter / 2.0;
        double offset = -7.0 * onehth;
        Image image = this.typeOverlay ? this.entityIcon.getImage() : this.entityImage;
        image = ImageUtils.resize((Image)image, (int)((int)Math.round(radius)), (int)((int)Math.round(radius)));
        double xi = x + radius - (double)image.getWidth(null) / 2.0;
        double yi = y + radius - (double)image.getHeight(null) / 2.0 + offset;
        double eastX = xi + radius - 8.0 * onehth;
        Rectangle2D.Double rectangle = new Rectangle2D.Double(xi, yi, radius, radius);
        if (this.focusEntity) {
            g2D.setStroke(new BasicStroke((float)onehth * 2.0f));
            g2D.setColor(Color.GREEN);
            g2D.draw(rectangle);
        }
        g2D.drawImage(image, (int)Math.round(xi), (int)Math.round(yi), null);
        this.drawPaperClip(g2D, xi + radius + 10.0 * onehth, yi + radius / 2.0 - 6.5 * onehth, onehth);
        this.drawBookMark(g2D, eastX, yi - 2.5 * onehth, 16.5 * onehth, 19.0 * onehth, onehth);
        this.drawNote(g2D, eastX, yi + radius / 2.0 - 10.0 * onehth, 16.0 * onehth, 20.0 * onehth, onehth);
        this.drawPin(g2D, eastX, yi + radius - 15.0 * onehth, onehth);
        return rectangle;
    }

    private void drawDisplayText(Graphics2D g2D, double x, double y, double diameter, double onehth) {
        double yi = y + diameter / 2.0 + onehth * 27.0;
        double tbHeight = onehth * 10.0;
        g2D.setFont(new Font("SansSerif", 0, (int)(8.0 * onehth)));
        double textWidth = StringUtilities.getStringWidth((Graphics)g2D, (String)this.displayValue);
        if (textWidth > diameter) {
            textWidth = diameter;
        }
        float textX = (float)(x + (diameter - textWidth) / 2.0 + onehth / 2.0);
        float textY = (float)(yi + 7.5 * onehth);
        Rectangle2D.Double textBox = new Rectangle2D.Double(x, yi, diameter, tbHeight);
        g2D.setColor(Color.WHITE);
        g2D.fill(textBox);
        if (this.focusText) {
            g2D.setStroke(new BasicStroke((float)onehth * 2.0f));
            g2D.setColor(Color.GREEN);
        } else {
            g2D.setStroke(new BasicStroke((float)onehth * 0.7f));
            g2D.setColor(Color.GRAY);
        }
        g2D.draw(textBox);
        g2D.setColor(Color.DARK_GRAY);
        g2D.drawString(this.displayValue, textX, textY);
    }

    private void drawOverlays(Graphics2D g2D, Rectangle2D rectangle, double onehth) {
        double size = 15.5 * onehth;
        int N = 0;
        int NW = 1;
        int W = 2;
        int SW = 3;
        int S = 4;
        Rectangle2D[] overlayRect = new Rectangle2D[5];
        overlayRect[N] = new Rectangle2D.Double(rectangle.getCenterX() - 8.0 * onehth, rectangle.getY() - 10.0 * onehth, size, size);
        overlayRect[NW] = new Rectangle2D.Double(rectangle.getX() - 10.0 * onehth, rectangle.getY() - 1.5 * onehth, size, size);
        overlayRect[W] = new Rectangle2D.Double(rectangle.getX() - 10.0 * onehth, rectangle.getY() + 17.0 * onehth, size, size);
        overlayRect[SW] = new Rectangle2D.Double(rectangle.getX() - 10.0 * onehth, rectangle.getY() + 35.0 * onehth, size, size);
        overlayRect[S] = new Rectangle2D.Double(rectangle.getCenterX() - 8.0 * onehth, rectangle.getY() + rectangle.getWidth() - 6.0 * onehth, size, size);
        this.drawOverlay(g2D, overlayRect[N], OverlayDescriptor.Position.NORTH, onehth);
        this.drawOverlay(g2D, overlayRect[NW], OverlayDescriptor.Position.NORTH_WEST, onehth);
        this.drawOverlay(g2D, overlayRect[W], OverlayDescriptor.Position.WEST, onehth);
        this.drawOverlay(g2D, overlayRect[SW], OverlayDescriptor.Position.SOUTH_WEST, onehth);
        this.drawOverlay(g2D, overlayRect[S], OverlayDescriptor.Position.SOUTH, onehth);
    }

    private void drawOverlay(Graphics2D g2D, Rectangle2D rectangle, OverlayDescriptor.Position position, double onehth) {
        OverlayDescriptor overlay = this.overlays.stream().filter(descriptor -> position.equals((Object)descriptor.getPosition())).findFirst().orElse(null);
        if (this.highlight != null && position.equals((Object)this.highlight)) {
            if (overlay == null) {
                this.drawOveralyBox(g2D, rectangle, position, onehth);
                return;
            }
            if (!OverlayDescriptor.Type.TEXT.equals((Object)overlay.getType())) {
                this.drawOveralyBox(g2D, rectangle, position, onehth);
            }
        } else if (overlay == null) {
            this.drawOveralyBox(g2D, rectangle, position, onehth);
            return;
        }
        if (OverlayDescriptor.Type.IMAGE.equals((Object)overlay.getType())) {
            Image image = this.typeOverlay && OverlayDescriptor.Position.SOUTH_WEST.equals((Object)position) ? this.entityImage : this.overlayIcon.getImage();
            image = ImageUtils.resize((Image)image, (int)((int)Math.round(rectangle.getWidth())), (int)((int)Math.round(rectangle.getHeight())));
            g2D.drawImage(image, (int)Math.round(rectangle.getX()), (int)Math.round(rectangle.getY()), null);
        }
        if (OverlayDescriptor.Type.COLOUR.equals((Object)overlay.getType())) {
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrame(rectangle);
            g2D.setColor(Color.CYAN);
            g2D.fill(circle);
            g2D.setColor(Color.CYAN.darker().darker());
            g2D.setStroke(new BasicStroke((float)onehth * 0.8f));
            g2D.draw(circle);
        }
        if (OverlayDescriptor.Type.TEXT.equals((Object)overlay.getType())) {
            if (OverlayDescriptor.Position.SOUTH.equals((Object)position)) {
                this.drawOveralyBox(g2D, rectangle, position, onehth);
                return;
            }
            g2D.setFont(new Font("SansSerif", 0, (int)(8.0 * onehth)));
            double textWidth = StringUtilities.getStringWidth((Graphics)g2D, (String)"Text");
            float textY = (float)(rectangle.getY() + 11.0 * onehth);
            float textX = (float)(rectangle.getCenterX() - textWidth);
            if (OverlayDescriptor.Position.NORTH.equals((Object)position)) {
                textY -= (float)(8.0 * onehth);
                textX = (float)(rectangle.getCenterX() - textWidth / 2.0);
            }
            g2D.setColor(position.equals((Object)this.highlight) ? Color.GREEN.darker() : Color.DARK_GRAY);
            g2D.drawString("Text", textX, textY);
        }
    }

    private void drawOveralyBox(Graphics2D g2D, Rectangle2D rectangle, OverlayDescriptor.Position position, double onehth) {
        if (position.equals((Object)this.highlight)) {
            g2D.setStroke(new BasicStroke((float)onehth * 2.0f));
            g2D.setColor(Color.GREEN);
        } else {
            g2D.setStroke(new BasicStroke((float)onehth * 0.7f));
            g2D.setColor(Color.GRAY);
        }
        g2D.draw(rectangle);
    }

    private void drawPaperClip(Graphics2D g2D, double xPos, double yPos, double onehth) {
        AffineTransform oldTransform = g2D.getTransform();
        double scale = 0.5;
        g2D.scale(scale, scale);
        double x = xPos / scale;
        double y = yPos / scale;
        g2D.translate(x, y);
        double height = 14.0 * onehth / scale;
        double width = height / 2.0;
        double margin = width / 3.0;
        double[] xPoints = new double[]{width, width, width / 2.0, 0.0, 0.0, width - margin, width - margin, width / 2.0, margin, margin};
        double[] yPoints = new double[]{margin, height - width / 2.0, height, height - width / 2.0, 0.0, 0.0, height - width / 2.0 - margin, height - margin * 2.0, height - width / 2.0 - margin, margin};
        g2D.setColor(Color.DARK_GRAY);
        g2D.setStroke(new BasicStroke((float)((double)2.4f * onehth)));
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < xPoints.length; ++i) {
            ((Path2D)path).lineTo(xPoints[i], yPoints[i]);
        }
        g2D.draw(path);
        g2D.setTransform(oldTransform);
    }

    private void drawPin(Graphics2D g2D, double x, double y, double onehth) {
        double size = 19.0 * onehth;
        Color fillColor = Color.LIGHT_GRAY;
        float lineWidth = (float)(onehth * (double)0.8f);
        double[] xPointsPenta = new double[]{0.0, 0.25, 0.1, 0.2, 0.4, 0.6, 0.6, 1.0, 0.8, 0.6, 0.6, 0.5, 0.35};
        double[] yPointsPenta = new double[]{1.0, 0.65, 0.5, 0.4, 0.4, 0.2, 0.0, 0.4, 0.4, 0.6, 0.8, 0.9, 0.75};
        double[] xPoints = new double[xPointsPenta.length];
        double[] yPoints = new double[xPointsPenta.length];
        double margin = (double)lineWidth / 2.0;
        double roundingAdjustment = 0.0;
        for (int i = 0; i < xPoints.length; ++i) {
            xPoints[i] = x + ((size - 2.0 * margin) * xPointsPenta[i] + 0.0) + margin;
            yPoints[i] = y + ((size - 2.0 * margin) * yPointsPenta[i] + 0.0) + margin;
        }
        g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2D.setColor(fillColor);
        Path2D path = this.toPath2D(xPoints, yPoints);
        g2D.fill(path);
        g2D.setColor(fillColor.darker());
        g2D.draw(path);
    }

    private void drawBookMark(Graphics2D g2D, double x, double y, double w, double h, double onehth) {
        Color fillColor = Color.LIGHT_GRAY;
        Color lineColor = fillColor.darker();
        float lineWidth = (float)(onehth * (double)0.8f);
        int newH = (int)(h * 0.8);
        int newW = (int)(w * 0.8);
        int boxHeight = (int)((float)newH / 5.0f * 3.0f);
        int boxWidth = (int)((float)newW * 0.8f);
        int newX = (int)(x + (w - (double)newW) / 2.0 + (double)((newW - boxWidth) / 2));
        int newY = (int)(y + (h - (double)newH) / 2.0);
        g2D.translate(newX, newY);
        int[] xPoints = new int[]{0, boxWidth, boxWidth, (int)((float)boxWidth / 2.0f), 0, 0};
        int[] yPoints = new int[]{0, 0, newH, boxHeight, newH, 0};
        g2D.setColor(fillColor);
        g2D.fillPolygon(xPoints, yPoints, xPoints.length);
        g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2D.setColor(lineColor);
        g2D.drawPolygon(xPoints, yPoints, xPoints.length);
        g2D.translate(-newX, -newY);
    }

    private void drawNote(Graphics2D g2D, double x, double y, double w, double h, double onehth) {
        AffineTransform oldTransform = g2D.getTransform();
        g2D.translate(x, y);
        Color color = Color.LIGHT_GRAY;
        float lineWidth = (float)(onehth * (double)0.8f);
        int corner = (int)w / 2;
        int margin = (int)(3.0 * onehth);
        int[] xPoints = new int[]{margin, margin, (int)(w - (double)margin), (int)(w - (double)margin), corner, margin};
        int[] yPoints = new int[]{margin, (int)(h - (double)margin), (int)(h - (double)margin), corner, margin, margin};
        g2D.setColor(color);
        g2D.fillPolygon(xPoints, yPoints, xPoints.length);
        g2D.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2D.setColor(Color.GRAY);
        g2D.drawPolygon(xPoints, yPoints, xPoints.length);
        g2D.drawLine(corner, margin, corner, corner);
        g2D.drawLine(corner, corner, (int)(w - (double)margin), corner);
        g2D.setTransform(oldTransform);
    }

    private Path2D toPath2D(double[] xPoints, double[] yPoints) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < xPoints.length; ++i) {
            ((Path2D)path).lineTo(xPoints[i], yPoints[i]);
        }
        path.closePath();
        return path;
    }

    public void setEntityImage(Image image) {
        if (image == null) {
            image = this.entityIcon.getImage();
        }
        this.entityImage = image;
        this.repaint();
    }

    public void setDisplayValue(String displayValue) {
        if (displayValue == null || displayValue.trim().isEmpty()) {
            displayValue = "Display Value";
        }
        this.displayValue = displayValue;
        this.repaint();
    }

    public void setOverlay(OverlayDescriptor.Position position, OverlayDescriptor.Type type, String property) {
        if (property == null || property.trim().isEmpty()) {
            this.overlays.removeIf(overlay -> position.equals((Object)overlay.getPosition()));
        } else {
            this.overlays.add(new OverlayDescriptor(property, position.code, type.type));
        }
        this.repaint();
    }

    public void setTypeOverlay(boolean typeOverlay) {
        this.typeOverlay = typeOverlay;
        String property = typeOverlay ? "TYPE Overlay" : null;
        this.setOverlay(OverlayDescriptor.Position.SOUTH_WEST, OverlayDescriptor.Type.IMAGE, property);
    }

    public void setHighLightOverlay(OverlayDescriptor.Position position) {
        this.highlight = position;
        this.focusEntity = false;
        this.focusText = false;
        this.repaint();
    }

    public void setHighlightEntity() {
        this.focusEntity = true;
        this.focusText = false;
        this.highlight = null;
        this.repaint();
    }

    public void setHighlightText() {
        this.focusText = true;
        this.focusEntity = false;
        this.highlight = null;
        this.repaint();
    }

    public void setLightsOff() {
        this.focusText = false;
        this.focusEntity = false;
        this.highlight = null;
        this.repaint();
    }
}

