/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.EntityRegistryTableModel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.util.List;

class EntityQuickFilter
implements TextQuickFilter {
    private String _text;
    private final EntityRegistryTableModel _model;
    private final List<MaltegoEntitySpec> _specs;

    public EntityQuickFilter(EntityRegistryTableModel model) {
        this._model = model;
        this._specs = this._model.getRows();
    }

    public boolean accept(Object obj) {
        if (obj instanceof String) {
            String displayNameColumnValue = ((String)obj).toLowerCase();
            return displayNameColumnValue.contains(this._text) || this.descriptionOrTypeContainsSearch(displayNameColumnValue);
        }
        return true;
    }

    private boolean descriptionOrTypeContainsSearch(String displayNameColumnValue) {
        if (this._specs != null) {
            for (MaltegoEntitySpec spec : this._specs) {
                String specDisplayName = spec.getDisplayName();
                if (!displayNameColumnValue.equalsIgnoreCase(specDisplayName)) continue;
                String description = spec.getDescription();
                if (description != null && description.toLowerCase().contains(this._text)) {
                    return true;
                }
                String typeName = spec.getTypeName();
                if (typeName == null || !typeName.toLowerCase().contains(this._text)) continue;
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text.toLowerCase();
    }
}

