/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;

public class CheckRecordComponentAdapter
extends RecordComponentVisitor {
    private boolean visitEndCalled;

    public CheckRecordComponentAdapter(RecordComponentVisitor recordComponentVisitor) {
        this(0x1080000, recordComponentVisitor);
        if (this.getClass() != CheckRecordComponentAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckRecordComponentAdapter(int api, RecordComponentVisitor recordComponentVisitor) {
        super(api, recordComponentVisitor);
    }

    public AnnotationVisitor visitAnnotationExperimental(String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkDescriptor(49, descriptor, false);
        return new CheckAnnotationAdapter(super.visitAnnotationExperimental(descriptor, visible));
    }

    public AnnotationVisitor visitTypeAnnotationExperimental(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        int sort = new TypeReference(typeRef).getSort();
        if (sort != 19) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(49, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotationExperimental(typeRef, typePath, descriptor, visible));
    }

    public void visitAttributeExperimental(Attribute attribute) {
        this.checkVisitEndNotCalled();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttributeExperimental(attribute);
    }

    public void visitEndExperimental() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEndExperimental();
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

