/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text.action;

import com.jsql.util.LogLevel;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCharAction
extends TextAction {
    private static final Logger LOGGER = LogManager.getRootLogger();

    protected AbstractCharAction(String deleteAction) {
        super(deleteAction);
    }

    protected abstract void delete(Document var1, int var2) throws BadLocationException;

    @Override
    public void actionPerformed(ActionEvent event) {
        JTextComponent target = this.getTextComponent(event);
        if (target == null || !target.isEditable()) {
            return;
        }
        try {
            Document doc = target.getDocument();
            Caret caret = target.getCaret();
            int dot = caret.getDot();
            int mark = caret.getMark();
            if (dot != mark) {
                doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
            } else {
                this.delete(doc, dot);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

