/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabMouseAdapter
extends MouseAdapter {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private TabbedPaneWheeled tabbedPaneWheeled;

    public TabMouseAdapter(TabbedPaneWheeled tabbedPaneWheeled) {
        this.tabbedPaneWheeled = tabbedPaneWheeled;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (!SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        Component componentSource = (Component)event.getSource();
        JPopupMenu menu = new JPopupMenu();
        for (int position = 0; position < MediatorHelper.menubar().getMenuView().getMenuComponentCount(); ++position) {
            try {
                JMenuItem itemMenu = (JMenuItem)SerializationUtils.clone(MediatorHelper.menubar().getMenuView().getMenuComponent(position));
                menu.add(itemMenu);
                int positionFinal = position;
                itemMenu.addActionListener(actionEvent -> this.tabbedPaneWheeled.setSelectedIndex(positionFinal));
                continue;
            }
            catch (SerializationException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        menu.show(componentSource, event.getX(), event.getY());
        menu.setLocation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()) == ComponentOrientation.RIGHT_TO_LEFT ? event.getXOnScreen() - menu.getWidth() : event.getXOnScreen(), event.getYOnScreen());
    }
}

