/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.tab.TabMouseAdapter;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.ui.CustomMetalTabbedPaneUI;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class TabManagers
extends TabbedPaneWheeled {
    public TabManagers() {
        this.setUI(new CustomMetalTabbedPaneUI(){

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                return Math.max(75, super.calculateTabWidth(tabPlacement, tabIndex, metrics));
            }
        });
        this.addChangeListener(e -> MediatorHelper.tabManagers().setSelectedIndex(this.getSelectedIndex()));
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, 25));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 25));
        this.addMouseClickMenu();
        this.setMinimumSize(new Dimension(100, 0));
        this.buildI18nTab("DATABASE_TAB", "DATABASE_TOOLTIP", UiUtil.ICON_DATABASE_SERVER, null, 0);
        this.buildI18nTab("ADMINPAGE_TAB", "ADMINPAGE_TOOLTIP", UiUtil.ICON_ADMIN_SERVER, null, 1);
        this.buildI18nTab("FILE_TAB", "FILE_TOOLTIP", UiUtil.ICON_FILE_SERVER, null, 2);
        this.buildI18nTab("WEBSHELL_TAB", "WEBSHELL_TOOLTIP", UiUtil.ICON_SHELL_SERVER, null, 3);
        this.buildI18nTab("SQLSHELL_TAB", "SQLSHELL_TOOLTIP", UiUtil.ICON_SHELL_SERVER, null, 4);
        this.buildI18nTab("UPLOAD_TAB", "UPLOAD_TOOLTIP", UiUtil.ICON_UPLOAD, null, 5);
        this.buildI18nTab("BRUTEFORCE_TAB", "BRUTEFORCE_TOOLTIP", UiUtil.ICON_BRUTER, null, 6);
        this.buildI18nTab("CODER_TAB", "CODER_TOOLTIP", UiUtil.ICON_CODER, null, 7);
        this.buildI18nTab("SCANLIST_TAB", "SCANLIST_TOOLTIP", UiUtil.ICON_SCANLIST, null, 8);
    }

    private void buildI18nTab(String keyLabel, final String keyTooltip, Icon icon, Component manager, final int index) {
        final JToolTipI18n[] refTooltip = new JToolTipI18n[]{new JToolTipI18n(I18nUtil.valueByKey(keyTooltip))};
        JLabel labelTab = new JLabel(I18nUtil.valueByKey(keyLabel), icon, 0){

            @Override
            public JToolTip createToolTip() {
                JToolTipI18n tipI18n;
                refTooltip[0] = tipI18n = new JToolTipI18n(I18nUtil.valueByKey(keyTooltip));
                return tipI18n;
            }
        };
        labelTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MediatorHelper.tabManagers().setSelectedIndex(index);
                TabManagers.this.setSelectedIndex(index);
                super.mousePressed(e);
            }
        });
        this.addTab(I18nUtil.valueByKey(keyLabel), icon, manager);
        this.setTabComponentAt(this.indexOfTab(I18nUtil.valueByKey(keyLabel)), labelTab);
        I18nViewUtil.addComponentForKey(keyLabel, labelTab);
        I18nViewUtil.addComponentForKey(keyTooltip, refTooltip[0]);
        labelTab.setToolTipText(I18nUtil.valueByKey(keyTooltip));
        labelTab.addMouseListener(new TabMouseAdapter(this));
    }
}

