/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.radio;

import com.jsql.view.swing.util.UiUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;

public abstract class AbstractRadioLink
extends JLabel {
    protected AbstractRadioLink(String string, boolean isSelected) {
        this(string);
        if (isSelected) {
            this.setUnderlined();
        }
    }

    protected AbstractRadioLink(String string) {
        super(string);
    }

    public abstract void action();

    public abstract List<JLabel> getGroup();

    protected boolean isActivable() {
        return !this.getFont().getAttributes().containsValue(TextAttribute.WEIGHT_BOLD);
    }

    public final void setUnderlined() {
        Font font = this.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        this.setFont(font.deriveFont(attributes));
    }

    public void removeFont() {
        Font font = this.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        this.setFont(font.deriveFont(attributes));
    }

    public void setSelected() {
        for (JLabel label : this.getGroup()) {
            if (this != label) {
                label.setFont(UiUtil.FONT_NON_MONO);
                continue;
            }
            this.action();
        }
        this.setUnderlined();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

