/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.popupmenu;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.menubar.JMenuItemWithMargin;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JPopupMenuTable
extends JPopupMenu {
    private JTable table;

    public JPopupMenuTable(JTable table) {
        this.table = table;
        table.setComponentPopupMenu(this);
        JMenuItemWithMargin copyItem = new JMenuItemWithMargin(new ActionCopy());
        copyItem.setText(I18nUtil.valueByKey("CONTEXT_MENU_COPY"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY", copyItem);
        copyItem.setMnemonic('C');
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.add(copyItem);
        this.addSeparator();
        JMenuItemWithMargin selectAllItem = new JMenuItemWithMargin(new ActionSelectAll());
        selectAllItem.setText(I18nUtil.valueByKey("CONTEXT_MENU_SELECT_ALL"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_SELECT_ALL", selectAllItem);
        selectAllItem.setMnemonic('A');
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.add(selectAllItem);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (MouseInfo.getPointerInfo() != null) {
                    JPopupMenuTable.this.setLocation(MouseInfo.getPointerInfo().getLocation());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public JPopupMenuTable(JTable tableValues, Action actionShowSearchTable) {
        this(tableValues);
        this.addSeparator();
        JMenuItemWithMargin search = new JMenuItemWithMargin();
        search.setAction(actionShowSearchTable);
        search.setText("Search...");
        search.setMnemonic('S');
        search.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.add(search);
    }

    private class ActionCopy
    extends AbstractAction {
        private ActionCopy() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionEvent copyEvent = new ActionEvent(JPopupMenuTable.this.table, 1001, "copy");
            JPopupMenuTable.this.table.getActionMap().get(copyEvent.getActionCommand()).actionPerformed(copyEvent);
        }
    }

    private class ActionSelectAll
    extends AbstractAction {
        private ActionSelectAll() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenuTable.this.table.selectAll();
        }
    }
}

