/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.accessible.CallableHttpHead;
import com.jsql.model.accessible.ResourceAccess;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.suspendable.callable.ThreadFactoryCallable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerAdminPage
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public ManagerAdminPage() {
        super("swing/list/admin-page.txt");
        this.initializeRunButton();
        this.lastLine.setLayout(new BorderLayout());
        this.lastLine.setPreferredSize(new Dimension(0, 26));
        JPanel panelRunButton = new JPanel();
        panelRunButton.setLayout(new BoxLayout(panelRunButton, 0));
        panelRunButton.add(Box.createHorizontalGlue());
        panelRunButton.add(this.loader);
        panelRunButton.add(Box.createRigidArea(new Dimension(5, 0)));
        panelRunButton.add(this.run);
        this.lastLine.add((Component)panelRunButton, "After");
        this.add((Component)this.lastLine, "South");
    }

    private void initializeRunButton() {
        this.defaultText = "ADMIN_PAGE_RUN_BUTTON_LABEL";
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey("ADMIN_PAGE_RUN_BUTTON_LABEL", this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("ADMIN_PAGE_RUN_BUTTON_TOOLTIP"));
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(actionEvent -> this.runSearch());
        this.loader.setVisible(false);
    }

    private void runSearch() {
        if (this.listFile.getSelectedValuesList().isEmpty()) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Select at least one admin page in the list");
            return;
        }
        Object urlAddressBar = MediatorHelper.panelAddressBar().getTextFieldAddress().getText();
        if (!((String)urlAddressBar).isEmpty() && !((String)urlAddressBar).matches("(?i)^https?://.*")) {
            if (!((String)urlAddressBar).matches("(?i)^\\w+://.*")) {
                LOGGER.log(LogLevel.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_NO_PROTOCOL"));
                urlAddressBar = "http://" + (String)urlAddressBar;
            } else {
                LOGGER.log(LogLevel.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_UNKNOWN_PROTOCOL"));
                return;
            }
        }
        String urlFinal = urlAddressBar;
        new Thread(() -> this.searchAdminPages(urlFinal), "ThreadAdminPage").start();
    }

    private void searchAdminPages(String urlAddressBar) {
        if (this.run.getState() == StateButton.STARTABLE) {
            if (StringUtils.isEmpty(urlAddressBar)) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "URL in the address bar is missing");
            } else {
                LOGGER.log(LogLevel.CONSOLE_DEFAULT, "Checking admin page(s)...");
                this.run.setText(I18nViewUtil.valueByKey("ADMIN_PAGE_RUN_BUTTON_STOP"));
                this.run.setState(StateButton.STOPPABLE);
                this.loader.setVisible(true);
                try {
                    this.createAdminPages(urlAddressBar, this.listFile.getSelectedValuesList());
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        } else if (this.run.getState() == StateButton.STOPPABLE) {
            MediatorHelper.model().getResourceAccess().setSearchAdminStopped(true);
            this.run.setEnabled(false);
            this.run.setState(StateButton.STOPPING);
        }
    }

    public void createAdminPages(String urlInjection, List<ItemList> pageNames) throws InterruptedException {
        int n;
        int tasksHandled;
        Matcher matcher = Pattern.compile("^((https?://)?[^/]*)(.*)").matcher(urlInjection);
        matcher.find();
        String urlProtocol = matcher.group(1);
        String urlWithoutProtocol = matcher.group(3);
        ArrayList<CallSite> folderSplits = new ArrayList<CallSite>();
        if (urlWithoutProtocol.isEmpty() || !Pattern.matches("^/.*", urlWithoutProtocol)) {
            urlWithoutProtocol = "/dummy";
        }
        String[] splits = urlWithoutProtocol.split("/", -1);
        String[] folderNames = Arrays.copyOf(splits, splits.length - 1);
        for (String folderName : Arrays.asList(folderNames)) {
            folderSplits.add((CallSite)((Object)(folderName + "/")));
        }
        ExecutorService taskExecutor = Executors.newFixedThreadPool(10, new ThreadFactoryCallable("CallableGetAdminPage"));
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String string : folderSplits) {
            urlPart.append(string);
            for (ItemList pageName : pageNames) {
                taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart.toString() + pageName.toString(), MediatorHelper.model(), "check:page"));
            }
        }
        ResourceAccess resourceAccess = MediatorHelper.model().getResourceAccess();
        boolean bl = false;
        int submittedTasks = folderSplits.size() * pageNames.size();
        for (tasksHandled = 0; tasksHandled < submittedTasks && !resourceAccess.isSearchAdminStopped(); ++tasksHandled) {
            n = resourceAccess.callAdminPage(taskCompletionService, n);
        }
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        resourceAccess.setSearchAdminStopped(false);
        resourceAccess.logSearchAdminPage(n, submittedTasks, tasksHandled);
        Request request = new Request();
        request.setMessage(Interaction.END_ADMIN_SEARCH);
        MediatorHelper.model().sendToViews(request);
    }
}

