/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.AbstractListTransfertHandler;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListTransfertHandler
extends AbstractListTransfertHandler {
    private static final Logger LOGGER = LogManager.getRootLogger();

    @Override
    protected String initializeTransferable() {
        StringBuilder stringTransferable = new StringBuilder();
        for (ItemList itemPath : this.dragPaths) {
            stringTransferable.append(itemPath + "\n");
        }
        return stringTransferable.toString();
    }

    @Override
    protected void parseStringDrop(TransferHandler.TransferSupport support, DnDList list, DefaultListModel<ItemList> listModel) {
        JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
        int childIndex = dropLocation.getIndex();
        ArrayList<Integer> listSelectedIndices = new ArrayList<Integer>();
        if (this.dragPaths != null && !this.dragPaths.isEmpty()) {
            this.addFromList(listModel, childIndex, listSelectedIndices);
        } else {
            this.addFromOutside(support, listModel, childIndex, listSelectedIndices);
        }
        int[] selectedIndices = new int[listSelectedIndices.size()];
        int i = 0;
        for (Integer integer : listSelectedIndices) {
            selectedIndices[i] = integer;
            ++i;
        }
        list.setSelectedIndices(selectedIndices);
    }

    private void addFromOutside(TransferHandler.TransferSupport support, DefaultListModel<ItemList> listModel, int childIndexFrom, List<Integer> listSelectedIndices) {
        try {
            int childIndexTo = childIndexFrom;
            String importString = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            for (String value : importString.split("\\n")) {
                if (!StringUtils.isNotEmpty(value)) continue;
                listSelectedIndices.add(childIndexTo);
                listModel.add(childIndexTo++, new ItemList(value.replace("\\", "/")));
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private void addFromList(DefaultListModel<ItemList> listModel, int childIndexFrom, List<Integer> listSelectedIndices) {
        int childIndexTo = childIndexFrom;
        for (ItemList value : this.dragPaths) {
            if (!StringUtils.isNotEmpty(value.toString())) continue;
            ItemList newValue = new ItemList(value.toString().replace("\\", "/"));
            listSelectedIndices.add(childIndexTo);
            listModel.add(childIndexTo++, newValue);
        }
    }

    @Override
    protected List<Integer> initializeStringPaste(String clipboardText, int selectedIndexFrom, DefaultListModel<ItemList> listModel) {
        int selectedIndexTo = selectedIndexFrom;
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        for (String line : clipboardText.split("\\n")) {
            if (!StringUtils.isNotEmpty(line)) continue;
            String newLine = line.replace("\\", "/");
            ItemList newItem = new ItemList(newLine);
            selectedIndexes.add(selectedIndexTo);
            listModel.add(selectedIndexTo++, newItem);
        }
        return selectedIndexes;
    }
}

