/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.interaction;

import com.jsql.model.bean.util.Request;
import com.jsql.util.LogLevel;
import com.jsql.view.interaction.InteractionCommand;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObserverInteraction
implements Observer {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String packageInteraction;

    public ObserverInteraction(String packageInteraction) {
        this.packageInteraction = packageInteraction;
    }

    @Override
    public void update(Observable model, Object newInteraction) {
        Request interaction = (Request)newInteraction;
        try {
            Class<?> cl = Class.forName(this.packageInteraction + "." + interaction.getMessage());
            Class[] types = new Class[]{Object[].class};
            Constructor<?> ct = cl.getConstructor(types);
            InteractionCommand o2 = (InteractionCommand)ct.newInstance(new Object[]{interaction.getParameters()});
            o2.execute();
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(LogLevel.IGNORE, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

