/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.callable.ThreadFactoryCallable;
import com.jsql.util.LogLevel;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThreadUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Map<AbstractElementDatabase, AbstractSuspendable> suspendables = new HashMap<AbstractElementDatabase, AbstractSuspendable>();
    private InjectionModel injectionModel;

    public ThreadUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void put(AbstractElementDatabase elementDatabase, AbstractSuspendable suspendable) {
        this.suspendables.put(elementDatabase, suspendable);
    }

    public AbstractSuspendable get(AbstractElementDatabase elementDatabase) {
        return this.suspendables.get(elementDatabase);
    }

    public void remove(AbstractElementDatabase elementDatabase) {
        this.suspendables.remove(elementDatabase);
    }

    public void reset() {
        try {
            this.suspendables.values().stream().forEach(AbstractSuspendable::stop);
            this.suspendables.clear();
        }
        catch (ConcurrentModificationException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public ExecutorService getExecutor(String a) {
        ExecutorService taskExecutor;
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingThreads()) {
            int countThreads = this.injectionModel.getMediatorUtils().getPreferencesUtil().countLimitingThreads();
            taskExecutor = Executors.newFixedThreadPool(countThreads, new ThreadFactoryCallable(a));
        } else {
            taskExecutor = Executors.newCachedThreadPool(new ThreadFactoryCallable(a));
        }
        return taskExecutor;
    }
}

