/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.util.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Properties properties = new Properties();

    public PropertiesUtil() {
        String filename = "config.properties";
        try (InputStream input = PropertiesUtil.class.getClassLoader().getResourceAsStream(filename);){
            if (input == null) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "Properties file {} not found", (Object)filename);
                return;
            }
            this.getProperties().load(input);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

