/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeaderUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String CONTENT_TYPE_REQUEST = "Content-Type";
    private static final String WWW_AUTHENTICATE_RESPONSE = "www-authenticate";
    private static final String REGEX_HTTP_STATUS = "4\\d\\d";
    private static final String FOUND_STATUS_HTTP = "Found status HTTP";
    private InjectionModel injectionModel;

    public HeaderUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public static void sanitizeHeaders(HttpRequest.Builder httpRequest, AbstractMap.SimpleEntry<String, String> header) {
        String keyHeader = header.getKey().trim();
        String valueHeader = header.getValue().trim();
        try {
            if ("Cookie".equalsIgnoreCase(keyHeader)) {
                httpRequest.setHeader(keyHeader, valueHeader);
            } else {
                httpRequest.setHeader(keyHeader, URLDecoder.decode(valueHeader, StandardCharsets.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public HttpResponse<String> checkResponseHeader(HttpRequest.Builder httpRequestBuilder) throws IOException, InterruptedException {
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse<String> httpResponse = this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        String pageSource = httpResponse.body();
        Map<String, String> mapHeaders = ConnectionUtil.getHeadersMap(httpResponse);
        String responseCode = Integer.toString(httpResponse.statusCode());
        this.checkResponse(responseCode, mapHeaders);
        this.checkStatus(httpResponse);
        this.injectionModel.getMediatorUtils().getFormUtil().parseForms(httpResponse.statusCode(), pageSource);
        this.injectionModel.getMediatorUtils().getCsrfUtil().parseForCsrfToken(pageSource, mapHeaders);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, httpRequest.uri().toURL().toString());
        msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
        msgHeader.put(Header.RESPONSE, mapHeaders);
        msgHeader.put(Header.SOURCE, pageSource);
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return httpResponse;
    }

    private Exception checkStatus(HttpResponse<String> response) throws IOException {
        IOException exception = null;
        if (response.statusCode() >= 400) {
            exception = new IOException(String.format("problem when calling %s", response.uri().toURL().toString()));
        }
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotTestingConnection()) {
            if (exception != null) {
                LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Connection test disabled, ignoring response HTTP {}...", (Object)response.statusCode());
            }
            exception = null;
        } else if (exception != null) {
            LOGGER.log(LogLevel.CONSOLE_INFORM, "Select option 'Disable connection test' if required");
        }
        return exception;
    }

    private void checkResponse(String responseCode, Map<String, String> mapResponse) {
        if (this.isBasicAuth(responseCode, mapResponse)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Basic Authentication detected: define and enable authentication information in the panel Preferences, or open Advanced panel, add 'Authorization: Basic b3N..3Jk' to the Header, replace b3N..3Jk with the string 'osUserName:osPassword' encoded in Base64. You can use the Coder in jSQL to encode the string.");
        } else if (this.isNtlm(responseCode, mapResponse)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "NTLM Authentication detected: define and enable authentication information in the panel Preferences, or add username, password and domain information to the URL, e.g. http://domain\\user:password@127.0.0.1/[..]");
        } else if (this.isDigest(responseCode, mapResponse)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Digest Authentication detected: define and enable authentication information in the panel Preferences.");
        } else if (this.isNegotiate(responseCode, mapResponse)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Negotiate Authentication detected: add username, password and domain information to the URL, e.g. http://domain\\user:password@127.0.0.1/[..]");
        } else if (Pattern.matches("1\\d\\d", responseCode)) {
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, "{} {} Informational", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("2\\d\\d", responseCode)) {
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, "{} {} Success", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("3\\d\\d", responseCode)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "{} {} Redirection", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
            if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isFollowingRedirection()) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "If injection fails retry with option 'Follow HTTP redirection' activated");
            } else {
                LOGGER.log(LogLevel.CONSOLE_INFORM, "Redirecting to the next page...");
            }
        } else if (Pattern.matches(REGEX_HTTP_STATUS, responseCode)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "{} {} Client Error", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("5\\d\\d", responseCode)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "{} {} Server Error", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else {
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, "{} {} Unknown", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        }
    }

    private boolean isNegotiate(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && "Negotiate".equals(mapResponse.get(WWW_AUTHENTICATE_RESPONSE));
    }

    private boolean isDigest(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && mapResponse.get(WWW_AUTHENTICATE_RESPONSE) != null && mapResponse.get(WWW_AUTHENTICATE_RESPONSE).startsWith("Digest ");
    }

    private boolean isNtlm(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && "NTLM".equals(mapResponse.get(WWW_AUTHENTICATE_RESPONSE));
    }

    private boolean isBasicAuth(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && mapResponse.get(WWW_AUTHENTICATE_RESPONSE) != null && mapResponse.get(WWW_AUTHENTICATE_RESPONSE).startsWith("Basic ");
    }
}

