/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JSONObject jsonObject;
    private InjectionModel injectionModel;

    public GitUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void checkUpdate(ShowOnConsole displayUpdateMessage) {
        if (displayUpdateMessage == ShowOnConsole.YES) {
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("UPDATE_LOADING"));
        }
        try {
            float versionGit = Float.parseFloat(this.getJSONObject().getString("version"));
            if (versionGit > Float.parseFloat(this.injectionModel.getVersionJsql())) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, () -> I18nUtil.valueByKey("UPDATE_NEW_VERSION"));
            } else if (displayUpdateMessage == ShowOnConsole.YES) {
                LOGGER.log(LogLevel.CONSOLE_SUCCESS, () -> I18nUtil.valueByKey("UPDATE_UPTODATE"));
            }
        }
        catch (IOException | NumberFormatException | JSONException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, I18nUtil.valueByKey("UPDATE_EXCEPTION"), (Throwable)e);
        }
    }

    public void sendUnhandledException(String threadName, Throwable throwable) {
        String javaVersion = System.getProperty("java.version");
        String osArch = System.getProperty("os.arch");
        String osMetadata = String.join((CharSequence)"\n", String.format("jSQL: v%s", this.injectionModel.getVersionJsql()), String.format("Java: v%s-%s-%s on %s", javaVersion, osArch, System.getProperty("user.language"), System.getProperty("java.runtime.name")), String.format("OS: %s (v%s)", System.getProperty("os.name"), System.getProperty("os.version")), String.format("Desktop: %s", System.getProperty("sun.desktop") != null ? System.getProperty("sun.desktop") : "undefined"), String.format("Strategy: %s", this.injectionModel.getMediatorStrategy().getStrategy() != null ? this.injectionModel.getMediatorStrategy().getStrategy().getName() : "undefined"), String.format("Db engine: %s", this.injectionModel.getMediatorVendor().getVendor().toString()));
        String exceptionText = String.format("Exception on %s%n%s%n", threadName, ExceptionUtils.getStackTrace(throwable).trim());
        String clientDescription = String.format("```%n%s%n```%n```%n%s```", osMetadata, exceptionText);
        clientDescription = clientDescription.replaceAll("(https?://[.a-zA-Z_0-9]*)+", "");
        this.sendReport(clientDescription, ShowOnConsole.NO, "Unhandled " + throwable.getClass().getSimpleName());
    }

    public void sendReport(String reportBody, ShowOnConsole showOnConsole, String reportTitle) {
        block4: {
            if (!this.injectionModel.getMediatorUtils().getProxyUtil().isLive(showOnConsole)) {
                return;
            }
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("github.issues.url"))).setHeader("Authorization", "token " + StringUtils.newStringUtf8(Base64.decodeBase64(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("github.token")))).POST(HttpRequest.BodyPublishers.ofString(new JSONObject().put("title", reportTitle).put("body", reportBody).toString())).timeout(Duration.ofSeconds(15L)).build();
            try {
                HttpResponse<String> response = this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
                this.readGithubResponse(response, showOnConsole);
            }
            catch (IOException | InterruptedException e) {
                if (showOnConsole == ShowOnConsole.YES) {
                    LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Error during Github report connection: %s", e.getMessage()), (Throwable)e);
                }
                if (!(e instanceof InterruptedException)) break block4;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void readGithubResponse(HttpResponse<String> response, ShowOnConsole showOnConsole) throws IOException {
        try {
            String sourcePage = response.body();
            if (showOnConsole == ShowOnConsole.YES) {
                JSONObject jsonObjectResponse = new JSONObject(sourcePage);
                String urlIssue = jsonObjectResponse.getString("html_url");
                LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Sent to Github: {}", (Object)urlIssue);
            }
        }
        catch (Exception e) {
            throw new IOException("Connection to the Github API failed, check your connection or update jsql");
        }
    }

    public void showNews() {
        try {
            JSONArray news = this.getJSONObject().getJSONArray("news");
            for (int index = 0; index < news.length(); ++index) {
                LOGGER.log(LogLevel.CONSOLE_INFORM, news.get(index));
            }
        }
        catch (IOException | JSONException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Connection to the Github API failed", (Throwable)e);
        }
    }

    public JSONObject getJSONObject() throws IOException {
        if (this.jsonObject == null) {
            String json = this.injectionModel.getMediatorUtils().getConnectionUtil().getSource(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("github.webservice.url"));
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                try {
                    this.jsonObject = new JSONObject("{\"version\": \"0\", \"news\": []}");
                }
                catch (JSONException e1) {
                    LOGGER.log(LogLevel.CONSOLE_ERROR, "Fetching default JSON failed", (Throwable)e);
                }
                LOGGER.log(LogLevel.CONSOLE_ERROR, "Fetching configuration from Github failed. Wait for service to be available, check your connection or update jsql", (Throwable)e);
            }
        }
        return this.jsonObject;
    }

    public static enum ShowOnConsole {
        YES,
        NO;

    }
}

