/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevel;
import com.jsql.util.bruter.HashUtil;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private InjectionModel injectionModel;
    private Set<String> exceptionsMd5Cached = new CopyOnWriteArraySet<String>();

    public ExceptionUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        try {
            SwingUtilities.invokeAndWait(() -> Thread.currentThread().setUncaughtExceptionHandler(new ExceptionHandler()));
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, () -> String.format("Unhandled Exception on %s", thread.getName()), throwable);
            if (ExceptionUtil.this.injectionModel.getMediatorUtils().getPreferencesUtil().isReportingBugs() && ExceptionUtils.getStackTrace(throwable).contains("com.jsql") && !(throwable instanceof OutOfMemoryError)) {
                try {
                    String encodedPasswordInString;
                    MessageDigest md = MessageDigest.getInstance("Md5");
                    String stackTrace = ExceptionUtils.getStackTrace(throwable).trim();
                    String passwordString = String.valueOf(stackTrace.toCharArray());
                    byte[] passwordByte = passwordString.getBytes();
                    md.update(passwordByte, 0, passwordByte.length);
                    byte[] encodedPassword = md.digest();
                    String md5Exception = encodedPasswordInString = HashUtil.digestToHexString(encodedPassword);
                    if (!ExceptionUtil.this.exceptionsMd5Cached.contains(md5Exception)) {
                        ExceptionUtil.this.exceptionsMd5Cached.add(md5Exception);
                        ExceptionUtil.this.injectionModel.getMediatorUtils().getGitUtil().sendUnhandledException(thread.getName(), throwable);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(LogLevel.IGNORE, e);
                }
            }
        }
    }
}

