/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.HeaderUtil;
import com.jsql.util.LogLevel;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String urlByUser;
    private String urlBase;
    private AbstractMethodInjection methodInjection;
    private String typeRequest = "POST";
    private Random randomForUserAgent = new Random();
    private InjectionModel injectionModel;
    public CookieManager CookieManager = new CookieManager();

    public ConnectionUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public HttpClient getHttpClient() {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(this.getTimeout().intValue())).sslContext(this.injectionModel.getMediatorUtils().getCertificateUtil().getSslContext()).followRedirects(this.injectionModel.getMediatorUtils().getPreferencesUtil().isFollowingRedirection() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies()) {
            httpClientBuilder.cookieHandler(this.CookieManager);
        }
        if (this.injectionModel.getMediatorUtils().getAuthenticationUtil().isAuthentEnabled()) {
            httpClientBuilder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ConnectionUtil.this.injectionModel.getMediatorUtils().getAuthenticationUtil().getUsernameAuthentication(), ConnectionUtil.this.injectionModel.getMediatorUtils().getAuthenticationUtil().getPasswordAuthentication().toCharArray());
                }
            });
        }
        return httpClientBuilder.build();
    }

    public static <T> Map<String, String> getHeadersMap(HttpResponse<T> httpResponse) {
        Map<String, String> sortedMap = ConnectionUtil.getHeadersMap(httpResponse.headers());
        String responseCodeHttp = "" + httpResponse.statusCode();
        sortedMap.put(":status", responseCodeHttp);
        return sortedMap;
    }

    public static Map<String, String> getHeadersMap(HttpHeaders httpHeaders) {
        Map<String, String> unsortedMap = httpHeaders.map().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entrySet -> new AbstractMap.SimpleEntry<String, String>((String)entrySet.getKey(), String.join((CharSequence)", ", (Iterable)entrySet.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return new TreeMap<String, String>(unsortedMap);
    }

    public HttpResponse<String> testConnection() throws IOException, InterruptedException {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder().uri(URI.create(this.getUrlByUser().replace("*", ""))).setHeader("Content-Type", "text/plain").timeout(Duration.ofSeconds(this.getTimeout().intValue()));
        this.injectionModel.getMediatorUtils().getCsrfUtil().addHeaderToken(httpRequest);
        for (AbstractMap.SimpleEntry<String, String> header : this.injectionModel.getMediatorUtils().getParameterUtil().getListHeader()) {
            HeaderUtil.sanitizeHeaders(httpRequest, header);
        }
        return this.injectionModel.getMediatorUtils().getHeaderUtil().checkResponseHeader(httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getSource(String url, boolean lineFeed) throws IOException {
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, url);
        String pageSource = "";
        try {
            HttpHeaders httpHeaders;
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(this.getTimeout().intValue())).build();
            if (lineFeed) {
                HttpResponse<Stream<String>> response = this.getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofLines());
                pageSource = response.body().collect(Collectors.joining("\n"));
                httpHeaders = response.headers();
            } else {
                HttpResponse<String> response = this.getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
                pageSource = response.body();
                httpHeaders = response.headers();
            }
            msgHeader.put(Header.RESPONSE, ConnectionUtil.getHeadersMap(httpHeaders));
            msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
            msgHeader.put(Header.SOURCE, pageSource);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            msgHeader.put(Header.SOURCE, pageSource);
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.injectionModel.sendToViews(request);
        }
        catch (InterruptedException e2) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e2, (Throwable)e2);
            Thread.currentThread().interrupt();
            msgHeader.put(Header.SOURCE, pageSource);
            {
                catch (Throwable throwable) {
                    msgHeader.put(Header.SOURCE, pageSource);
                    Request request = new Request();
                    request.setMessage(Interaction.MESSAGE_HEADER);
                    request.setParameters(msgHeader);
                    this.injectionModel.sendToViews(request);
                    throw throwable;
                }
            }
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.injectionModel.sendToViews(request);
        }
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return pageSource.trim();
    }

    public String getSourceLineFeed(String url) throws IOException {
        return this.getSource(url, true);
    }

    public String getSource(String url) throws IOException {
        return this.getSource(url, false);
    }

    public void setCustomUserAgent(HttpRequest.Builder httpRequest) {
        if (this.injectionModel.getMediatorUtils().getUserAgentUtil().isCustomUserAgent()) {
            String agents = this.injectionModel.getMediatorUtils().getUserAgentUtil().getCustomUserAgent();
            List listAgents = Stream.of(agents.split("[\\r\\n]{1,}")).filter(q -> !q.matches("^#.*")).collect(Collectors.toList());
            String randomElement = (String)listAgents.get(this.randomForUserAgent.nextInt(listAgents.size()));
            httpRequest.setHeader("User-Agent", randomElement);
        }
    }

    public ConnectionUtil withMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
        return this;
    }

    public ConnectionUtil withTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
        return this;
    }

    public String getUrlByUser() {
        return this.urlByUser;
    }

    public void setUrlByUser(String urlByUser) {
        this.urlByUser = urlByUser;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public AbstractMethodInjection getMethodInjection() {
        return this.methodInjection;
    }

    public void setMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public void setTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
    }

    public Integer getTimeout() {
        return this.injectionModel.getMediatorUtils().getPreferencesUtil().countConnectionTimeout();
    }
}

