/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.SuspendableGetIndexes;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyInjectionNormal
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String performanceLength = "0";

    public StrategyInjectionNormal(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws JSqlException {
        LOGGER.log(LogLevel.CONSOLE_DEFAULT, "{} Normal...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
        this.injectionModel.setIndexesInUrl(new SuspendableGetIndexes(this.injectionModel).run(new Object[0]));
        if (StringUtils.isNotEmpty(this.injectionModel.getIndexesInUrl())) {
            this.visibleIndex = this.getVisibleIndex(this.sourceIndexesFound);
        }
        boolean bl = this.isApplicable = StringUtils.isNotEmpty(this.injectionModel.getIndexesInUrl()) && Integer.parseInt(this.injectionModel.getMediatorStrategy().getNormal().getPerformanceLength()) > 0 && StringUtils.isNotBlank(this.visibleIndex);
        if (this.isApplicable) {
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, "{} Normal injection at index [{}] using [{}] characters", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), () -> this.visibleIndex, () -> this.performanceLength);
            this.allow(new int[0]);
        } else {
            this.unallow(new int[0]);
        }
    }

    @Override
    public void allow(int ... i) {
        this.markVulnerability(Interaction.MARK_NORMAL_VULNERABLE, new int[0]);
    }

    @Override
    public void unallow(int ... i) {
        this.markVulnerability(Interaction.MARK_NORMAL_INVULNERABLE, new int[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injectionModel.injectWithIndexes(this.injectionModel.getMediatorVendor().getVendor().instance().sqlNormal(sqlQuery, startPosition), metadataInjectionProcess);
    }

    @Override
    public void activateStrategy() {
        LOGGER.log(LogLevel.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
        this.injectionModel.getMediatorStrategy().setStrategy(this.injectionModel.getMediatorStrategy().getNormal());
        Request request = new Request();
        request.setMessage(Interaction.MARK_NORMAL_STRATEGY);
        this.injectionModel.sendToViews(request);
    }

    public String getVisibleIndex(String firstSuccessPageSource) {
        Matcher regexSearch = Pattern.compile("(?s)1337(\\d+?)7331").matcher(firstSuccessPageSource);
        ArrayList<String> foundIndexes = new ArrayList<String>();
        while (regexSearch.find()) {
            foundIndexes.add(regexSearch.group(1));
        }
        CharSequence[] indexes = foundIndexes.toArray(new String[foundIndexes.size()]);
        String indexesInUrl = this.injectionModel.getIndexesInUrl().replaceAll("1337(?!" + String.join((CharSequence)"|", indexes) + "7331)\\d*7331", "1");
        String performanceQuery = this.injectionModel.getMediatorVendor().getVendor().instance().sqlCapacity((String[])indexes);
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(performanceQuery, "normal#size");
        regexSearch = Pattern.compile("(?s)SqLi(\\d+)(#+)").matcher(performanceSourcePage);
        ArrayList<String[]> performanceResults = new ArrayList<String[]>();
        while (regexSearch.find()) {
            performanceResults.add(new String[]{regexSearch.group(1), regexSearch.group(2)});
        }
        if (performanceResults.isEmpty() || indexesInUrl == null) {
            this.performanceLength = "0";
            return null;
        }
        Integer[][] lengthFields = new Integer[performanceResults.size()][2];
        for (int i = 0; i < performanceResults.size(); ++i) {
            lengthFields[i] = new Integer[]{((String[])performanceResults.get(i))[1].length() + ((String[])performanceResults.get(i))[0].length(), Integer.parseInt(((String[])performanceResults.get(i))[0])};
        }
        Arrays.sort(lengthFields, (s1, s2) -> s1[0].compareTo(s2[0]));
        Integer[] bestLengthFields = lengthFields[lengthFields.length - 1];
        this.performanceLength = bestLengthFields[0].toString();
        indexesInUrl = indexesInUrl.replaceAll("1337(?!" + bestLengthFields[1] + "7331)\\d*7331", "1");
        this.injectionModel.setIndexesInUrl(indexesInUrl);
        return Integer.toString(bestLengthFields[1]);
    }

    @Override
    public String getPerformanceLength() {
        return this.performanceLength;
    }

    @Override
    public String getVisibleIndex() {
        return this.visibleIndex;
    }

    @Override
    public void setVisibleIndex(String visibleIndex) {
        this.visibleIndex = visibleIndex;
    }

    @Override
    public String getName() {
        return "Normal";
    }
}

