/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model;

import com.jsql.model.AbstractModelObservable;
import com.jsql.model.MediatorUtils;
import com.jsql.model.accessible.DataAccess;
import com.jsql.model.accessible.ResourceAccess;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.model.injection.method.MediatorMethod;
import com.jsql.model.injection.strategy.MediatorStrategy;
import com.jsql.model.injection.vendor.MediatorVendor;
import com.jsql.util.AuthenticationUtil;
import com.jsql.util.CertificateUtil;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.CsrfUtil;
import com.jsql.util.ExceptionUtil;
import com.jsql.util.FormUtil;
import com.jsql.util.GitUtil;
import com.jsql.util.HeaderUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.JsonUtil;
import com.jsql.util.LogLevel;
import com.jsql.util.ParameterUtil;
import com.jsql.util.PreferencesUtil;
import com.jsql.util.PropertiesUtil;
import com.jsql.util.ProxyUtil;
import com.jsql.util.SoapUtil;
import com.jsql.util.StringUtil;
import com.jsql.util.TamperingUtil;
import com.jsql.util.ThreadUtil;
import com.jsql.util.UserAgentUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionModel
extends AbstractModelObservable
implements Serializable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private transient MediatorVendor mediatorVendor = new MediatorVendor(this);
    private transient MediatorMethod mediatorMethod = new MediatorMethod(this);
    private transient MediatorUtils mediatorUtils;
    private transient MediatorStrategy mediatorStrategy;
    private transient PropertiesUtil propertiesUtil = new PropertiesUtil();
    private transient DataAccess dataAccess = new DataAccess(this);
    private transient ResourceAccess resourceAccess = new ResourceAccess(this);
    public static final String STAR = "*";
    private String indexesInUrl = "";
    private boolean shouldErasePreviousInjection = false;
    private boolean isScanning = false;

    public InjectionModel() {
        this.mediatorUtils = new MediatorUtils();
        this.mediatorStrategy = new MediatorStrategy(this);
        this.mediatorUtils.setCertificateUtil(new CertificateUtil());
        this.mediatorUtils.setPropertiesUtil(this.propertiesUtil);
        this.mediatorUtils.setConnectionUtil(new ConnectionUtil(this));
        this.mediatorUtils.setAuthenticationUtil(new AuthenticationUtil());
        this.mediatorUtils.setGitUtil(new GitUtil(this));
        this.mediatorUtils.setHeaderUtil(new HeaderUtil(this));
        this.mediatorUtils.setParameterUtil(new ParameterUtil(this));
        this.mediatorUtils.setExceptionUtil(new ExceptionUtil(this));
        this.mediatorUtils.setSoapUtil(new SoapUtil(this));
        this.mediatorUtils.setJsonUtil(new JsonUtil(this));
        this.mediatorUtils.setPreferencesUtil(new PreferencesUtil());
        this.mediatorUtils.setProxyUtil(new ProxyUtil(this));
        this.mediatorUtils.setThreadUtil(new ThreadUtil(this));
        this.mediatorUtils.setTamperingUtil(new TamperingUtil());
        this.mediatorUtils.setUserAgentUtil(new UserAgentUtil());
        this.mediatorUtils.setCsrfUtil(new CsrfUtil(this));
        this.mediatorUtils.setFormUtil(new FormUtil(this));
    }

    public void resetModel() {
        this.mediatorStrategy.getNormal().setVisibleIndex(null);
        this.mediatorStrategy.getNormal().setApplicable(false);
        this.mediatorStrategy.getError().setApplicable(false);
        this.mediatorStrategy.getBlind().setApplicable(false);
        this.mediatorStrategy.getTime().setApplicable(false);
        this.indexesInUrl = "";
        this.mediatorUtils.getCsrfUtil().setTokenCsrf(null);
        this.setIsStoppedByUser(false);
        this.shouldErasePreviousInjection = false;
        this.mediatorStrategy.setStrategy(null);
        this.resourceAccess.setReadingIsAllowed(false);
        this.mediatorUtils.getThreadUtil().reset();
    }

    public void beginInjection() {
        this.resetModel();
        try {
            if (!this.mediatorUtils.getProxyUtil().isLive(GitUtil.ShowOnConsole.YES)) {
                return;
            }
            LOGGER.log(LogLevel.CONSOLE_INFORM, "{}: {}", () -> I18nUtil.valueByKey("LOG_START_INJECTION"), () -> this.mediatorUtils.getConnectionUtil().getUrlByUser());
            this.mediatorUtils.getParameterUtil().checkParametersFormat();
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_CONNECTION_TEST"));
            this.mediatorUtils.getConnectionUtil().CookieManager.getCookieStore().removeAll();
            HttpResponse<String> httpResponse = this.mediatorUtils.getConnectionUtil().testConnection();
            if ((httpResponse.statusCode() == 401 || httpResponse.statusCode() == 403) && !this.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies() && this.getMediatorUtils().getPreferencesUtil().isProcessingCsrf()) {
                LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> "Testing handshake from previous connection...");
                httpResponse = this.mediatorUtils.getConnectionUtil().testConnection();
            }
            if (httpResponse.statusCode() >= 400 && !this.getMediatorUtils().getPreferencesUtil().isNotTestingConnection()) {
                throw new InjectionFailureException(String.format("Connection failed: problem when calling %s", httpResponse.uri().toURL().toString()));
            }
            boolean hasFoundInjection = this.mediatorMethod.getQuery().testParameters();
            if (!hasFoundInjection) {
                hasFoundInjection = this.mediatorUtils.getSoapUtil().testParameters();
            }
            if (!hasFoundInjection) {
                LOGGER.log(LogLevel.CONSOLE_DEFAULT, "Checking standard Request parameters");
                hasFoundInjection = this.mediatorMethod.getRequest().testParameters();
            }
            if (!hasFoundInjection) {
                hasFoundInjection = this.mediatorMethod.getHeader().testParameters();
            }
            if (hasFoundInjection && !this.isScanning) {
                if (this.getMediatorUtils().getPreferencesUtil().isZipStrategy()) {
                    LOGGER.log(LogLevel.CONSOLE_INFORM, "Using Zip strategy for minimal query size");
                } else if (this.getMediatorUtils().getPreferencesUtil().isDiosStrategy()) {
                    LOGGER.log(LogLevel.CONSOLE_INFORM, "Using Dump In One Shot strategy for single query dump");
                }
                if (!this.mediatorUtils.getPreferencesUtil().isNotInjectingMetadata()) {
                    this.dataAccess.getDatabaseInfos();
                }
                this.dataAccess.listDatabases();
            }
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_DONE"));
            this.shouldErasePreviousInjection = true;
        }
        catch (JSqlException | IOException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            Request request = new Request();
            request.setMessage(Interaction.END_PREPARATION);
            this.sendToViews(request);
        }
    }

    @Override
    public String inject(String newDataInjection, boolean isUsingIndex, String metadataInjectionProcess) {
        String urlInjection = this.mediatorUtils.getConnectionUtil().getUrlBase();
        String dataInjection = " " + newDataInjection;
        urlInjection = this.mediatorStrategy.buildURL(urlInjection, isUsingIndex, dataInjection);
        urlInjection = StringUtil.clean(urlInjection.trim());
        URL urlObject = null;
        try {
            urlObject = new URL(urlInjection);
        }
        catch (MalformedURLException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Incorrect Query Url: %s", e.getMessage()));
            return "";
        }
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        urlObject = this.initializeQueryString(isUsingIndex, urlInjection, dataInjection, urlObject, msgHeader);
        String pageSource = "";
        try {
            HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(URI.create(urlObject.toString())).setHeader("Content-Type", "text/plain").timeout(Duration.ofSeconds(15L));
            this.mediatorUtils.getCsrfUtil().addHeaderToken(httpRequestBuilder);
            this.mediatorUtils.getConnectionUtil().setCustomUserAgent(httpRequestBuilder);
            this.initializeHeader(isUsingIndex, dataInjection, httpRequestBuilder, msgHeader);
            this.initializeRequest(isUsingIndex, dataInjection, httpRequestBuilder, msgHeader);
            HttpRequest httpRequest = httpRequestBuilder.build();
            HttpResponse<String> response = this.getMediatorUtils().getConnectionUtil().getHttpClient().send(httpRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            pageSource = response.body();
            Map<String, String> headers = ConnectionUtil.getHeadersMap(response);
            msgHeader.put(Header.RESPONSE, headers);
            msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
            int sizeHeaders = headers.keySet().stream().map(key -> ((String)headers.get(key)).length() + key.length()).mapToInt(Integer::intValue).sum();
            float size = (float)(pageSource.length() + sizeHeaders) / 1024.0f;
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            msgHeader.put(Header.PAGE_SIZE, (Object)decimalFormat.format(size));
            if (this.mediatorUtils.getParameterUtil().isRequestSoap()) {
                pageSource = StringUtil.fromHtml(pageSource);
            }
            msgHeader.put(Header.SOURCE, (Object)pageSource.replaceAll("(#){60,}", "$1...").replaceAll("(jIyM){60,}", "$1..."));
            msgHeader.put(Header.METADATA_PROCESS, (Object)metadataInjectionProcess);
            msgHeader.put(Header.METADATA_STRATEGY, (Object)this.mediatorStrategy.getMeta());
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.sendToViews(request);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Error during connection: %s", e.getMessage()));
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return pageSource;
    }

    private URL initializeQueryString(boolean isUsingIndex, String urlInjection, String dataInjection, URL urlObject, Map<Header, Object> msgHeader) {
        Object urlInjectionFixed = urlInjection;
        URL urlObjectFixed = urlObject;
        if (this.mediatorUtils.getParameterUtil().getListQueryString().isEmpty() && !this.mediatorUtils.getPreferencesUtil().isProcessingCsrf()) {
            msgHeader.put(Header.URL, urlInjectionFixed);
            return urlObjectFixed;
        }
        if (!((String)urlInjectionFixed).contains("?")) {
            urlInjectionFixed = (String)urlInjectionFixed + "?";
        }
        urlInjectionFixed = (String)urlInjectionFixed + this.buildQuery(this.mediatorMethod.getQuery(), this.mediatorUtils.getParameterUtil().getQueryStringFromEntries(), isUsingIndex, dataInjection);
        urlInjectionFixed = this.mediatorUtils.getCsrfUtil().addQueryStringToken((String)urlInjectionFixed);
        try {
            urlObjectFixed = new URL((String)urlInjectionFixed);
        }
        catch (MalformedURLException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Incorrect Url: %s", e.getMessage()));
        }
        msgHeader.put(Header.URL, urlInjectionFixed);
        return urlObjectFixed;
    }

    private void initializeHeader(boolean isUsingIndex, String dataInjection, HttpRequest.Builder httpRequest, Map<Header, Object> msgHeader) {
        if (!this.mediatorUtils.getParameterUtil().getListHeader().isEmpty()) {
            Stream.of(this.buildQuery(this.mediatorMethod.getHeader(), this.mediatorUtils.getParameterUtil().getHeaderFromEntries(), isUsingIndex, dataInjection).split("\\\\r\\\\n")).forEach(e -> {
                if (e.split(":").length == 2) {
                    HeaderUtil.sanitizeHeaders(httpRequest, new AbstractMap.SimpleEntry<String, String>(e.split(":")[0], e.split(":")[1]));
                }
            });
        }
    }

    private void initializeRequest(boolean isUsingIndex, String dataInjection, HttpRequest.Builder httpRequest, Map<Header, Object> msgHeader) {
        if (this.mediatorUtils.getParameterUtil().getListRequest().isEmpty() && this.mediatorUtils.getCsrfUtil().getTokenCsrf() == null) {
            return;
        }
        StringBuilder body = new StringBuilder();
        if (this.mediatorUtils.getParameterUtil().isRequestSoap()) {
            httpRequest.setHeader("Content-Type", "text/xml");
        } else {
            httpRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        this.mediatorUtils.getCsrfUtil().addRequestToken(body);
        if (this.mediatorUtils.getConnectionUtil().getTypeRequest().matches("PUT|POST")) {
            if (this.mediatorUtils.getParameterUtil().isRequestSoap()) {
                body.append(this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.getParameterUtil().getRawRequest(), isUsingIndex, dataInjection));
            } else {
                body.append(this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.getParameterUtil().getRequestFromEntries(), isUsingIndex, dataInjection));
            }
        }
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(body.toString());
        httpRequest.method(this.mediatorUtils.getConnectionUtil().getTypeRequest(), bodyPublisher);
        if (this.mediatorUtils.getParameterUtil().isRequestSoap()) {
            msgHeader.put(Header.POST, this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.getParameterUtil().getRawRequest(), isUsingIndex, dataInjection));
        } else {
            msgHeader.put(Header.POST, this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.getParameterUtil().getRequestFromEntries(), isUsingIndex, dataInjection));
        }
    }

    private String buildQuery(AbstractMethodInjection methodInjection, String paramLead, boolean isUsingIndex, String sqlTrail) {
        String paramLeadFixed = paramLead.replace(STAR, "<tampering>*</tampering>");
        String query = this.mediatorUtils.getConnectionUtil().getMethodInjection() != methodInjection || this.mediatorUtils.getConnectionUtil().getUrlBase().contains(STAR) ? paramLeadFixed : (paramLeadFixed.contains(STAR) ? this.initializeStarInjection(paramLeadFixed, isUsingIndex, sqlTrail) : this.initializeRawInjection(paramLeadFixed, isUsingIndex, sqlTrail));
        query = this.clean(methodInjection, query);
        if (this.mediatorUtils.getConnectionUtil().getMethodInjection() == methodInjection) {
            query = this.mediatorUtils.getTamperingUtil().tamper(query);
        }
        query = this.applyRfcEncoding(methodInjection, query);
        return query;
    }

    private String initializeRawInjection(String paramLead, boolean isUsingIndex, String sqlTrail) {
        String query;
        if (!isUsingIndex) {
            query = paramLead + sqlTrail;
            query = query + this.mediatorVendor.getVendor().instance().endingComment();
        } else {
            query = paramLead + this.indexesInUrl.replaceAll("1337" + this.mediatorStrategy.getNormal().getVisibleIndex() + "7331", Matcher.quoteReplacement(sqlTrail));
            query = query + this.mediatorVendor.getVendor().instance().endingComment();
        }
        return query;
    }

    private String initializeStarInjection(String paramLead, boolean isUsingIndex, String sqlTrail) {
        String query = !isUsingIndex ? paramLead.replace(STAR, sqlTrail + this.mediatorVendor.getVendor().instance().endingComment()) : paramLead.replace(STAR, this.indexesInUrl.replace("1337" + this.mediatorStrategy.getNormal().getVisibleIndex() + "7331", sqlTrail) + this.mediatorVendor.getVendor().instance().endingComment());
        return query;
    }

    private String clean(AbstractMethodInjection methodInjection, String query) {
        String queryFixed = query;
        queryFixed = methodInjection == this.mediatorMethod.getRequest() && this.mediatorUtils.getParameterUtil().isRequestSoap() ? queryFixed.replaceAll("(?s)(?!/\\*\\*/|/\\*!.*\\*/)/\\*.*?\\*/", "").replace("+", " ").replace("%2b", "+").replace("%23", "#") : StringUtil.clean(queryFixed);
        return queryFixed;
    }

    private String applyRfcEncoding(AbstractMethodInjection methodInjection, String query) {
        String queryFixed = query;
        if (!this.mediatorUtils.getParameterUtil().isRequestSoap()) {
            if (methodInjection != this.mediatorMethod.getHeader()) {
                if (!this.mediatorUtils.getPreferencesUtil().isUrlEncodingDisabled()) {
                    queryFixed = queryFixed.replace("\"", "%22");
                    queryFixed = queryFixed.replace("'", "%27");
                    queryFixed = queryFixed.replace("(", "%28");
                    queryFixed = queryFixed.replace(")", "%29");
                    queryFixed = queryFixed.replace("{", "%7b");
                    queryFixed = queryFixed.replace("[", "%5b");
                    queryFixed = queryFixed.replace("`", "%60");
                    queryFixed = queryFixed.replace("]", "%5d");
                    queryFixed = queryFixed.replace("}", "%7d");
                    queryFixed = queryFixed.replace(">", "%3e");
                    queryFixed = queryFixed.replace("<", "%3c");
                    queryFixed = queryFixed.replace("?", "%3f");
                    queryFixed = queryFixed.replace("_", "%5f");
                    queryFixed = queryFixed.replace(",", "%2c");
                    queryFixed = queryFixed.replace(" ", "+");
                }
                queryFixed = queryFixed.replace("|", "%7c");
                queryFixed = queryFixed.replace("\\", "%5c");
            } else {
                queryFixed = queryFixed.replace("+", "%20");
                queryFixed = queryFixed.replace(",", "%2c");
            }
        }
        return queryFixed;
    }

    public void sendResponseFromSite(String message, String source) {
        LOGGER.log(LogLevel.CONSOLE_ERROR, "{}, response from site:", (Object)message);
        LOGGER.log(LogLevel.CONSOLE_ERROR, ">>>{}", (Object)source);
    }

    public void displayVersion() {
        String versionJava = System.getProperty("java.version");
        String architecture = System.getProperty("os.arch");
        LOGGER.log(LogLevel.CONSOLE_DEFAULT, "jSQL Injection v{} on Java {}-{}-{}", this::getVersionJsql, () -> versionJava, () -> architecture, () -> System.getProperty("user.language"));
    }

    public String getIndexesInUrl() {
        return this.indexesInUrl;
    }

    public void setIndexesInUrl(String indexesInUrl) {
        this.indexesInUrl = indexesInUrl;
    }

    public boolean shouldErasePreviousInjection() {
        return this.shouldErasePreviousInjection;
    }

    public void setIsScanning(boolean isScanning) {
        this.isScanning = isScanning;
    }

    public String getVersionJsql() {
        return this.propertiesUtil.getProperties().getProperty("jsql.version");
    }

    public MediatorUtils getMediatorUtils() {
        return this.mediatorUtils;
    }

    public MediatorVendor getMediatorVendor() {
        return this.mediatorVendor;
    }

    public MediatorMethod getMediatorMethod() {
        return this.mediatorMethod;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public ResourceAccess getResourceAccess() {
        return this.resourceAccess;
    }

    public MediatorStrategy getMediatorStrategy() {
        return this.mediatorStrategy;
    }
}

