/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.AbstractExtensionFinder;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.processor.LegacyExtensionStorage;

public class LegacyExtensionFinder
extends AbstractExtensionFinder {
    private static final Logger log = LoggerFactory.getLogger(LegacyExtensionFinder.class);

    public LegacyExtensionFinder(PluginManager pluginManager) {
        super(pluginManager);
    }

    @Override
    public Map<String, Set<String>> readClasspathStorages() {
        log.debug("Reading extensions storages from classpath");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        HashSet<String> bucket = new HashSet<String>();
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(LegacyExtensionFinder.getExtensionsResource());
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                log.debug("Read '{}'", (Object)url.getFile());
                InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
                LegacyExtensionStorage.read(reader, bucket);
            }
            this.debugExtensions(bucket);
            result.put(null, bucket);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Map<String, Set<String>> readPluginsStorages() {
        log.debug("Reading extensions storages from plugins");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        List<PluginWrapper> plugins = this.pluginManager.getPlugins();
        for (PluginWrapper plugin : plugins) {
            String pluginId = plugin.getDescriptor().getPluginId();
            log.debug("Reading extensions storage from plugin '{}'", (Object)pluginId);
            HashSet<String> bucket = new HashSet<String>();
            try {
                URL url = ((PluginClassLoader)plugin.getPluginClassLoader()).findResource(LegacyExtensionFinder.getExtensionsResource());
                if (url != null) {
                    log.debug("Read '{}'", (Object)url.getFile());
                    InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
                    LegacyExtensionStorage.read(reader, bucket);
                } else {
                    log.debug("Cannot find '{}'", (Object)LegacyExtensionFinder.getExtensionsResource());
                }
                this.debugExtensions(bucket);
                result.put(pluginId, bucket);
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return result;
    }

    private static String getExtensionsResource() {
        return "META-INF/extensions.idx";
    }
}

