/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import ro.fortsoft.pf4j.BasePluginRepository;
import ro.fortsoft.pf4j.DefaultPluginLoader;
import ro.fortsoft.pf4j.DefaultPluginManager;
import ro.fortsoft.pf4j.ManifestPluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginClasspath;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.PluginLoader;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginRepository;
import ro.fortsoft.pf4j.PropertiesPluginDescriptorFinder;
import ro.fortsoft.pf4j.util.AndFileFilter;
import ro.fortsoft.pf4j.util.DirectoryFileFilter;
import ro.fortsoft.pf4j.util.HiddenFilter;
import ro.fortsoft.pf4j.util.JarFileFilter;
import ro.fortsoft.pf4j.util.NameFileFilter;
import ro.fortsoft.pf4j.util.NotFileFilter;
import ro.fortsoft.pf4j.util.OrFileFilter;

public class JarPluginManager
extends DefaultPluginManager {
    @Override
    protected PluginRepository createPluginRepository() {
        return new JarPluginRepository(this.getPluginsRoot(), this.isDevelopment());
    }

    @Override
    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return this.isDevelopment() ? new PropertiesPluginDescriptorFinder() : new JarPluginDescriptorFinder();
    }

    @Override
    protected PluginLoader createPluginLoader() {
        return new JarPluginLoader(this, this.pluginClasspath);
    }

    class JarPluginLoader
    extends DefaultPluginLoader {
        public JarPluginLoader(PluginManager pluginManager, PluginClasspath pluginClasspath) {
            super(pluginManager, pluginClasspath);
        }

        @Override
        public ClassLoader loadPlugin(Path pluginPath, PluginDescriptor pluginDescriptor) {
            if (JarPluginManager.this.isDevelopment()) {
                return super.loadPlugin(pluginPath, pluginDescriptor);
            }
            PluginClassLoader pluginClassLoader = new PluginClassLoader(this.pluginManager, pluginDescriptor, this.getClass().getClassLoader());
            pluginClassLoader.addFile(pluginPath.toFile());
            return pluginClassLoader;
        }
    }

    class JarPluginDescriptorFinder
    extends ManifestPluginDescriptorFinder {
        JarPluginDescriptorFinder() {
        }

        @Override
        public Manifest readManifest(Path pluginPath) throws PluginException {
            try {
                return new JarFile(pluginPath.toFile()).getManifest();
            }
            catch (IOException e) {
                throw new PluginException(e);
            }
        }
    }

    class JarPluginRepository
    extends BasePluginRepository {
        public JarPluginRepository(Path pluginsRoot, boolean development) {
            super(pluginsRoot);
            if (development) {
                AndFileFilter pluginsFilter = new AndFileFilter(new DirectoryFileFilter());
                pluginsFilter.addFileFilter(new NotFileFilter(this.createHiddenPluginFilter(development)));
                this.setFilter(pluginsFilter);
            } else {
                this.setFilter(new JarFileFilter());
            }
        }

        protected FileFilter createHiddenPluginFilter(boolean development) {
            OrFileFilter hiddenPluginFilter = new OrFileFilter(new HiddenFilter());
            if (development) {
                hiddenPluginFilter.addFileFilter(new NameFileFilter("target"));
            }
            return hiddenPluginFilter;
        }
    }
}

