/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.ManifestPluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginClasspath;
import ro.fortsoft.pf4j.PluginException;

public class DefaultPluginDescriptorFinder
extends ManifestPluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(ManifestPluginDescriptorFinder.class);
    private PluginClasspath pluginClasspath;

    public DefaultPluginDescriptorFinder(PluginClasspath pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Manifest readManifest(Path pluginPath) throws PluginException {
        if (this.pluginClasspath.getClassesDirectories().size() == 0) {
            throw new PluginException("Failed to read manifest, no classes folder in classpath");
        }
        String classes = this.pluginClasspath.getClassesDirectories().get(0);
        Path manifestPath = pluginPath.resolve(Paths.get(classes, "/META-INF/MANIFEST.MF"));
        log.debug("Lookup plugin descriptor in '{}'", (Object)manifestPath);
        if (Files.notExists(manifestPath, new LinkOption[0])) {
            throw new PluginException("Cannot find '{}' path", manifestPath);
        }
        try (InputStream input = Files.newInputStream(manifestPath, new OpenOption[0]);){
            Manifest manifest = new Manifest(input);
            return manifest;
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), e);
        }
    }
}

