/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.fortsoft.pf4j.PluginRepository;
import ro.fortsoft.pf4j.util.FileUtils;

public class BasePluginRepository
implements PluginRepository {
    protected final Path pluginsRoot;
    protected FileFilter filter;

    public BasePluginRepository(Path pluginsRoot) {
        this.pluginsRoot = pluginsRoot;
    }

    public BasePluginRepository(Path pluginsRoot, FileFilter filter) {
        this.pluginsRoot = pluginsRoot;
        this.filter = filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    @Override
    public List<Path> getPluginPaths() {
        File[] files = this.pluginsRoot.toFile().listFiles(this.filter);
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>(files.length);
        for (File file : files) {
            paths.add(file.toPath());
        }
        return paths;
    }

    @Override
    public boolean deletePluginPath(Path pluginPath) {
        try {
            FileUtils.delete(pluginPath);
            return true;
        }
        catch (NoSuchFileException nsf) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

