/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeFlatnessTransformer;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class HyperbolicShapeTransformer
extends HyperbolicTransformer
implements ShapeFlatnessTransformer {
    public HyperbolicShapeTransformer(Component component) {
        this(component, null);
    }

    public HyperbolicShapeTransformer(Component component, MutableTransformer delegate) {
        super(component, delegate);
    }

    public Shape transform(Shape shape) {
        return this.transform(shape, 0.0f);
    }

    public Shape transform(Shape shape, float flatness) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = null;
        iterator = flatness == 0.0f ? shape.getPathIterator(null) : shape.getPathIterator(null, flatness);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._transform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._transform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this._transform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    public Shape inverseTransform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this._inverseTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    private Point2D _transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        Point2D viewPoint = graphPoint;
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar(pointFromCenter);
        double theta = polar.getTheta();
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return viewPoint;
        }
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        radius /= viewRadius;
        radius *= 1.5707963267948966;
        radius = Math.abs(Math.atan(radius));
        Point2D projectedPoint = PolarPoint.polarToCartesian(theta, radius *= viewRadius);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }

    private Point2D _inverseTransform(Point2D viewPoint) {
        viewPoint = this.delegate.inverseTransform(viewPoint);
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar(pointFromCenter);
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return viewPoint;
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        polar.setRadius(radius /= mag);
        Point2D projectedPoint = PolarPoint.polarToCartesian(polar);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }
}

