/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.LayoutDecorator;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.util.Caching;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.CloneTransformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableCachingLayout<V, E>
extends LayoutDecorator<V, E>
implements ChangeEventSupport,
Caching {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected Map<V, Point2D> locationMap;

    public ObservableCachingLayout(Layout<V, E> delegate) {
        super(delegate);
        this.locationMap = LazyMap.decorate(new HashMap(), new ChainedTransformer(new Transformer[]{delegate, CloneTransformer.getInstance()}));
    }

    @Override
    public void step() {
        super.step();
        this.fireStateChanged();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.fireStateChanged();
    }

    @Override
    public boolean done() {
        if (this.delegate instanceof IterativeContext) {
            return ((IterativeContext)((Object)this.delegate)).done();
        }
        return true;
    }

    @Override
    public void setLocation(V v, Point2D location) {
        super.setLocation(v, location);
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    @Override
    public void clear() {
        this.locationMap.clear();
    }

    @Override
    public void init() {
    }

    @Override
    public Point2D transform(V v) {
        return this.locationMap.get(v);
    }
}

