/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.plugins.JNetMapPlugin;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.IView;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.preferences.AppearancePanel;
import ch.rakudave.jnetmap.view.preferences.GeneralPanel;
import ch.rakudave.jnetmap.view.preferences.LoggingPanel;
import ch.rakudave.jnetmap.view.preferences.PluginPanel;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import ch.rakudave.jnetmap.view.preferences.ScriptsPanel;
import ch.rakudave.jnetmap.view.preferences.ToolBarPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.pf4j.PluginWrapper;

public class Preferences
extends EscapableDialog {
    private static final long serialVersionUID = 6209354869982252918L;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private JPanel container;
    private IView parent;

    public Preferences(IView parent) {
        super((Window)((Object)parent), Lang.getNoHTML("menu.edit.preferences"));
        this.setMinimumSize(new Dimension(550, 660));
        this.setPreferredSize(new Dimension(550, 660));
        this.setLayout(new BorderLayout());
        this.parent = parent;
        CardLayout cl = new CardLayout();
        this.container = new JPanel(cl);
        if (this.rootNode.getChildCount() == 0) {
            this.addCard(new GeneralPanel((Window)((Object)parent)));
            this.addCard(new AppearancePanel((Window)((Object)parent), this));
            this.addCard(new ToolBarPanel());
            this.addCard(new PluginPanel());
            for (PluginWrapper wrapper : Controller.getPluginManager().getPlugins()) {
                JNetMapPlugin plugin;
                if (!(wrapper.getPlugin() instanceof JNetMapPlugin) || !(plugin = (JNetMapPlugin)wrapper.getPlugin()).hasSettings()) continue;
                PreferencePanel panel = plugin.getSettingsPanel();
                panel.title = plugin.getPluginName();
                panel.parentTitle = Lang.getNoHTML("preferences.plugins");
                this.addCard(panel);
            }
            this.addCard(new ScriptsPanel());
            this.addCard(new LoggingPanel());
        }
        JTree tree = new JTree(this.rootNode);
        tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tree.setRootVisible(false);
        tree.addTreeSelectionListener(tse -> {
            TreeCard node = (TreeCard)((DefaultMutableTreeNode)tse.getPath().getLastPathComponent()).getUserObject();
            if (node.nodePanel != null) {
                String cardLayoutID = node.ID;
                cl.show(this.container, cardLayoutID);
            }
        });
        JPanel bottomRow = new JPanel();
        bottomRow.setLayout(new BoxLayout(bottomRow, 2));
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.setMaximumSize(new Dimension(120, 30));
        cancel.setPreferredSize(new Dimension(120, 30));
        cancel.addActionListener(e -> this.dispose());
        JButton apply = new JButton(Lang.get("action.apply"), Icons.get("right"));
        apply.setMaximumSize(new Dimension(120, 30));
        apply.setPreferredSize(cancel.getPreferredSize());
        apply.addActionListener(e -> {
            this.save();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
        ok.setMaximumSize(new Dimension(120, 30));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(e -> {
            this.save();
            this.dispose();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        bottomRow.add(Box.createHorizontalStrut(2));
        bottomRow.add(apply);
        bottomRow.add(Box.createHorizontalGlue());
        bottomRow.add(cancel);
        bottomRow.add(Box.createHorizontalStrut(5));
        bottomRow.add(ok);
        bottomRow.add(Box.createHorizontalStrut(2));
        this.add((Component)new JScrollPane(tree), "West");
        this.add((Component)this.container, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        this.setVisible(true);
    }

    public void addCard(PreferencePanel card) {
        TreeCard newCard = new TreeCard(card.getTitle(), card.getParentTitle(), card);
        DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(newCard);
        if (card.getParentTitle().isEmpty()) {
            this.rootNode.add(mtn);
        } else {
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                Enumeration<TreeNode> tree = this.rootNode.breadthFirstEnumeration();
                tree.nextElement();
                while (tree.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)tree.nextElement();
                    if (!((TreeCard)child.getUserObject()).nodeName.equals(card.getParentTitle())) continue;
                    child.add(mtn);
                    return;
                }
            }
            Logger.error("No parent named " + card.getParentTitle() + " was found!");
        }
    }

    protected void save() {
        Enumeration<TreeNode> tree = this.rootNode.preorderEnumeration();
        tree.nextElement();
        while (tree.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)tree.nextElement();
            TreeCard card = (TreeCard)child.getUserObject();
            try {
                card.nodePanel.save();
            }
            catch (Exception e) {
                Logger.error("Preferences of '" + card.nodeName + "' could not be saved", e);
            }
        }
        Settings.save();
    }

    @Override
    public void setVisible(boolean b) {
        SwingHelper.centerTo((Window)((Object)this.parent), this);
        super.setVisible(b);
    }

    private class TreeCard {
        private String nodeName;
        private String ID;
        private PreferencePanel nodePanel;

        public TreeCard(String title, String parent, PreferencePanel panel) {
            this.nodeName = title;
            this.ID = parent.isEmpty() ? this.nodeName : parent + " - " + this.nodeName;
            this.nodePanel = panel;
            this.nodePanel.setBorder(BorderFactory.createTitledBorder(this.ID));
            Preferences.this.container.add(this.ID, this.nodePanel);
        }

        public String toString() {
            return this.nodeName;
        }
    }
}

